#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define MAXERR    5
extern int  *E_stack;
extern int   E_stacknum;

void prierr(int typerr,int indice) {
  int         level;
  static int  olderr=0,nberr=0;

  /* print only one message */
  if ( typerr == ERR )
    yerr.lerror = TRUE;
  else if ( typerr == WAR )
    yerr.lerror = FALSE;
  else
    return;

  yerr.coderr = indice;
  level = yerr.coderr / 1000;
  if ( yerr.coderr == olderr  ) {
    ++nberr;
    if ( nberr == MAXERR+1 ) {
      fprintf(stderr,"  -- NO MORE ERROR PRINTING.\n");
      return;
    }
    else if ( nberr > MAXERR+1 )  return;
  }
  else {
    nberr  = 1;
    olderr = yerr.coderr;
  }

  if ( typerr == ERR )
    fprintf(stdout,"  ## ERR %.4d, %s, ",yerr.coderr,E_name());
  else if ( typerr == WAR )
    fprintf(stdout,"  ## WAR %.4d, %s, ",yerr.coderr,E_name());
  fflush(stdout);

  if ( level == 0 ) {
    switch (yerr.coderr) {
    case 0000:
      fprintf(stdout,"WRONG DATA TYPE, %d.\n",yerr.inderr[0]);
      return;
    case 0001:
      fprintf(stdout,"NO INPUT DATA.\n");
      return;
    case 0002:
      fprintf(stdout,"NOT ENOUGH MEMORY.\n");
      return;
    case 0003:
      fprintf(stdout,"WRONG FILE NAME.\n");
      return;
    case 0004:
      fprintf(stdout,"DATA NOT CONSIDERED.\n");
      return;
    case 0005:
      fprintf(stdout,"UNABLE TO OPEN FILE.\n");
      return;
    
    case 0010:
      fprintf(stdout,"NORMAL (%d) AT VERTEX (%d) DISCARDED.\n",
	      yerr.inderr[0],yerr.inderr[1]);
      return;
    case 0011:
      fprintf(stdout,"NORMAL AT TRIANGLE (%d) VERTEX (%d) DISCARDED.\n",
	      yerr.inderr[0],yerr.inderr[1]);
      return;

    case 0020:
      fprintf(stdout,"FACE %d DISCARDED.\n",yerr.inderr[0]);
      return;
    case 0021:
      fprintf(stdout,"EDGE(S) IGNORED.\n");
      return;
    case 0022:
      fprintf(stdout,"%d FACES DISCARDED\n",yerr.inderr[0]);
      return;
    case 0023:
      fprintf(stdout,"BUCKET NOT USED\n");
      return;

    case 0030:
      fprintf(stdout,"MEMORY REALLOC PROBLEM.\n");
      return;
    case 0031:
      fprintf(stdout,"NOT ENOUGH MEMORY (HASH).\n");
      return;
    case 0032:
      fprintf(stdout,"NOT ENOUGH MEMORY (NORMALS)\n");
      return;
    case 0033:
      fprintf(stdout,"NOT ENOUGH MEMORY (TANGENTS)\n");
      return;
    case 0034:
      fprintf(stdout,"NOT ENOUGH MEMORY (HEAP)\n");
      return;
    }
  }

  else if ( level == 1 ) {
    switch (yerr.coderr) {
    case 1001:
      fprintf(stdout,"EDGE PROBLEM, (%d, %d: %d)\n",
              yerr.inderr[0],yerr.inderr[1],yerr.inderr[2]);
      return;
    case 1010:
      fprintf(stdout,"ADJACENCY PROBLEM, (%d, %d)\n",yerr.inderr[0],yerr.inderr[1]);
      return;
    case 1011:
      fprintf(stdout,"ORIENTATION PROBLEM, %d\n",yerr.inderr[0]);
      return;
    case 1012:
      fprintf(stdout,"WRONG TOPOLOGY.\n");
      return;
    case 1013:
      fprintf(stdout,"EDGE FLIP PROBLEM, (%d, %d).\n",yerr.inderr[0],yerr.inderr[1]);
      return;
    case 1014:
      fprintf(stdout,"WRONG EDGE TOPOLOGY, (%d, %d).\n",yerr.inderr[0],yerr.inderr[1]);
      return;
    case 1015:
      fprintf(stdout,"EDGE NOT CORRECTLY HASHED.\n");
      return;
    case 1020:
      fprintf(stdout,"NO ROOT FOR COMPONENT %d\n",yerr.inderr[0]);
      return;
    }
  }

  else if ( level == 4 ) {
    switch (yerr.coderr) {
    case 4000:
      fprintf(stdout,"UNABLE TO CREATE NEW POINT (%d, %d).\n",
	      yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4001:
      fprintf(stdout,"UNABLE TO CREATE NEW TRIANGLE (%d, %d).\n",
	      yerr.inderr[0],yerr.inderr[1]);
      return;    
    case 4006:
      fprintf(stdout,"POOR SHAPE QUALITY, %d.\n",yerr.inderr[0]); 
      return;
    case 4007:
      fprintf(stdout,"SURFACE TOO SMALL, (%E, %d).\n",
              yerr.cooerr[0],yerr.inderr[0]);
      return;
    case 4008:
      fprintf(stdout,"SMALL INRADIUS, (%E, %d).\n",
              yerr.cooerr[0],yerr.inderr[0]);
      return;
    case 4009:
      fprintf(stderr,"INVALID QUAD %d\n",yerr.inderr[0]);
      return;
 
    case 4010:
      fprintf(stdout,"CURVE TANGENT DEVIATION %.2f deg (%d, %d).\n",
              acos(yerr.cooerr[0])*180/M_PI,yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4011:
      fprintf(stdout,"NORMAL VARIATION,  (%d, %g deg).\n",
	      yerr.inderr[0],acos(yerr.cooerr[0])*180./M_PI);
      return;
    case 4012:
      fprintf(stdout,"INCONSISTENT BALL OF VERTEX, %d.\n",yerr.inderr[0]);
      return;
    case 4013:
      fprintf(stdout,"CORNER / NORMAL  %d\n",yerr.inderr[0]);
      return;
    case 4014:
      fprintf(stdout,"ANGULAR DEFECT %.2f deg (%d, %d).\n",
              acos(yerr.cooerr[0])*180/M_PI,yerr.inderr[0],yerr.inderr[1]);
      return;
    case 4015:
      fprintf(stdout,"%d CORNER IMPOSED.\n",yerr.inderr[0]);
      return;
    case 4016:
      fprintf(stdout,"%d TANGENT MODIFIED.\n",yerr.inderr[0]);
      return;
    }
  }

  else if ( level == 8 ) {
    switch(yerr.coderr) {
    case 8000:
      fprintf(stdout,"UNABLE TO SAVE MESH FILE.\n");
      return;
    case 8001:
      fprintf(stdout,"UNABLE TO SAVE METRIC FILE.\n");
      return;
    case 8002:
      fprintf(stdout,"CURRENT MESH NOT SAVED.\n");
      return;
    }
  }

  else if ( level == 9 ) {
    switch (yerr.coderr) {
    case 9900:
      fprintf(stdout,"ABNORMAL STOP.\n");
      fprintf(stdout,"  %%%% CONTACT HOT LINE.\n");
      fprintf(stdout,"  -- CURRENT MESH NOT SAVED.\n");
      return;
    case 9901:
      fprintf(stdout,"FLOATING-POINT EXCEPTION.\n");
      fprintf(stdout,"  %%%% CONTACT HOT LINE.\n");
      fprintf(stdout,"  -- CURRENT MESH NOT SAVED.\n");
      return;
    case 9902:
      fprintf(stdout,"ILLEGAL INSTRUCTION.\n");
      fprintf(stdout,"  %%%% CONTACT HOT LINE.\n");
      fprintf(stdout,"  -- CURRENT MESH NOT SAVED.\n");
      return;
    case 9903:
      fprintf(stdout,"SEGMENTATION FAULT.\n");
      fprintf(stdout,"  %%%% CONTACT HOT LINE.\n");
      fprintf(stdout,"  -- CURRENT MESH NOT SAVED.\n");
      return;
    case 9904:
      fprintf(stdout,"PROGRAM KILLED.\n");
      fprintf(stdout,"  -- CURRENT MESH NOT SAVED.\n");
      return;
    }
  }

  fprintf(stderr,"  ## ERROR CODE NOT FOUND %d %d\n",indice,yerr.coderr);
  exit(2);
}
