#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int prichk(pSurfMesh sm) {
  pTriangle  pt;
  pPoint     p1,p2;
  float     *ch;
  double     choc,tail,ax,ay,az,dd,dh,rap,lograp,cavg,maxch,minch;
  int        k,ne,navg,hc[11];
  ubyte      i,i1,i2;
  static double bd[11] = {0.0, 1.0, SQRT2, 2.0, 2.0*SQRT2, 4.0, 4.0*SQRT2, 
                          8.0, 8.0*SQRT2, 16.0, 16.0*SQRT2 };

  /* default */
  E_put("prichk");
  for (k=1; k<=10; k++)  hc[k] = 0.0;

  ch = (float*)malloc((sm->np+1)*sizeof(float));
  if ( !ch )  return(0);
  for (k=1; k<=sm->np; k++)  ch[k] = 0.0;

  minch = maxch = cavg = 0.0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    ne++;

    if ( opts.ctrl & ISO )
      for (i=0; i<3; i++) {
        /*if ( pt->adj[i] > k )  continue;*/
        i1 = idir[i+1];
        i2 = idir[i+2];
        p1 = &sm->point[pt->v[i1]];
        p2 = &sm->point[pt->v[i2]];
        /* swap vertices */
        if ( p1->size > p2->size ) {
          p1 = &sm->point[pt->v[i2]];
          p2 = &sm->point[pt->v[i1]];
        }

        /* compute edge size */
        ax = p2->c[0] - p1->c[0];
        ay = p2->c[1] - p1->c[1];
        az = p2->c[2] - p1->c[2];

        rap = p2->size / p1->size;
        dh  = rap - 1.0f;
	dd  = sqrt(ax*ax + ay*ay + az*az);

	lograp = log(rap);
	tail   = dd * dh / (p2->size*lograp);
        choc   = exp(lograp/tail);
        if ( choc > maxch )  maxch = choc;
        if ( choc < minch )  minch = choc;
        ch[pt->v[i1]] = max(ch[pt->v[i1]],choc);
        ch[pt->v[i2]] = max(ch[pt->v[i2]],choc);
      }
    }

  navg = 0;
  for (k=1; k<=sm->np; k++) {
    p1 = &sm->point[k];
    if ( p1->tag & M_UNUSED )  continue;
    navg++;
    cavg += ch[k];
    if ( ch[k] > bd[10] )
      hc[10]++;
    else
      for (i=10; i>=1; i--)
        if ( ch[k] > bd[i] ) {
          hc[i]++;
          break;
        }
  }

  if ( abs(imprim) > 1 ) {
    fprintf(stdout,"\n  -- RESULTING H-SHOCKS  %d\n",navg);
    if ( cavg < 1.e08 ) {
      fprintf(stdout,"     AVERAGE SHOCK    %12.4f\n",cavg / (float)navg);
      fprintf(stdout,"     LARGEST SHOCK    %12.4f\n",maxch);
    }
    for (k=1; k<10; k++) {
      fprintf(stdout,"   %6.2f < C <%5.2f  %8d   %5.2f %%\n",
              bd[k],bd[k+1],hc[k], 100.*(hc[k]/(float)navg));
      if ( bd[k+1] > maxch )  break;
    }
    if ( hc[10] )
      fprintf(stdout,"   %6.2f < C         %8d   %5.2f %%\n",
              bd[10],hc[10], 100.*(hc[10]/(float)navg));

    fprintf(stdout,"\n");
  }

  free(ch);
  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
