#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* write standard option file */
int saveop(pSurfMesh sm) {
  FILE   *out;
  time_t  timeptr;

  out = fopen(DEFAULT_FILE,"w");
  if ( !out ) {
    fprintf(stderr,"  ## UNABLE TO WRITE %s\n",DEFAULT_FILE);
    return(0);
  }

  /* create standard parameter file */
  fprintf(out,"#  Generated by YAMS %s\n",VERSION);
  fprintf(out,"#  Uncomment next if absolute unit desired\n");
  fprintf(out,"#Absolute\n");

  fprintf(out,"#  Tangent plane deviation\n");
  fprintf(out,"GeomApp\n%7.3f\n",opts.eps);
  fprintf(out,"#  Chordal deviation control\n");
  fprintf(out,"Tolerance\n%7.3f\n",opts.bande);
  fprintf(out,"#  Angular feature detection\n");
  if ( opts.ridge > 0.0 )
    fprintf(out,"Ridge\n%7.3f\n",180.*acos(opts.ridge)/M_PI);
  fprintf(out,"#  Mesh density control\n");
  fprintf(out,"Gradation\n%7.3f\n",opts.shock);
  fprintf(out,"#  Desired size bounds at vertices\n");
  fprintf(out,"MinSize\n%7.3f\n",opts.hmin);
  fprintf(out,"MaxSize\n%7.3f\n",opts.hmax);
  fprintf(out,"NbIter\n%d\n",opts.iter);
  /* append date of creation */
  if ( time(&timeptr) )
    fprintf(out,"# Created: %s",ctime(&timeptr));
  fclose(out);

  return(1);
}

void priopt(int option) {

  if ( opts.ctrl & REL ) 
    fprintf(stdout,"\n  ** OPTIONS SPECIFIED\n");
  else
    fprintf(stdout,"\n  ** OPTIONS SPECIFIED:   Absolute units\n");
  fprintf(stdout,"     Geom. approx:  %5.2f  (%6.2f deg)",
	  opts.eps,180.*asin(opts.alpha)/M_PI);
  fprintf(stdout,"     Tolerance   :  %5.2f\n",opts.bande);
  fprintf(stdout,"     Ridge angle :  %5.2f  (%6.2f deg)",
	  opts.ridge,180.*acos(opts.ridge)/M_PI);
  fprintf(stdout,"     Geom. angle :  %5.2f  (%6.2f deg)\n",
	  opts.geom,180.*acos(opts.geom)/M_PI);
  fprintf(stdout,"     Sizes    min:  %5.2f  max:  %6.2f",
	  opts.hmin,opts.hmax);
  fprintf(stdout,"     Gradation   :  %5.2f\n",opts.shock);
}

int parsop(pSurfMesh sm,char *filein) {
  FILE      *in;
  float      dummy,dummy1,ridge = RIDG;
  int        i,ret,dumint;
  char      *ptr,data[256],key[256];

  /* check if user-specified parameters */
  E_put("parsop");
  strcpy(data,filein);
  ptr = strstr(data,".mesh");
  if ( ptr ) *ptr = '\0';
  in = NULL;
  if ( !strstr(data,".yams") ) {
    strcat(data,".yams");
    in = fopen(data,"r");
  }

  if ( !in ) {
    /* check for default file */
    sprintf(data,"%s",DEFAULT_FILE);
    in = fopen(data,"r");
    if ( !in ) {
      fprintf(stderr,"  %%%% NO PARAMETER FILE FOUND.");
      fprintf(stdout," USE DEFAULT VALUES\n");
      E_pop();
      return(1);
    }
  }
  if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  while ( !feof(in) ) {
    ret = fscanf(in,"%s",key);
    if ( !ret || feof(in) )  break;
    for (i=0; i<strlen(key); i++) key[i] = tolower(key[i]);

    if ( !strcmp(key,"decimcontrolversion") ) {
      fprintf(stderr,"  ## OLD VERSION\n");
      fprintf(stderr,"     FILE %s  RENAMED  %s\n",data,"DEFAULT.yams.old");
      fclose(in);
      rename(data,"DEFAULT.yams.old");
      break;
    }
    else if ( !strcmp(key,"minsize") ) {
      fscanf(in,"%f",&dummy);
      opts.hmin = dummy;
    }
    else if ( !strcmp(key,"maxsize") ) {
      fscanf(in,"%f",&dummy);
      opts.hmax = dummy;
    }
    else if ( !strcmp(key,"tolerance") ) {
      fscanf(in,"%f",&dummy);
      opts.bande = fabs(dummy);
    }
    else if ( !strcmp(key,"geomapp") ) {
      fscanf(in,"%f",&dummy);
      opts.eps = fabs(dummy);
    }
    else if ( !strcmp(key,"ridge") ) {
      fscanf(in,"%f",&ridge);
      if ( ridge < 0.0 )  sm->type &= ~M_DETECT;
    }
    else if ( !strcmp(key,"gradation") ) {
      fscanf(in,"%f",&dummy);
      opts.shock = dummy;
    }
    else if ( !strcmp(key,"degrad") ) {
      fscanf(in,"%f",&dummy);
      opts.degrad = dummy;
    }
    else if ( !strcmp(key,"absolute") ) {
      opts.ctrl &= ~REL;
    }
    else if ( !strcmp(key,"aniso") ) {
      opts.ctrl &= ~ISO;
    }
    else if ( !strcmp(key,"nbiter") ) {
      fscanf(in,"%d",&dumint);
      opts.iter = max(dumint,1);
    }
    else if ( !strcmp(key,"walton") ) {
      fscanf(in,"%f",&dummy);
      opts.walton = cos(dummy/180.0*M_PI);
    }
    else if ( !strcmp(key,"declic") ) {
      fscanf(in,"%f",&dummy);
      if ( dummy > 0.95 )  dummy = 1.0;
      if ( dummy < 0.01 )  dummy = 0.01;
      opts.declic = dummy / BETAC;
    }
    else if ( !strcmp(key,"lambdamu") ) {
      fscanf(in,"%f %f",&dummy,&dummy1);
      opts.lambda = dummy;
      opts.mu     = dummy1;
    }
    else if ( key[0] == '#' ) {
      fgets(key,255,in);
    }
    else fprintf(stderr,"  ** unrecognized keyword : %s\n",key);
  }
  fclose(in);

  /* check parameters consistency */
  if ( ridge < 0.0 || !(sm->type & M_DETECT) )
    opts.ridge = -1.0;
  else
    opts.ridge  = cos(ridge*M_PI / 180.0);
  opts.degrad = min(opts.degrad,1.0);
  opts.degrad = max(opts.degrad,0.001);

  /* bound values */
  opts.alpha = sqrt(opts.eps * (2.-opts.eps));
  opts.gap   = 1.0 - opts.eps;
  if ( opts.walton < COS45DEG )  opts.walton = COS45DEG;

  E_pop();
  return(1);
}
