#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern ubyte ecp;


static void usage(char *name) {
  fprintf(stdout,"\nUsage: %s [-v [n]] [-h] [-m [n]] [opts..] filein [fileout]\n",name);

  fprintf(stdout,"\n** Generic options :\n");
  fprintf(stdout,"-h      Print this message\n");
  fprintf(stdout,"-v [n]  Turn on numerical information, [-10..10]\n");
  fprintf(stdout,"-m [n]  Set memory size to n Mbytes\n");

  fprintf(stdout,"\n");
  fprintf(stdout,"-O [n]  Optimization level :\n");
  fprintf(stdout,"  n < 0   Decimation\n");
  fprintf(stdout,"  n > 0   Decimation + Enrichment\n");
  fprintf(stdout,"  n = 0   Optimization (smooth+swap)\n");
  fprintf(stdout,"  -1, 1     use metric map\n");
  fprintf(stdout,"  -2, 2     Hausdorff-like\n");
  fprintf(stdout,"      4   Split triangles recursively\n");
  fprintf(stdout,"      9   No-Shrinkage Vertex Smoothing\n");

  fprintf(stdout,"\n** Misc. options\n");
  fprintf(stdout,"-A      Anisotropy\n");
  fprintf(stdout,"-c [n]  Save connected component n\n");
  fprintf(stdout,"-eps    Specify geometric approximation value\n");
  fprintf(stdout,"-hmin   Specify minimal size\n");
  fprintf(stdout,"-hmax   Specify maximal size\n");
  fprintf(stdout,"-hgrad  Specify gradation value\n");
  fprintf(stdout,"-nm     Create point on straight edge (no mapping)\n");
  fprintf(stdout,"-np     Specify number of points desired\n");
  fprintf(stdout,"-nq     Output quads\n");
  fprintf(stdout,"-nr     No ridge detection\n");
  fprintf(stdout,"-ns     No point smoothing\n");
  fprintf(stdout,"-ref    Ignore face references\n");
  fprintf(stdout,"-fem    No Finite Element correction\n");
  fprintf(stdout,"-mp     Split multiple connected points\n");
  fprintf(stdout,"-nc     No validity check during smoothing (opt. 9)\n");

  fprintf(stdout,"\n** Output file options :\n");
  fprintf(stdout,"-e      Extended output file\n");
  fprintf(stdout,"-f      Formatted (ascii) output file\n");
  fprintf(stdout,"-msh2   Save 'xxx.points', 'xxx.faces'\n");
  fprintf(stdout,"-vrml   Save VRML 1.0 file\n");
  fprintf(stdout,"-b      Save metric file\n");
  fprintf(stdout,"-no     No output file\n");

  fprintf(stdout,"\n");
  fprintf(stdout,"filein  triangulation input file\n");
  fprintf(stdout,"fileout output mesh file (default= 'filein.d')\n");

  exit(1);
}

/* used by SIMULOG */
#ifdef DISTRIB
extern int keycode;
#endif


void parsar(pSurfMesh sm,int argc,char *argv[],int *mem,int *choix) {
  int  i=1;

  /* default */
  E_put("parsar");
  opts.noreff = 0;
  opts.ffem   = 1;
  opts.ptmult = 0;

  while ( i < argc ) {
    if ( *argv[i] == '-' ) {
      switch(argv[i][1]) {
      case 'A':
        opts.ctrl ^= ISO;
        break;

      /* file options */
      case 'i':
	      if ( !strcmp(argv[i],"-in") ) {
	        if ( ++i < argc ) {
			      sm->infile = argv[i];
			      if ( imprim == -99 )  imprim = 5;
		      }
		      else
			      i--;
		    }
		    else if ( !strcmp(argv[i],"-iso") ) {
			    if ( ++i < argc ) {
				    opts.iso = atof(argv[i]);
				  }
				  else
						i--;
			  }
	    break;

      case 'o':
	    if ( !strcmp(argv[i],"-out") ) {
	      if ( ++i < argc ) {
			sm->outfile = argv[i];
			if ( imprim == -99 )  imprim = 5;
		  }
		  else
			i--;
		}
	    break;

      case 'e':  /* extended output file */
        if ( !strcmp(argv[i],"-ecp") ) {
          ecp = 1;
          sm->type &= ~M_BINARY;
        }
        else if ( !strcmp(argv[i],"-eps") ) {
          if ( ++i < argc ) {
	          if ( isdigit(argv[i][0]) )  opts.eps = atof(argv[i]);
	        }
          else
	          i--;
	      }
	      else
	        sm->type |= M_EXTEND;
	    break;

      case 'f':  /* formatted ascii output file */
	    if ( !strcmp(argv[i],"-fem") )
          opts.ffem = 0;
        else
          sm->type &= ~M_BINARY;
        break;

      case 'b':  /* save metric file */
	    sm->type |= M_METRIC;
	    break;

      case 'm':
	    if ( !strcmp(argv[i],"-msh2") ) {
	      sm->type |=  M_MSH2;
	      sm->type &= ~M_BINARY;
	      sm->type &= ~M_EXTEND;
    	}
	    else if ( !strcmp(argv[i],"-mp") ) {
	      opts.ptmult = 1;
    	}
	    else if ( ++i < argc ) {
	      if ( isdigit(argv[i][0]) )
	        *mem = atoi(argv[i]);
	      else
	        i--;
	    }
	    else {
	      fprintf(stderr,"Missing argument option %c\n",argv[i-1][1]);
	      usage(argv[0]);
	    }
	  break;

      case 'c':  /* connected component */
	    if ( ++i < argc )
	      if ( argv[i][0] == '-' || isdigit(argv[i][0]) )
	        sm->connex = atoi(argv[i]);
	      else 
	        i--;
	    else {
	      sm->connex = -1;
	      /*fprintf(stderr,"Missing argument option %c\n",argv[i-1][1]);
	      usage(argv[0]);*/
	    }
	  break;

      case 'v':  /* print level */
        if ( !strcmp(argv[i],"-vrml") ) {
	      sm->type |=  M_VRML;
	      sm->type &= ~M_BINARY;
	      sm->type &= ~M_EXTEND;
	    }
        else if ( ++i < argc ) {
	      if ( argv[i][0] == '-' || isdigit(argv[i][0]) )
	        imprim = atoi(argv[i]);
	      else 
	        i--;
	    }
	    else {
	      fprintf(stderr,"Missing argument option %c\n",argv[i-1][1]);
	      usage(argv[0]);
	    }
	  break;

      case 'n':
	    if ( !strcmp(argv[i],"-nm") )
	      sm->type &= ~M_QUERY;
	    else if ( !strcmp(argv[i],"-nc") )
	      opts.check = 0;
	    else if ( !strcmp(argv[i],"-np") ) {
	      if ( ++i < argc ) {
	        if ( isdigit(argv[i][0]) )   opts.minnp = atoi(argv[i]);
	        else
	          i--;
	      }
        }
	    else if ( !strcmp(argv[i],"-nit") ) {
	      if ( ++i < argc ) {
	        if ( isdigit(argv[i][0]) )   opts.iter = atoi(argv[i]);
	        else
	          i--;
	      }
        }
	    else if ( !strcmp(argv[i],"-nq") )
	      sm->type |= M_QUADS;
	    else if ( !strcmp(argv[i],"-nr") )
	      sm->type &= ~M_DETECT;
	    else if ( !strcmp(argv[i],"-ns") )
	      sm->type &= ~M_SMOOTH;
	    else if ( !strcmp(argv[i],"-no") )
	      sm->type &= ~M_OUTPUT;
	    else {
	      fprintf(stderr,"Unrecognized option ignored %s\n",argv[i]);
	      usage(argv[0]);
	    }
	  break;

      case 'r':
        if ( !strcmp(argv[i],"-ref") )
	        opts.noreff = 1;
        break;

      case 'l':
        if ( !strcmp(argv[i],"-lambdamu") && i+2 < argc ) {
	        opts.lambda = atof(argv[++i]);
		      opts.mu     = atof(argv[++i]);
	     	}
        break;

      case 'O': /* set optim option */
	    *choix = 0;
	    if ( ++i < argc ) {
	      if ( (argv[i][0] == '-' && isdigit(argv[i][1])) || argv[i][0]== '0' )
	        *choix = atoi(argv[i]);
	      else if ( isdigit(argv[i][0]) )
	        *choix = atoi(argv[i]);
	      else
	        i--;
	    }
	  break;

      case 'h':
        if ( !strcmp(argv[i],"-hgrad") ) {
          if ( ++i < argc ) {
	        if ( isdigit(argv[i][0]) )
	          opts.shock = atof(argv[i]);
            else if ( argv[i][0]=='-' )
              opts.shock = atof(argv[i]);
          }
          else
	        i--;
        }
	    else if ( !strcmp(argv[i],"-hmin") ) {
	      if ( ++i < argc ) {
	        if ( isdigit(argv[i][0]) )
	          opts.hmin = atof(argv[i]);
	      }
          else
	        i--;
	    }
  	    else if ( !strcmp(argv[i],"-hmax") ) {
	      if ( ++i < argc ) {
	        if ( isdigit(argv[i][0]) )
	          opts.hmax = atof(argv[i]);
	      }
          else
	        i--;
       }
       else
          usage(argv[0]);
      break;

      case '?':
	    usage(argv[0]);
    	break;

      default:
	    fprintf(stderr,"Unrecognized option %s\n",argv[i]);
	    usage(argv[0]);
      }
    }
    else {
      if ( sm->infile == NULL ) {
	    sm->infile = argv[i];
	    if ( imprim == -99 )  imprim = 5;
      }
      else if ( sm->outfile == NULL )
	    sm->outfile = argv[i];
      else {
	    fprintf(stderr,"Argument %s ignored\n",argv[i]);
	    usage(argv[0]);
      }
    }
    i++;
  }

  E_pop();
}
