/* 
 *  write out mesh fil ein VRML format
 *
 *  Written by Pascal J. Frey, 2000.
 *  email: Pascal.Frey@inria.fr
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int outwrl(pSurfMesh sm,char *fileout) {
  FILE      *out;
  pPoint     ppt;
  pTriangle  pt1;
  int        k,np,ne;


  /* mark connected component */
  E_put("outwrl");
  ne = 0;
  if ( sm->connex > 0 ) {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      ppt->tag |= M_UNUSED;
    }
    for (k=1; k<=sm->ne; k++) {
      pt1 = &sm->tria[k];
      if ( pt1->v[0] > 0 && pt1->cc == sm->connex ) {
	ne++;
	ppt = & sm->point[pt1->v[0]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[1]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[2]];
	ppt->tag &= ~M_UNUSED;
      }
    }
  }

  /* mark used vertices */
  np = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    if ( ppt->tag & M_UNUSED )  continue;
    ppt->tmp = ++np;
  }

  /* open 'xxx.points' file */
  out = fopen(fileout,"w");
  if ( !out ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",fileout);

  /* write mesh vertices */
  fprintf(out,"#VRML V1.0 ascii\n");
  fprintf(out,"Separator {\n");
  fprintf(out,"Coordinate3 {\n");
  fprintf(out,"point [\n");

  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED )  continue;
    fprintf(out,"  %f %f %f,\n",ppt->c[0],ppt->c[1],ppt->c[2]);
  }
  fprintf(out,"]\n");
  fprintf(out,"}\n");

  /* mark used faces */
  if ( sm->connex == 0 ) {
    ne = 0;
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( pt1->v[0] )  ++ne;
    }
  }

  /* write mesh triangles */
  fprintf(out,"IndexedFaceSet {\n");
  fprintf(out,"coordIndex [\n");
  for (k=1; k<=sm->ne; k++) {
    pt1 = &sm->tria[k];
    if ( !pt1->v[0] )  continue;
    else if ( sm->connex > 0 && pt1->cc != sm->connex )
      continue;

    fprintf(out,"  %d, %d, %d, -1,\n",(&sm->point[pt1->v[0]])->tmp-1,
	    (&sm->point[pt1->v[1]])->tmp-1,(&sm->point[pt1->v[2]])->tmp-1);
  }
  fprintf(out,"]}}\n");
  fclose(out);


  if ( imprim ) {
    fprintf(stdout,"     NUMBER OF GIVEN VERTICES    %8d\n",sm->npfixe);
    fprintf(stdout,"     NUMBER OF GIVEN TRIANGLES   %8d\n",sm->nefixe);
    fprintf(stdout,"     TOTAL NUMBER OF VERTICES    %8d\n",np);
    if ( ne < sm->nefixe )
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d   (%6.2f %%)\n",
	      ne,100*(float)ne/(float)sm->nefixe);
    else
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d\n",ne);
    if ( info.cc > 1 ) 
      fprintf(stdout,"     NUMBER OF SUB-DOMAINS       %8d\n",info.cc);
    if ( sm->connex > 0 )
      fprintf(stdout,"     SUB-DOMAIN SAVED            %8d\n",sm->connex);
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
