#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* output quad mesh quality */
void outqua_q(pSurfMesh sm) {
  pQuad      pq;
  double     qavg;
  float      qmin,qmax;
  int        k,tabh[11],qnum,iel;
  int        iv0,iv1,iv2,iv3;

  for (k=0; k<=10; k++)  tabh[k] = 0;
  qnum = 0;
  qmin = 2.0;
  qmax = qavg = 0.0;
  iel  = 0;

  for (k=1; k<=sm->nq; k++) {
    pq = &sm->quad[k];
    if ( !pq->v[0] )  continue;

    iv0 = pq->v[0];
    iv1 = pq->v[1];
    iv2 = pq->v[2];
    iv3 = pq->v[3];
    if ( !qualfa_q(&sm->point[iv0].c[0],&sm->point[iv1].c[0],
                   &sm->point[iv2].c[0],&sm->point[iv3].c[0],&pq->qual,pq->n) ) {
      yerr.inderr[0] = k;
      prierr(WAR,4009);
      continue;
    }

    qnum++;
    qavg += pq->qual;
    if ( pq->qual < qmin ) {
      qmin = pq->qual;
      iel  = k;
    }
    else if ( pq->qual > qmax )
      qmax = pq->qual;
    tabh[min(9,(int)(pq->qual*10))]++;
      
  }

  if ( abs(imprim) > 1 ) {
    if ( qnum == sm->nq )
      fprintf(stdout,"\n  -- SURFACE (QUAD) MESH QUALITY   %d\n",qnum);
    else
      fprintf(stdout,"\n  -- SURFACE (QUAD) MESH QUALITY   %d / %d\n",qnum,sm->nq);
    fprintf(stdout,"     AVERAGE QUALITY        %12.4f\n",qavg / qnum);
    fprintf(stdout,"     BEST  ELEMENT QUALITY  %12.4f\n",qmax);
    fprintf(stdout,"     WORST ELEMENT QUALITY  %12.4f\n",qmin);
    pq = &sm->quad[iel];
    fprintf(stdout,"     WORST ELEMENT  %d     %d %d %d %d\n",
            iel,pq->v[0],pq->v[1],pq->v[2],pq->v[3]);
    if ( abs(imprim) < 5 )  return;

    /* print histo */
    fprintf(stdout,"\n     HISTOGRAMM\n");
    for (k=(int)(qmin*10); k<=9; k++) {
      fprintf(stdout,"     %6.2f < Q < %6.2f   %7d   %6.2f %%\n",
        k/10.0,(k+1)/10.0,tabh[k],(float)100*tabh[k]/qnum);
    }
  }
}


#ifdef __cplusplus
}
#endif
