#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern ubyte ddebug;


int outms2(pSurfMesh sm,char *fileout) {
  FILE      *outp,*outf;
  char       data[128];
  pPoint     ppt;
  pTriangle  pt1;
  int        k,np,ne;

  /* mark connected component */
  E_put("outms2");
  ne = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    ppt->tag |= M_UNUSED;
    ppt->flag = 0;
  }
  if ( sm->connex > 0 ) {
    for (k=1; k<=sm->ne; k++) {
      pt1 = &sm->tria[k];
      if ( pt1->v[0] > 0 && pt1->cc == sm->connex ) {
	ne++;
	ppt = & sm->point[pt1->v[0]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[1]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[2]];
	ppt->tag &= ~M_UNUSED;
      }
    }
  }
  else {
    /* mark used faces */
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( !pt1->v[0] )  continue;
      ++ne;
      ppt = & sm->point[pt1->v[0]];
      ppt->tag &= ~M_UNUSED;
      ppt = & sm->point[pt1->v[1]];
      ppt->tag &= ~M_UNUSED;
      ppt = & sm->point[pt1->v[2]];
      ppt->tag &= ~M_UNUSED;
    }
  }

  /* mark used vertices */
  np = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    if ( ppt->tag & M_UNUSED )  continue;
    ppt->tmp = ++np;
  }

  /* open 'xxx.points' file */
  sprintf(data,"%s.points",fileout);
  outp = fopen(data,"w");
  if ( !outp ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* write mesh vertices */
  fprintf(outp,"%d\n",np);

  if ( sm->dim == 3 ) {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      if ( ppt->tag & M_UNUSED )
	continue;
      fprintf(outp,"%.6g %.6g %.6g %d\n",ppt->c[0],ppt->c[1],ppt->c[2],ppt->ref);
    }
  }
  else {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      if ( ppt->tag & M_UNUSED )
	continue;
      fprintf(outp,"%.6g %.6g %.6g %d\n",ppt->c[0],ppt->c[1],0.,ppt->ref);
    }
  }
  fclose(outp);

  /* open 'xxx.faces' file */ 
  sprintf(data,"%s.faces",fileout);
  outf = fopen(data,"w");
  if ( !outf ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* mark used faces */
  if ( sm->connex == 0 ) {
    ne = 0;
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( pt1->v[0] == 0 )
	continue;
      ++ne;
    }
  }

  /* write mesh triangles */
  fprintf(outf,"%d\n",ne);
  for (k=1; k<=sm->ne; k++) {
    pt1 = &sm->tria[k];
    if ( pt1->v[0] == 0 )
      continue;
    else if ( sm->connex > 0 && pt1->cc != sm->connex )
      continue;

    fprintf(outf,"3 %d %d %d ",(&sm->point[pt1->v[0]])->tmp,
	    (&sm->point[pt1->v[1]])->tmp,(&sm->point[pt1->v[2]])->tmp);
    fprintf(outf," %d %d %d %d\n",pt1->ref,pt1->edg[2],pt1->edg[0],pt1->edg[1]);
  }
  fclose(outf);


  if ( imprim ) {
    fprintf(stdout,"     NUMBER OF GIVEN VERTICES    %8d\n",sm->npfixe);
    fprintf(stdout,"     NUMBER OF GIVEN TRIANGLES   %8d\n",sm->nefixe);
    fprintf(stdout,"     TOTAL NUMBER OF VERTICES    %8d\n",np);
    if ( ne < sm->nefixe )
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d   (%6.2f %%)\n",
	      ne,100*(float)ne/(float)sm->nefixe);
    else
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d\n",ne);
    if ( info.cc > 1 ) 
      fprintf(stdout,"     NUMBER OF SUB-DOMAINS       %8d\n",info.cc);
    if ( sm->connex > 0 )
      fprintf(stdout,"     SUB-DOMAIN SAVED            %8d\n",sm->connex);
  }

  E_pop();
  return(1);
}


int outEcp(pSurfMesh sm,char *fileout) {
  FILE      *outp,*outf,*outv;
  pPoint     ppt;
  pTriangle  pt1,pt2;
  Ball       bb;
  int       *tabi,i,i1,j,k,kk,nk,l,iadr,np,ne;
  char      *ptr,data[128];

  /* mark connected component */
  E_put("outEcp");
  ne = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    ppt->tag |= M_UNUSED;
    ppt->flag = 0;
  }
  if ( sm->connex > 0 ) {
    for (k=1; k<=sm->ne; k++) {
      pt1 = &sm->tria[k];
      if ( pt1->v[0] > 0 && pt1->cc == sm->connex ) {
	ne++;
	ppt = & sm->point[pt1->v[0]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[1]];
	ppt->tag &= ~M_UNUSED;
	ppt = & sm->point[pt1->v[2]];
	ppt->tag &= ~M_UNUSED;
      }
    }
  }
  else {
    /* mark used faces */
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( !pt1->v[0] )  continue;
      ++ne;
      ppt = & sm->point[pt1->v[0]];
      ppt->tag &= ~M_UNUSED;
      ppt = & sm->point[pt1->v[1]];
      ppt->tag &= ~M_UNUSED;
      ppt = & sm->point[pt1->v[2]];
      ppt->tag &= ~M_UNUSED;
    }
  }

  /* mark used vertices */
  np = 0;
  for (k=1; k<=sm->np; k++) {
    ppt = & sm->point[k];
    if ( ppt->tag & M_UNUSED )  continue;
    ppt->tmp = ++np;
  }

  /* open 'xxx.coor' file */
  strcpy(data,fileout);
  ptr = strstr(data,".mesh");
  if ( ptr )  *ptr = '\0';
  strcat(data,".coor");  
  outp = fopen(data,"w");
  if ( !outp ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* write mesh vertices */
  if ( sm->dim == 3 ) {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      if ( ppt->tag & M_UNUSED )
	continue;
      fprintf(outp,"%.6g %.6g %.6g\n",ppt->c[0],ppt->c[1],ppt->c[2]);
    }
  }
  else {
    for (k=1; k<=sm->np; k++) {
      ppt = & sm->point[k];
      if ( ppt->tag & M_UNUSED )
	continue;
      fprintf(outp,"%.6g %.6g\n",ppt->c[0],ppt->c[1]);
    }
  }
  fclose(outp);

  /* open 'xxx.tria' file */ 
  strcpy(data,fileout);
  ptr = strstr(data,".mesh");
  if ( ptr )  *ptr = '\0';
  strcat(data,".tria");  
  outf = fopen(data,"w");
  if ( !outf ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* mark used faces */
  if ( sm->connex == 0 ) {
    ne = 0;
    for (k=1; k<=sm->ne; k++) {
      pt1 = & sm->tria[k];
      if ( pt1->v[0] )  ++ne;
    }
  }

  /* write mesh triangles */
  for (k=1; k<=sm->ne; k++) {
    pt1 = &sm->tria[k];
    if ( pt1->v[0] == 0 )
      continue;
    else if ( sm->connex > 0 && pt1->cc != sm->connex )
      continue;

    fprintf(outf,"%d %d %d\n",
            (&sm->point[pt1->v[0]])->tmp,
	    (&sm->point[pt1->v[1]])->tmp,
            (&sm->point[pt1->v[2]])->tmp);
  }
  fclose(outf);
  E_pop();
  return(1);

  /* write voisins */
  strcpy(data,fileout);
  ptr = strstr(data,".mesh");
  if ( ptr )  *ptr = '\0';
  strcat(data,".vois");  
  outv = fopen(data,"w");
  if ( !outv ) {
    yerr.coderr = 8000;
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  tabi = (int*)calloc(10*(sm->np+1),sizeof(int));
  assert(tabi);
  for (k=1; k<=sm->ne; k++) {
    pt1 = &sm->tria[k];
    if ( !pt1->v[0] )  continue;

    for (i=0; i<3; i++) {
      ppt = &sm->point[ pt1->v[i] ];
      i1  = idir[i+2];
      if ( ppt->tag > M_NOTAG && pt1->tag[i1] == M_NOTAG )  continue;

      iadr = 10 * pt1->v[i];
      if ( tabi[ iadr+0 ] )  continue;
      bb.ilist = boulep(sm,k,i,&bb);
      j = 0;
      for (l=1; l<=bb.ilist; l++) {
        kk  = bb.list[l];
        nk  = bb.nump[l];
        i1  = idir[nk+1];
        pt2 = &sm->tria[kk];
        tabi[ iadr+j ] = (&sm->point[pt2->v[i1]])->tmp;
        ++j;
        if ( j == 10 )  break;
      }

      if ( !bb.closed && j < 9 ) {
        i1  = idir[nk+2];
        if ( pt2->adj[i1] ) {
          pt2 = &sm->tria[kk];
          tabi[ iadr+j ] = (&sm->point[pt2->v[i1]])->tmp;
        }
        else {
          kk  = bb.list[1];
          nk  = bb.nump[1];
          i1  = idir[nk+1];
          pt2 = &sm->tria[kk];
          tabi[ iadr+j ] = (&sm->point[pt2->v[i1]])->tmp;
        }
        ++j;
      }
    }
  }

  for (k=1; k<=sm->np; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED )  continue;
    iadr = k * 10;
    for (l=0; l<10; l++)
      fprintf(outv,"%d ",tabi[iadr+l]);
    fprintf(outv,"\n");
  }
  fclose(outv);
  free(tabi);

  if ( imprim ) {
    fprintf(stdout,"     TOTAL NUMBER OF VERTICES    %8d\n",np);
    if ( ne < sm->nefixe )
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d   (%6.2f %%)\n",
	      ne,100*(float)ne/(float)sm->nefixe);
    else
      fprintf(stdout,"     TOTAL NUMBER OF TRIANGLES   %8d\n",ne);
  }

  E_pop();
  return(1);
}
