#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


extern mytime ctim[TIMEMAX];


int optra4(pSurfMesh sm,int option) {
  double   angdev,incdev,res0;
  float    declic;
  int      k,maxtou,nm,ns,nd,nsw,nmv,absopt;
  int      alert,na,naa,ndd;

  /* optimization */
  E_put("optra4");
  nsw    = 0;
  absopt = abs(option);

  /* remove bad elts */
  opts.degrad = QUALCOE;
  declic      = 0.038;
  //if ( !delnul(sm,declic,0) )   return(0);

  /* optim angular defect */
  if ( (sm->dim == 3) && !angdef(sm) )  return(0);

  if ( opts.ctrl & ISO )
    nsw = optia3(sm,opts.ffem,declic);
  else if ( option == 0 || absopt == 1 ) {
    if ( !calmet(sm) )  return(0);
    nsw = optia1(sm,declic);
  }

  if ( nsw && imprim < -4 ) {
    yerr.inderr[0] = nsw;
    primsg(2009);
  }

  if ( !sm->type & M_SMOOTH ) {
    E_pop();
    return(1);
  }

  maxtou = 10;
  angdev = 1.0 - (1.0-opts.geom) / maxtou;
  incdev = 1.0 - angdev;
  nmv    = 0;
  res0   = 0.0;
  declic = 0.5 * BETAC;
  for (k=1; k<=maxtou; k++) {
    /*nd += colver(sm,0,opts.bande,angdev);*/
    nm  = opticu(sm);
    if ( absopt == 2 )
      nm += optpo2(sm,declic,opts.bande,angdev,&ns);
    else if ( opts.ctrl & ISO )
      nm += optpo1(sm,1,declic,angdev,&ns);
    else
      nm += optlen_a(sm,1,declic,angdev,&ns);

    if ( k == 1 )  res0 = yerr.cooerr[0];
    if ( nm && abs(imprim) > 4 ) {
      yerr.inderr[0] = nm;
      yerr.inderr[1] = ns;
      if ( res0 < EPS )
        yerr.cooerr[0] = 0.0;
      else
        yerr.cooerr[0] = yerr.cooerr[0] / res0;
      primsg(4003);
    }
    if ( k > 4 ) {
      declic = 0.5 * BETAC;
      ns = optia1(sm,declic);
    }
    if ( k > 1 && yerr.cooerr[0] < 0.001*res0 )  break;
    angdev -= incdev;
    nmv += nm;
    if ( !nm )  break;
  }

  if ( nmv && imprim && abs(imprim) < 5 ) {
    yerr.inderr[0] = nmv;
    primsg(4008);
  }

  if ( option == 0 ) {
    E_pop();
    return(1);
  }
	
  /* strong optim */
  declic = max(0.6,opts.declic);
  maxtou = 3;
  alert  = 0;
  nmv    = 0;
  naa    = 0;
  nmv    = 0;
  nsw    = 0;
  ndd    = 0;
  for (k=1; k<=maxtou; k++) {
    /* insertion */
    na = 0;
    if ( !alert && sm->type & M_ENRICH ) {
      opts.degrad = 0.01 * QUALCOE;
      if ( opts.ctrl & ISO )
        na = analar(sm,opts.gap,&alert);
      else
        na = analar_a(sm,opts.gap,&alert);
      if ( na && !cassar(sm) )  return(0);
      naa += na;
    }

    /* deletion */
    opts.degrad = QUALCOE;
    ns   = optia1(sm,declic);
    nd   = colar1(sm,sm->np);
    nsw += ns;
    ndd += nd;

    /* optim */
    nm  = 0;
    if ( declic > 0.79 && sm->type & M_SMOOTH ) {
      chrono(ON,&ctim[3]);
      nm  = opticu(sm);
      if ( opts.ctrl & ISO )
        nm = optpo1(sm,1,declic,opts.geom,&ns);
      else
        nm = optlen_a(sm,1,declic,opts.geom,&ns);
      chrono(OFF,&ctim[3]);
    }
    nmv += nm;

    if ( ns+nm+na+nd && abs(imprim) > 4 ) {
      yerr.inderr[0] = na;
      yerr.inderr[1] = nd;
      yerr.inderr[2] = ns;
      yerr.inderr[3] = nm;
      primsg(2013);
    }
    if ( !nm )  break;
  }

  if ( nsw+nmv+naa+ndd && abs(imprim) < 5 ) {
    yerr.inderr[0] = naa;
    yerr.inderr[1] = ndd;
    yerr.inderr[2] = nsw;
    yerr.inderr[3] = nmv;
    primsg(2013);
  }

  E_pop();
  return(1);
}
