/*
 *  quad quality optimization
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2003.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  QQCOEF    0.6


int optpo1_q(pSurfMesh sm,float declic) {
  pQuad      pq,pq1;
  pPoint     p1,p2,p3,p4;
  Global     gl;
  double     ga,gb,gc,dd,dd1,d1,d2,deva,dhd,du,lambda,residu,res0,restot;
  double     cb1,cb2,cb3,cx,cy,cz,ux,uy,uz,vx,vy,vz,wx,wy,wz,dmin,dx,dy,dz;
  double     b1[3],b2[3],x,y,z,x2,y2,xy,xx1,yy1,coeff,cpx,cpy,cpz,epsok,gap;
  float     *nna,*nnb,*nnc,c[3],n[3],nn[3],np[3],qtarget,qq,qcoef;
  int        is,ip1,is1,is2,k,kk,l,nb,nk;
  int        adj,it,nm,nmv,npp,maxtou;
  double     ma[6],mb[3],mx[3];
  ubyte      i,i1,i2,i3;

  /* default */
  E_put("optpo1_q");
  maxtou = 5;
  it     = 0;
  res0   = restot = 0.0f;
  epsok  = 1.0f - 2.0f*opts.eps;
  dmin   = EPS * opts.bande*opts.bande;
  nmv    = 0;
  qcoef  = 0.95;
  ++sm->mark;

  do {
    npp = nm = 0;
    residu   = 0.0f;
    qcoef   *= 1.02;

    for (k=1; k<=sm->nq; k++) {
      pq = &sm->quad[k];
      if ( !pq->v[0] || pq->flag1 > sm->mark )  continue;
      pq->flag1 = sm->mark+1;

      for (i=0; i<4; i++) {
        ip1 = pq->v[i];
        p1  = &sm->point[pq->v[i]];
        if ( p1->tag > M_NOTAG || p1->color > sm->mark )  continue;
        p1->color = sm->mark+1;

        is  = pq->vn[i];
        nna = sm->geom[is].vn;
        ga  = min(sm->geom[is].gap,opts.gap) - EPS;

        /* local frame */
	    dd = 1.0;
        if ( fabs(nna[0]) > 0.01 ) {
          b1[0] = (-nna[1]-nna[2]) / nna[0];
          b1[1] = b1[2] = 1.0;
	     dd = sqrt(2.0 + b1[0]*b1[0]);
        }
        else if ( fabs(nna[1]) > 0.01 ) {
          b1[1] = (-nna[0]-nna[2]) / nna[1];
          b1[0] = b1[2] = 1.0;
	     dd = sqrt(2.0 + b1[1]*b1[1]);
        }
        else if ( fabs(nna[2]) > 0.01 ) {
          b1[2] = (-nna[0]-nna[1]) / nna[2];
          b1[0] = b1[1] = 1.0;
	      dd = sqrt(2.0 + b1[2]*b1[2]);
        }
        dd     = 1.0 / dd;
        b1[0] *= dd;
        b1[1] *= dd;
        b1[2] *= dd;

        b2[0] = nna[1]*b1[2] - nna[2]*b1[1];
        b2[1] = nna[2]*b1[0] - nna[0]*b1[2];
        b2[2] = nna[0]*b1[1] - nna[1]*b1[0];

        /* smooth surface equation */
	npp++;
        mx[0] = mx[1] = mx[2] = 0.0f;

        if ( sm->dim == 3 && p1->geom == M_CURVE ) {
          for (l=0; l<6; l++)  ma[l] = 0.0f;
          mb[0] = mb[1] = mb[2] = 0.0f;
          nb  = 0;
          pq1 = pq;
	  nk  = i;
	  adj = k;
	  do {
	    i1 = idirq[nk+1];
	    i2 = idirq[nk+2];
	    i3 = idirq[nk+3];
	    p2 = &sm->point[pq1->v[i1]];
	    p3 = &sm->point[pq1->v[i2]];

            ux = p2->c[0] - p1->c[0];
            uy = p2->c[1] - p1->c[1];
            uz = p2->c[2] - p1->c[2];
            x  = ux*b1[0]  + uy*b1[1]  + uz*b1[2];
            y  = ux*b2[0]  + uy*b2[1]  + uz*b2[2];
            z  = ux*nna[0] + uy*nna[1] + uz*nna[2];
            x2 = x*x;
            xy = 2.0*x*y;
            y2 = y*y;
            ma[0] += x2*x2;
            ma[1] += x2*xy;
            ma[2] += x2*y2;
            ma[3] += 4*x2*y2;
            ma[4] += xy*y2;
            ma[5] += y2*y2;
            mb[0] += x2*z;
            mb[1] += xy*z;
            mb[2] += y2*z;

            ux = p3->c[0] - p1->c[0];
            uy = p3->c[1] - p1->c[1];
            uz = p3->c[2] - p1->c[2];
            x  = ux*b1[0]  + uy*b1[1]  + uz*b1[2];
            y  = ux*b2[0]  + uy*b2[1]  + uz*b2[2];
            z  = ux*nna[0] + uy*nna[1] + uz*nna[2];
            x2 = x*x;
            xy = 2.0*x*y;
            y2 = y*y;
            ma[0] += x2*x2;
            ma[1] += x2*xy;
            ma[2] += x2*y2;
            ma[3] += 4*x2*y2;
            ma[4] += xy*y2;
            ma[5] += y2*y2;
            mb[0] += x2*z;
            mb[1] += xy*z;
            mb[2] += y2*z;

            nb += 2;
	    nk  = pq1->voy[i3];
	    adj = pq1->adj[i3];
	    pq1 = &sm->quad[adj];
          }
	  while ( adj != k );
          if ( nb < 3 || !sol3x3(ma,mb,mx) )
            p1->geom = M_PLANAR;
        }

        /* optimal point */
	pq1 = pq;
	nb  = 0;
	nk  = i;
	adj = k;
	qtarget = pq->qual;
        cx = cy = cz = 0.0;
        do {
	  i1 = idirq[nk+1];
	  i3 = idirq[nk+3];
	  p2 = &sm->point[pq1->v[i1]];
	  p4 = &sm->point[pq1->v[i3]];
          if ( pq1->qual < qtarget )  qtarget = pq1->qual;

	  ux = p4->c[0] - p2->c[0];
          uy = p4->c[1] - p2->c[1];
          uz = p4->c[2] - p2->c[2];
          du = ux*ux + uy*uy + uz*uz;
          if ( du == 0.0 ) break;

          vx = p1->c[0] - p2->c[0];
          vy = p1->c[1] - p2->c[1];
          vz = p1->c[2] - p2->c[2];
          lambda = -(ux*vx + uy*vy + uz*vz) / du;

          wx = lambda*ux + vx;
          wy = lambda*uy + vy;
          wz = lambda*uz + vz;
          dd = wx*wx + wy*wy + wz*wz;  
          if ( dd > 0.0 ) {
            du = SQRT3DIV2 * sqrt(du / dd); 
            cx += 0.5 * (p2->c[0]+p4->c[0]) + du*wx;
            cy += 0.5 * (p2->c[1]+p4->c[1]) + du*wy;
            cz += 0.5 * (p2->c[2]+p4->c[2]) + du*wz;
            nb++;
	  }

	  nk  = pq1->voy[i3];
	  adj = pq1->adj[i3];
	  pq1 = &sm->quad[adj];
	}
        while ( adj != k );
        if ( !nb )  continue;

	dd  = 1.0 / nb;
	cpx = cx*dd - p1->c[0];
        cpy = cy*dd - p1->c[1];
        cpz = cz*dd - p1->c[2];

        /* adjust position */
        np[0] = nna[0];
        np[1] = nna[1];
        np[2] = nna[2];
        xx1   = cpx*b1[0] + cpy*b1[1] + cpz*b1[2];
        yy1   = cpx*b2[0] + cpy*b2[1] + cpz*b2[2];
        coeff = QQCOEF;
        qtarget *= qcoef;
	do {
          x  = xx1 * coeff;
          y  = yy1 * coeff;
          x2 = x*x;
          y2 = y*y;
          xy = 2.0*x*y;
          z  = x2*mx[0] + xy*mx[1] + y2*mx[2];
          ux = x*b1[0] + y*b2[0] + z*nna[0];
          uy = x*b1[1] + y*b2[1] + z*nna[1];
          uz = x*b1[2] + y*b2[2] + z*nna[2];

          cx = (float)(ux+p1->c[0]);
          cy = (float)(uy+p1->c[1]);
          cz = (float)(uz+p1->c[2]);
          
          if ( p1->geom == M_CURVE ) {
            d1 = 2.0*(mx[0]*x + mx[1]*y);
            d2 = 2.0*(mx[1]*x + mx[2]*y);

            np[0] = nna[0] - d1*b1[0] - d2*b2[0];
            np[1] = nna[1] - d1*b1[1] - d2*b2[1]; 
            np[2] = nna[2] - d1*b1[2] - d2*b2[2]; 
            dd = sqrt(np[0]*np[0] + np[1]*np[1] + np[2]*np[2]);
            if ( dd == 0.0f )  continue;
            dd = 1.0f / dd;
            np[0] *= dd;
            np[1] *= dd;
            np[2] *= dd;
          }

	  /* check position */
          pq1 = pq;
	  nk  = i;
	  adj = k;
	  nb  = 0;
	  c[0] = cx;
	  c[1] = cy;
	  c[2] = cz;
	  do {
	    i1 = idirq[nk+1];
	    i2 = idirq[nk+2];
	    i3 = idirq[nk+3];
            
	    p2 = &sm->point[pq1->v[i1]];
            p3 = &sm->point[pq1->v[i2]];
	    p4 = &sm->point[pq1->v[i3]];
            ++nb;

            if ( !qualfa_q(c,p2->c,p3->c,p4->c,&gl.q[nb],gl.n[nb]) )  break;
            else if ( gl.q[nb] < qtarget )  break;

            /* check deviation */
	    ux = p2->c[0] - c[0];
	    uy = p2->c[1] - c[1];
	    uz = p2->c[2] - c[2];
	    dd = ux*ux + uy*uy + uz*uz;
            deva = 1.0 - fabs(ux*np[0] + uy*np[1] + uz*np[2]) / sqrt(dd);
            if ( 2.0*deva < opts.eps-EPS )  break;

	    nk  = pq1->voy[i3];
	    adj = pq1->adj[i3];
	    pq1 = &sm->quad[adj];
          }
          while ( adj != k );
          if ( adj == k && nb > 1 )  break;
	  coeff -= 0.1;
	}
	while ( coeff > 0.0 );	
        if ( coeff <= 0.0 )  continue;

        /* update structure */
        ux = p1->c[0] - cx;
        uy = p1->c[1] - cy;
        uz = p1->c[2] - cz;
        dd = ux*ux + uy*uy + uz*uz;
        if ( dd > dmin )  residu += dd;

        p1->c[0]  = cx;
        p1->c[1]  = cy;
        p1->c[2]  = cz;
        p1->color = sm->mark;
        nna[0] = np[0];
        nna[1] = np[1];
        nna[2] = np[2];

        pq1 = pq;
	nk  = i;
	adj = k;
	nb  = 0;
        do {
	  i1 = idirq[nk+1];
	  i2 = idirq[nk+2];
	  i3 = idirq[nk+3];

	  p2 = &sm->point[pq1->v[i1]];
          p3 = &sm->point[pq1->v[i2]];
	  p4 = &sm->point[pq1->v[i3]];

          pq1->flag1 = sm->mark;
          p2->color  = sm->mark;
          p3->color  = sm->mark;
	  p4->color  = sm->mark;

          ++nb;
	  pq1->qual = gl.q[nb];
	  pq1->n[0] = gl.n[nb][0];
	  pq1->n[1] = gl.n[nb][1];
	  pq1->n[2] = gl.n[nb][2];

	  gap = np[0]*pq1->n[0] + np[1]*pq1->n[1] + np[2]*pq1->n[2];
          if ( gap < sm->geom[ip1].gap )  sm->geom[ip1].gap = gap;

	  nk  = pq1->voy[i3];
	  adj = pq1->adj[i3];
	  pq1 = &sm->quad[adj];
	}
	while ( adj != k );
	nm++;
      }
    }

    nmv  += nm;
    if ( nm && abs(imprim) > 2 ) {
      yerr.inderr[0] = nm;
      yerr.cooerr[0] = residu;
      primsg(4008);
    }

    restot += residu;
    if ( it == 1 )
      res0 = residu;
    else if ( residu < 0.01*res0 )
      break;
    else if ( nm < 0.01*npp )
      break;
  }
  while ( nm && ++it <= maxtou );

  yerr.cooerr[0] = restot;
  E_pop(); 
  return(nmv);
}


#ifdef __cplusplus
}
#endif
