/*
 *  geometric vertex smoothing (size improvement)
 *  Note: clone of optpo1.c
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2003.  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  LQCOEF   0.5


int optlen_a(pSurfMesh sm,int npdep,float declic,double angdev,int *nss) {
  pTriangle  pt,pt1,pta;
  pPoint     p1,p2,p3;
  pMetric    pm1,pm2,pm3;
  Global     gl;
  Ball       bb;
  double     ga,gb,gc,dd,dd1,dd2,dd3,d1,d2,deva,dhd,residu,res0,restot;
  double     cb[3],cx,cy,cz,ux,uy,uz,vx,vy,vz,wx,wy,wz;
  double     b1[3],b2[3],x,y,z,xx1,yy1,x2,y2,xy,coeff,size,dmin,epsok;
  double     cpx,cpy,cpz,gap,aire,peri,m[6];
  float     *nna,*nnb,*nnc,ncc[3],np[3],c[3],cc[3],qtarget,qcoef;
  int        i,j,is,ip1,is1,is2,k,kk,l,ll,nb,nk,ok;
  int        it,nm,nmv,ns,npp,maxtou;
  ubyte      i1,i2;
  double     ma[6],mb[3],mx[3];

  /* default */
  E_put("optlen");
  /*if ( imprim < -4 )  primsg(4023);*/
  maxtou = 5;
  it     = 1;
  qcoef  = 0.98;
  res0   = restot = 0.0;
  epsok  = 1.0 - 2.0*opts.eps;
  *nss = nmv = 0;
  dmin   = EPS * opts.bande;
  ++sm->mark;

  do {
    npp = nm = ns = 0;
    residu   = 0.0;
    sm->ipil = 0;
    qcoef   *= 1.02;

    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      else if ( pt->qual > declic )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++) {
        ip1 = pt->v[i];
        p1  = &sm->point[pt->v[i]];
        if ( p1->tag > M_NOTAG || p1->color > sm->mark )  continue;
        else if ( pt->v[i] < npdep )  continue;
        p1->color = sm->mark+1;

        is  = pt->vn[i];
        nna = sm->geom[is].vn;
        ga  = min(sm->geom[is].gap,angdev) - EPS;
        pm1 = &sm->metric[pt->v[i]];

        /* local frame */
        if ( fabs(nna[0]) > 0.01 ) {
          b1[0] = -(nna[1]+nna[2]) / nna[0];
          b1[1] = b1[2] = 1.0;
	     dd = sqrt(2.0 + b1[0]*b1[0]);
        }
        else if ( fabs(nna[1]) > 0.01 ) {
          b1[1] = -(nna[0]+nna[2]) / nna[1];
          b1[0] = b1[2] = 1.0;
	     dd = sqrt(2.0 + b1[1]*b1[1]);
        }
        else if ( fabs(nna[2]) > 0.01 ) {
          b1[2] = -(nna[0]+nna[1]) / nna[2];
          b1[0] = b1[1] = 1.0;
	     dd = sqrt(2.0 + b1[2]*b1[2]);
        }
        else {
          i1 = idir[i+1];
          p2 = &sm->point[pt->v[i1]];
          b1[0] = p2->c[0] - p1->c[0];
          b1[1] = p2->c[1] - p1->c[1];
          b1[2] = p2->c[2] - p1->c[2];
          dd = b1[0]*nna[0] + b1[1]*nna[1] + b1[2]*nna[2];
          b1[0] = b1[0] - dd*nna[0];
          b1[1] = b1[1] - dd*nna[1];
          b1[2] = b1[2] - dd*nna[2];
          dd    = b1[0]*b1[0] + b1[1]*b1[1] + b1[2]*b1[2];
          if ( dd < EPSD ) continue;
	      dd = sqrt(dd);
        }
	    dd     = 1.0 / dd;
        b1[0] *= dd;
        b1[1] *= dd;
        b1[2] *= dd;

        b2[0] = nna[1]*b1[2] - nna[2]*b1[1];
        b2[1] = nna[2]*b1[0] - nna[0]*b1[2];
        b2[2] = nna[0]*b1[1] - nna[1]*b1[0];

        bb.ilist = boulep(sm,k,i,&bb);
        if ( bb.ilist < 3 || !bb.closed )  continue;
        npp++;
        mx[0] = mx[1] = mx[2] = 0.0f;

        if ( sm->dim == 3 && p1->geom == M_CURVE ) {
          for (l=0; l<6; l++)  ma[l] = 0.0f;
          mb[0] = mb[1] = mb[2] = 0.0;
          nb = 0;
          for (l=1; l<=bb.ilist; l++) {
            kk = bb.list[l];
            nk = bb.nump[l]; 
            i1 = idir[nk+1];
            pt1 = &sm->tria[kk];
            p2  = &sm->point[pt1->v[i1]];
            ux = p2->c[0] - p1->c[0];
            uy = p2->c[1] - p1->c[1];
            uz = p2->c[2] - p1->c[2];
            
	        x  = ux*b1[0]  + uy*b1[1]  + uz*b1[2];
            y  = ux*b2[0]  + uy*b2[1]  + uz*b2[2];
            z  = ux*nna[0] + uy*nna[1] + uz*nna[2];
            x2 = x*x;
            xy = 2.0*x*y;
            y2 = y*y;
            
	        ma[0] += x2*x2;
            ma[1] += x2*xy;
            ma[2] += x2*y2;
            ma[3] += 4*x2*y2;
            ma[4] += xy*y2;
            ma[5] += y2*y2;
            mb[0] += x2*z;
            mb[1] += xy*z;
            mb[2] += y2*z;
            nb++;

            /* use mid-point */
	    if ( coorpo(sm,kk,nk,cc,0.5,ncc) ) {
              ux = cc[0] - p1->c[0];
              uy = cc[1] - p1->c[1];
              uz = cc[2] - p1->c[2];
              x  = ux*b1[0] + uy*b1[1] + uz*b1[2];
              y  = ux*b2[0] + uy*b2[1] + uz*b2[2];
              z  = ux*nna[0] + uy*nna[1] + uz*nna[2];
              x2 = x*x;
              xy = 2*x*y;
              y2 = y*y;
              ma[0] += x2*x2;
              ma[1] += x2*xy;
              ma[2] += x2*y2;
              ma[3] += 4*x2*y2;
              ma[4] += xy*y2;
              ma[5] += y2*y2;
              mb[0] += x2*z;
              mb[1] += xy*z;
              mb[2] += y2*z;
              nb++;
            }

            /* add point voyeur */
            if ( pt1->adj[nk] && pt1->tag[nk] == M_NOTAG ) {
              pta = &sm->tria[pt1->adj[nk]];
              dd  = pt1->n[0]*pta->n[0] + pt1->n[1]*pta->n[1]
                  + pt1->n[2]*pta->n[2];
              if ( fabs(dd) > COS1DEG ) {
                i2 = pt1->voy[nk];
                p2 = &sm->point[pta->v[i2]];
                ux = p2->c[0] - p1->c[0];
                uy = p2->c[1] - p1->c[1];
                uz = p2->c[2] - p1->c[2];
                x  = ux*b1[0]  + uy*b1[1]  + uz*b1[2];
                y  = ux*b2[0]  + uy*b2[1]  + uz*b2[2];
                z  = ux*nna[0] + uy*nna[1] + uz*nna[2];
                x2 = x*x;
                y2 = y*y;
                xy = 2.0*x*y;
                ma[0] += x2*x2;
                ma[1] += x2*xy;
                ma[2] += x2*y2;
                ma[3] += 4*x2*y2;
                ma[4] += xy*y2;
                ma[5] += y2*y2;
                mb[0] += x2*z;
                mb[1] += xy*z;
                mb[2] += y2*z;
                nb++;
              }
            }
          }
          /* solve linear system */
          if ( nb < 3 || !sol3x3(ma,mb,mx) )
            p1->geom = M_PLANAR;
        }

        /* optimal point */
        qtarget = pt->qual;
        cx = cy = cz = 0.0;
        nb = 0;
        for (l=1; l<=bb.ilist; l++) {
          kk = bb.list[l];
          nk = bb.nump[l]; 
          pt1 = &sm->tria[kk];
          if ( pt1->qual < qtarget )  qtarget = pt1->qual;
          i1  = idir[nk+1];
          p2  = &sm->point[pt1->v[i1]];
          pm2 = &sm->metric[pt1->v[i1]];

          /* edge length */
          ux = p2->c[0] - p1->c[0];
          uy = p2->c[1] - p1->c[1];
          uz = p2->c[2] - p1->c[2];

          dd1 =      pm1->m[0]*ux*ux + pm1->m[3]*uy*uy + pm1->m[5]*uz*uz \
              + 2.0*(pm1->m[1]*ux*uy + pm1->m[2]*ux*uz + pm1->m[4]*uy*uz);
          if ( dd1 <= 0.0 )  continue;
/* 
          dd2 =      pm2->m[0]*ux*ux + pm2->m[3]*uy*uy + pm2->m[5]*uz*uz \
              + 2.0*(pm2->m[1]*ux*uy + pm2->m[2]*ux*uz + pm2->m[4]*uy*uz);
          if ( dd2 <= 0.0 )  continue;
          size = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
*/
          if ( dd1 < EPSD )  continue;
          size = sqrt(dd1);

          /* optimal point */
          size = 1.0 / size;
          cx += p1->c[0] + ux*size;
          cy += p1->c[1] + uy*size;
          cz += p1->c[2] + uz*size;
          nb++;
        }
        
	if ( nb < bb.ilist )  continue;
        dd = 1.0 / (double)nb;
        cpx = cx*dd - p1->c[0];
        cpy = cy*dd - p1->c[1];
        cpz = cz*dd - p1->c[2];

        /* adjust position */
        np[0] = nna[0];
        np[1] = nna[1];
        np[2] = nna[2];
        xx1   = cpx*b1[0] + cpy*b1[1] + cpz*b1[2];
        yy1   = cpx*b2[0] + cpy*b2[1] + cpz*b2[2];
        coeff    = LQCOEF;
        qtarget *= qcoef;
        do {
          x = coeff*xx1;
          y = coeff*yy1;
          x2 = x*x;
          y2 = y*y;
          xy = 2.0*x*y;
          z  = x2*mx[0] + xy*mx[1] + y2*mx[2];
          ux = x*b1[0] + y*b2[0] + z*nna[0];
          uy = x*b1[1] + y*b2[1] + z*nna[1];
          uz = x*b1[2] + y*b2[2] + z*nna[2];

          cx = (float)(ux+p1->c[0]);
          cy = (float)(uy+p1->c[1]);
          cz = (float)(uz+p1->c[2]);
  
          if ( sm->dim == 3 && p1->geom == M_CURVE ) {
            d1 = 2.0*(mx[0]*x + mx[1]*y);
            d2 = 2.0*(mx[1]*x + mx[2]*y);

            np[0] = nna[0] - d1*b1[0] - d2*b2[0];
            np[1] = nna[1] - d1*b1[1] - d2*b2[1]; 
            np[2] = nna[2] - d1*b1[2] - d2*b2[2];
            dd    = np[0]*np[0] + np[1]*np[1] + np[2]*np[2];
            if ( dd < EPSD )  continue;
            dd = 1.0 / sqrt(dd);
            np[0] *= dd;  np[1] *= dd;  np[2] *= dd;
          }

          /* analyze ball of vertex */
          c[0] = cx;
	      c[1] = cy;
	      c[2] = cz;
          for (l=1; l<=bb.ilist; l++) {
            kk  = bb.list[l];
            nk  = bb.nump[l];
            i1  = idir[nk+1];
            i2  = idir[nk+2];
            pt1 = &sm->tria[kk];
            is1 = pt1->vn[i1];
            is2 = pt1->vn[i2];
            
            p2  = &sm->point[pt1->v[i1]];
            p3  = &sm->point[pt1->v[i2]];

            ux = p2->c[0] - c[0];
            uy = p2->c[1] - c[1];
            uz = p2->c[2] - c[2];

            vx = p3->c[0] - c[0];
            vy = p3->c[1] - c[1];
            vz = p3->c[2] - c[2];

            /* normal */
            gl.n[l][0] = uy*vz - uz*vy;
            gl.n[l][1] = uz*vx - ux*vz;
            gl.n[l][2] = ux*vy - uy*vx;
            dd = gl.n[l][0]*gl.n[l][0] + gl.n[l][1]*gl.n[l][1] \
               + gl.n[l][2]*gl.n[l][2];
            if ( dd <= 0.0 )   break;
            dd1 = sqrt(dd);
	    dd  = 1.0 / dd1;
            gl.n[l][0] *= dd;
            gl.n[l][1] *= dd;
            gl.n[l][2] *= dd;

            /* gap deviation */
            if ( sm->dim == 3 ) {
              nnb = sm->geom[is1].vn;
              nnc = sm->geom[is2].vn;
              gb  = min(sm->geom[is1].gap,angdev) - EPS;
              gc  = min(sm->geom[is2].gap,angdev) - EPS;

	      if ( gl.n[l][0]*np[0] +gl.n[l][1]*np[1] +gl.n[l][2]*np[2]  < ga ||
                   gl.n[l][0]*nnb[0]+gl.n[l][1]*nnb[1]+gl.n[l][2]*nnb[2] < gb ||
                   gl.n[l][0]*nnc[0]+gl.n[l][1]*nnc[1]+gl.n[l][2]*nnc[2] < gc )
                break;
              dd = gl.n[l][0]*pt1->n[0]+gl.n[l][1]*pt1->n[1]+gl.n[l][2]*pt1->n[2];
              if ( dd < epsok )  break;
            }
            else {
              dd = gl.n[l][0]*pt1->n[0]+gl.n[l][1]*pt1->n[1]\
                 + gl.n[l][2]*pt1->n[2];
              if ( dd < 0.0 )  break;
            }

            wx = p3->c[0] - p2->c[0];
            wy = p3->c[1] - p2->c[1];
            wz = p3->c[2] - p2->c[2];

            /* compute deviation */
            dd = ux*ux + uy*uy + uz*uz;
            deva = 1.0 - fabs(ux*np[0] + uy*np[1] + uz*np[2]) / sqrt(dd);
            if ( 2.0*deva < opts.eps-EPS )  break;

            /* average metric */
            pm2 = &sm->metric[pt1->v[i1]];
            pm3 = &sm->metric[pt1->v[i2]];
            for (j=0; j<6; j++)
              m[j] = (pm1->m[j]+pm2->m[j]+pm3->m[j]) / 3.0;

            dd1 =      m[0]*ux*ux + m[3]*uy*uy + m[5]*uz*uz \
                + 2.0*(m[1]*ux*uy + m[2]*ux*uz + m[4]*uy*uz);
            dd1 = sqrt(dd1);

            dd2 =      m[0]*vx*vx + m[3]*vy*vy + m[5]*vz*vz \
                + 2.0*(m[1]*vx*vy + m[2]*vx*vz + m[4]*vy*vz);
            dd2 = sqrt(dd2);

            dd3 =      m[0]*wx*wx + m[3]*wy*wy + m[5]*wz*wz \
                + 2.0*(m[1]*wx*wy + m[2]*wx*wz + m[4]*wy*wz);
            dd3 = sqrt(dd3);
  
            /* quality */
            peri = 0.5 * (dd1 + dd2 + dd3);
            if ( peri < EPSD )  break;
            aire = (peri-dd1) * (peri-dd2) * (peri-dd3);
            if ( aire <= 0.0 )  break;
            gl.q[l] = sqrt(aire * peri) / peri;
            if ( gl.q[l] < qtarget )  break;

            /* check angle with neighbor */
            if ( sm->dim == 2 )  continue;
            else if ( pt1->tag[nk] & M_RIDGE_GEO )  continue;
            else if ( pt1->adj[nk] ) {
              pta = &sm->tria[pt1->adj[nk]];
              dhd = pta->n[0]*gl.n[l][0] + pta->n[1]*gl.n[l][1] \
                  + pta->n[2]*gl.n[l][2];
              if ( dhd < opts.ridge )  break;
            }
          }
          if ( l > bb.ilist ) break;
          coeff -= 0.1;
        }
        while ( coeff > 0.0 );
        if ( coeff <= 0.0 )  continue;

        /* update data structure */
        ux = p1->c[0] - cx;
        uy = p1->c[1] - cy;
        uz = p1->c[2] - cz;
        dd = ux*ux + uy*uy + uz*uz;
        if ( dd > dmin )  residu += dd;

        p1->c[0]  = cx;
        p1->c[1]  = cy;
        p1->c[2]  = cz;
        p1->color = sm->mark;
        nna[0] = np[0];
        nna[1] = np[1];
        nna[2] = np[2];
        sm->geom[ip1].gap = 1.0;

        /* check normal deviation */
        if ( imprim < 0 && p1->geom == M_CURVE ) { 
          dd = nna[0]*np[0]+nna[1]*np[1]+nna[2]*np[2];
          if ( dd < COS12DEG ) {
            yerr.cooerr[0] = dd;
            yerr.inderr[0] = pt->v[i];
            prierr(WAR,4011);
          }
        }

        ok = dd < dmin;
        for (l=1; l<=bb.ilist; l++) {
          kk = bb.list[l];
          nk = bb.nump[l];
          i1 = idir[nk+1];
          i2 = idir[nk+2];
          pt1= &sm->tria[kk];
          p2 = &sm->point[pt1->v[i1]];
          p3 = &sm->point[pt1->v[i2]];
          p2->color = sm->mark;
          p3->color = sm->mark;

          pt1->n[0] = gl.n[l][0];
          pt1->n[1] = gl.n[l][1];
          pt1->n[2] = gl.n[l][2];
          pt1->qual = gl.q[l];
          pt1->flag1 = sm->mark;

          /* update gap */
          gap = np[0]*pt1->n[0] + np[1]*pt1->n[1] + np[2]*pt1->n[2];
          if ( gap < sm->geom[ip1].gap )  sm->geom[ip1].gap = gap;

          if ( !pt1->flag2 ) {
            pt1->flag2 = 1;
            pta = &sm->tria[++sm->ipil];
            pta->nxt   = kk;
          }

          /* find enclosing triangle */
          if ( !ok ) {
            vx = p2->c[0] - cx;
            vy = p2->c[1] - cy;
            vz = p2->c[2] - cz;
            wx = p3->c[0] - cx;
            wy = p3->c[1] - cy;
            wz = p3->c[2] - cz;
            cb[0] = pt->n[0] * (vy*wz - vz*wy) + pt->n[1] * (vz*wx - vx*wz) 
                  + pt->n[2] * (vx*wy - vy*wx);
            if ( cb[0] < 0.0f )  continue;
            cb[1] = pt->n[0] * (wy*uz - wz*uy) + pt->n[1] * (wz*uy - wx*uz) 
                  + pt->n[2] * (wx*uy - wy*uy);
            if ( cb[1] < 0.0f )  continue;
            cb[2] = pt->n[0] * (uy*vz - uz*vy) + pt->n[1] * (uz*vx - uy*vz) 
                  + pt->n[2] * (uy*vy - uy*vx);
            if ( cb[2] < 0.0f )  continue;
            dd  = cb[0] + cb[1] + cb[2];
            if ( dd == 0.0f )  continue;
            dd   = 1.0 / dd;
            cb[0] *= dd;
            cb[1] *= dd;
            cb[2] *= dd;

            /* update size */
            p1->size = cb[0]*p1->size + cb[1]*p2->size + cb[2]*p3->size;
            if ( p1->size > opts.hmax )       p1->size = opts.hmax;
            else if ( p1->size < opts.hmin )  p1->size = opts.hmin;

            /* interpolate metric */
            pm1 = &sm->metric[pt1->v[i]];
            pm2 = &sm->metric[pt1->v[i1]];
            pm3 = &sm->metric[pt1->v[i2]];
            if ( !intme3_a(pm1,pm2,pm3,pm1,cb) ) {
              for (ll=0; ll<6; ll++)
                pm1->m[ll] = cb[0]*pm1->m[ll] + cb[1]*pm2->m[ll] \
                           + cb[2]*pm3->m[ll];
            }
            ok = TRUE;
          }
        }
        nm++;
      }
    }

    /* local optimisation */
    ns    = loptia1(sm,0);
    nmv  += nm;
    *nss += ns;
    if ( nm && imprim < -4 ) {
      yerr.inderr[0] = nm;
      yerr.inderr[1] = ns;
      yerr.cooerr[0] = residu;
      primsg(4003);
    }
    restot += residu;
    if ( it == 1 )
      res0 = residu;
    else if ( residu < 0.01 * res0 )
      break;
    else if ( nm < 0.01*npp )
      break;
  }
  while ( nm && ++it < maxtou );

  yerr.cooerr[0] = restot;
  E_pop();
  return(nmv);
}
