#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  SLAMBDA   0.33   /*0.33*/
#define  SMU       0.34   /*0.34*/


int optima(pSurfMesh sm,int npdep,float declic) {
  pTriangle   pt,pt1,pt2;
  pPoint      p0,p1,p2;
  Ball        bb;
  double      cx,cy,cz,dd,res,res0;
  float      *nv,*nw,*tabf,ox,oy,oz;
  int         i,k,kk,kl,l,it,iadr;
  ubyte       i1,i2,nk,nl;

  if ( imprim < -4 )  primsg(1050);
  if ( opts.iter < 10 )  opts.iter = 10;

  /* unmark vertices */
  tabf = (float*)malloc(1+sizeof(float)*3*sm->npmax);
  if ( !tabf )  return(0);

  for (k=1; k<=sm->npmax; k++) {
    p0 = &sm->point[k];
    p0->flag = sm->mark;
    iadr  = (k-1)*3 + 1;
    nv    = &tabf[iadr];
    nv[0] = p0->c[0];
    nv[1] = p0->c[1];
    nv[2] = p0->c[2];
  }

  ++sm->mark;
  res0 = 0.0;
  for (it=1; it<=opts.iter; it++) {

    /* 1st stage: compute coord */
    for (k=1; k<=sm->nemax; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
        i2   = idir[i+2];

        if ( pt->qual > declic )  continue;
        else if ( pt->tag[i2] & M_REQUIRED )  continue;

	p0 = &sm->point[pt->v[i]];
        if ( p0->flag > sm->mark )  continue;
	else if ( p0->tag & M_REQUIRED )  continue;
        else if (p0->tag & M_CORNER )  continue;

        iadr  = (pt->v[i]-1)*3 + 1;
        nv    = &tabf[iadr];
        nv[0] = p0->c[0];
        nv[1] = p0->c[1];
        nv[2] = p0->c[2];

        bb.ilist = boulep(sm,k,i,&bb);
        if ( bb.ilist < 1 ) {
          p0->flag = sm->mark+1;
          continue;
        }
        else if ( bb.closed ) {
          p0->flag = sm->mark+1;
          cx = cy = cz = 0.0f;
          for (l=1; l<=bb.ilist; l++) {
	    kk = bb.list[l];
	    nk = bb.nump[l];
	    i1 = idir[nk+1];
	    pt1 = &sm->tria[kk];
	    p1  = &sm->point[pt1->v[i1]];
            cx += p1->c[0];
            cy += p1->c[1];
            cz += p1->c[2];
	  }
	  dd  = 1.0 / bb.ilist;
          cx *= dd;
          cy *= dd;
          cz *= dd;
        }
        else if ( pt->tag[i2] > M_NOTAG ) {
          p0->flag = sm->mark+1;
          kk = bb.list[1];
          nk = bb.nump[1];
          kl = bb.list[bb.ilist];
          nl = bb.nump[bb.ilist];

          i1 = idir[nk+1];
          i2 = idir[nl+2];
          pt1 = &sm->tria[kk];
          pt2 = &sm->tria[kl];

          p1  = &sm->point[pt1->v[i1]];
          p2  = &sm->point[pt2->v[i2]];
          cx = 0.5 * (p1->c[0]+p2->c[0]);
          cy = 0.5 * (p1->c[1]+p2->c[1]);
          cz = 0.5 * (p1->c[2]+p2->c[2]);
        }
        else
          continue;

	/* Laplacian */
	nv[0] = p0->c[0] + SLAMBDA * (p0->c[0] - cx);
        nv[1] = p0->c[1] + SLAMBDA * (p0->c[1] - cy);
        nv[2] = p0->c[2] + SLAMBDA * (p0->c[2] - cz);
      }
    }

    /* 2nd stage: update coord */
    res = 0.0;
    for (k=1; k<=sm->nemax; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
        i2 = idir[i+2];
        if ( pt->qual > declic )  continue;
        else if ( pt->tag[i2] & M_REQUIRED )  continue;

	p0 = &sm->point[pt->v[i]];
        if ( p0->flag < sm->mark+1 )  continue;
        else if ( p0->tag & M_REQUIRED )  continue;
	else if ( p0->tag & M_CORNER )    continue;

        bb.ilist = boulep(sm,k,i,&bb);
        if ( bb.ilist < 1 ) {
          p0->flag = sm->mark;
	  continue;
	}
        else if ( bb.closed ) {
          p0->flag = sm->mark;
	  cx = cy  = cz = 0.0;
          for (l=1; l<=bb.ilist; l++) {
	    kk = bb.list[l];
	    nk = bb.nump[l];
	    i1 = idir[nk+1];

            pt1  = &sm->tria[kk];
            iadr = (pt1->v[i1]-1)*3 +1;
            nv   = &tabf[iadr];
            cx += nv[0];
            cy += nv[1];
            cz += nv[2];
          }
	  dd  = 1.0 / bb.ilist;
          cx *= dd;
          cy *= dd;
          cz *= dd;
        }
        else if ( pt->tag[i2] > M_NOTAG ) {
          p0->flag = sm->mark;
	  kk = bb.list[1];
          nk = bb.nump[1];
          kl = bb.list[bb.ilist];
          nl = bb.nump[bb.ilist];

          i1 = idir[nk+1];
          i2 = idir[nl+2];
          pt1  = &sm->tria[kk];
          pt2  = &sm->tria[kl];

          iadr = (pt1->v[i1]-1)*3 + 1;
          nv   = &tabf[iadr];
          iadr = (pt2->v[i2]-1)*3 + 1;
          nw   = &tabf[iadr];

          cx = 0.5 * (nv[0]+nw[0]);
          cy = 0.5 * (nv[1]+nw[1]);
          cz = 0.5 * (nv[2]+nw[2]);
        }
        else
          continue;
        
	ox = p0->c[0];
        oy = p0->c[1];
        oz = p0->c[2];
        iadr = (pt->v[i]-1)*3 + 1;
        nv   = &tabf[iadr];
	p0->c[0] = nv[0] - SMU * (nv[0] - cx);
        p0->c[1] = nv[1] - SMU * (nv[1] - cy);
        p0->c[2] = nv[2] - SMU * (nv[2] - cz);
        p0->flag = sm->mark;

	dd = (p0->c[0]-ox)*(p0->c[0]-ox) + (p0->c[1]-oy)*(p0->c[1]-oy) \
           + (p0->c[2]-oz)*(p0->c[2]-oz);
        res += dd;
      }
    }
    if ( it == 1 )     res0 = res;
    if ( res0 > EPS )  res  = res / res0;
    if ( imprim < -4 ) {
      fprintf(stdout,"    iter %8d  res %.2E\r",it,res); 
      fflush(stdout);
    }
  }
  if ( imprim < -4 )  fprintf(stdout,"\n");

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    p0 = &sm->point[pt->v[0]];
    p1 = &sm->point[pt->v[1]];
    p2 = &sm->point[pt->v[2]];
    qualfa(p0->c,p1->c,p2->c,&pt->qual,pt->n);
  }

  free(tabf);
  E_pop();
  return(1);
}
