/*
 *  geometric vertex smoothing (ridge)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  RQCOEF   0.3

int opticu(pSurfMesh sm) {
  pTriangle   pt,pt1,pt2;
  pPoint      p1,p2,p3;
  Global      gl;
  Ball        bb;
  double      par[2],g[3],u[3],v[3],ux,uy,uz,cx,cy,cz,x,y;
  double      gb,gc,residu,res0,restot,dmin,dd;
  float      *nnb,*nnc,cc[3],qtarget,coeff;
  int         k,l,jj,nmv,nm,it,maxtou,nbp;
  int         numk,adj,adj1,is1,is2,kk;
  ubyte       i,i1,i2,quadric,voy,voy1;

  /* default */
  E_put("opticu");
  nmv    = 0;
  maxtou = 5;
  it     = 0;
  res0   = restot = 0.0f;
  dmin   = 1.0e-06 * opts.bande;
  ++sm->mark;

  do {
    nbp = nm = 0;
    residu   = 0.0f;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++) {
	if ( pt->tag[i] == M_NOTAG || pt->tag[i] & M_REQUIRED )  continue;
        i1 = idir[i+1];
	i2 = idir[i+2];
	jj = pt->v[i1];
	p2 = &sm->point[pt->v[i1]];
	p3 = &sm->point[pt->v[i2]];
	if ( p2->tag & M_CORNER || p2->tag & M_REQUIRED )  continue;
	nbp++;

	/* get ball of p2 */
        qtarget    = pt->qual;
        bb.ilist   = 1;
        bb.list[1] = k;
        bb.nump[1] = i1;
        pt1 = pt;
        voy = i2;
        adj = pt1->adj[voy];
        while ( (adj != k) && pt1->tag[voy] == M_NOTAG ) {
          if ( bb.ilist >= LONMAX ) {
            bb.ilist = -1;
            break;
          }
          bb.list[++bb.ilist] = adj;
          voy = pt1->voy[voy];
          bb.nump[bb.ilist] = idir[voy+1];
          voy = idir[voy+2];
          pt1 = &sm->tria[adj];
          qtarget = min(qtarget,pt1->qual);
          adj = pt1->adj[voy];
        }
	if ( bb.ilist < 2 || adj == k )  continue;
        kk   = bb.list[bb.ilist];
	numk = bb.nump[bb.ilist];
	pt1  = &sm->tria[kk];
	i2   = idir[numk+2];
	p1   = &sm->point[pt1->v[i2]];

	/* compute parabola */
	quadric = calpar(p2,p3,p1,u,v,par);

	/* get ball(s) of vertex b */
	voy = i;
	pt1 = pt;
	while ( pt1->adj[voy] && pt1->adj[voy] != k ) {
	  adj = pt1->adj[voy];
	  voy = pt1->voy[voy];
	  pt1 = &sm->tria[adj];
	  ++bb.ilist;
	  bb.list[bb.ilist] = adj;
	  voy1 = idir[voy+1];
	  if ( pt1->v[voy1] == jj ) {
	    bb.nump[bb.ilist] = voy1;
	    voy1 = idir[voy+2];
	  }
	  else
	    bb.nump[bb.ilist] = idir[voy+2];
	  pt2 = pt1;
	  qtarget = min(qtarget,pt2->qual);
	  while ( pt2->adj[voy1] && pt2->tag[voy1] == M_NOTAG ) {
            adj1 = pt2->adj[voy1];
            voy1 = pt2->voy[voy1];
            if ( ++bb.ilist > LONMAX-1 ) {
	      bb.ilist = -1;
	      break;
	    }
	    pt2 = &sm->tria[adj1];
	    bb.list[bb.ilist] = adj1;
	    bb.nump[bb.ilist] = idir[voy1+2];
	    voy1 = idir[voy1+1];
	    qtarget = min(qtarget,pt2->qual);
          }
          if ( bb.ilist < 2 )  break;
        }
        if ( bb.ilist < 2 )  continue;

	/* find optimal location */
	qtarget *= 1.01;
	coeff    = RQCOEF;
        g[0] = 0.5*(p1->c[0] + p3->c[0]);
        g[1] = 0.5*(p1->c[1] + p3->c[1]);
        g[2] = 0.5*(p1->c[2] + p3->c[2]);

        do {
	  /* coords of g in local frame */
	  ux = coeff * (g[0] - p2->c[0]);
	  uy = coeff * (g[1] - p2->c[1]);
	  uz = coeff * (g[2] - p2->c[2]);

	  /* locate point on quadrics */
	  if ( quadric == 1 ) {
	    x  = ux*u[0] + uy*u[1] + uz*u[2];
	    y  = par[0]*x*x + par[1]*x;
	    cx = (float)(p2->c[0] + x*u[0] + y*v[0]);
	    cy = (float)(p2->c[1] + x*u[1] + y*v[1]);
	    cz = (float)(p2->c[2] + x*u[2] + y*v[2]);
	  }
	  else {
	    cx = (float)(p2->c[0] + ux);
	    cy = (float)(p2->c[1] + uy);
	    cz = (float)(p2->c[2] + uz);
	  }

	  /* analyze ball(s) of vertex */
	  cc[0] = cx;  cc[1] = cy;  cc[2] = cz;
	  for (l=1; l<=bb.ilist; l++) {
	    kk   = bb.list[l];
	    numk = bb.nump[l];
	    pt1  = &sm->tria[kk];
	    i1  = idir[numk+1];
	    i2  = idir[numk+2];
	    is1 = pt1->vn[i1];
	    is2 = pt1->vn[i2];
	    p1  = &sm->point[pt1->v[i1]];
	    p3  = &sm->point[pt1->v[i2]];

            if ( !qualfa(cc,p1->c,p3->c,&gl.q[l],gl.n[l]) )  break;
            if ( gl.q[l] < qtarget )  break;

	    nnb = sm->geom[is1].vn;
	    nnc = sm->geom[is2].vn;
	    gb =  min(sm->geom[is1].gap,opts.gap) - EPS;
	    gc =  min(sm->geom[is2].gap,opts.gap) - EPS;
            if ( gl.n[l][0]*nnb[0]+gl.n[l][1]*nnb[1]+gl.n[l][2]*nnb[2] < gb ||
                 gl.n[l][0]*nnc[0]+gl.n[l][1]*nnc[1]+gl.n[l][2]*nnc[2] < gc )
              break;
            dd = gl.n[l][0]*pt1->n[0]+gl.n[l][1]*pt1->n[1]+gl.n[l][2]*pt1->n[2];
            if ( dd < opts.ridge )  break;
	  }
	  if ( l > bb.ilist )  break;
	  coeff *= 0.7;
	}
	while ( coeff > 0.05 );
        if ( coeff < 0.15 )  continue;

	/* update data structure */
	ux = p2->c[0] - cx;
	uy = p2->c[1] - cy;
	uz = p2->c[2] - cz;
	dd = ux*ux + uy*uy + uz*uz;
	if ( dd > dmin )  residu += dd;

	p2->c[0] = cx;
	p2->c[1] = cy;
	p2->c[2] = cz;
	p2->color++;

	for (l=1; l<=bb.ilist; l++) {
	  kk  = bb.list[l];
	  pt1 = &sm->tria[kk];
	  pt1->qual = gl.q[l];
	  pt1->n[0] = gl.n[l][0];
	  pt1->n[1] = gl.n[l][1];
	  pt1->n[2] = gl.n[l][2];
	  pt1->flag1 = sm->mark;
	}
	nm++;
	break;
      }
    }
    nmv += nm;
    restot += residu;

    if ( it == 1 )
      res0 = residu;
    else if ( residu < 0.01*res0 || nm < 0.01*nbp )
      break;
  }
  while ( nm && ++it < maxtou );

  if ( nmv > 0 && imprim < -4 ) {
    yerr.inderr[0] = nmv;
    yerr.cooerr[0] = restot;
    primsg(4008);
  }

  E_pop();
  return(nmv);
}


#ifdef __cplusplus
}
#endif

