/*
 *  mesh optimization (edge swap)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* local optimization */
int loptia2(pSurfMesh sm,double lbande,double angdev) {
  pTriangle   pt,pt1;
  float       nn1[3],nn2[3],qq1,qq2,hd1,hd2;
  int         i,k,kk,voy,adj,ns,nsw,it,maxtou;

  /* default */
  if ( !sm->ipil )  return(1);
  nsw = it = 0;
  maxtou = 15;
  do {
    ns = 0;
    k  = sm->ipil+1;
    while ( --k > 0 ) {
      pt = &sm->tria[k];
      kk = pt->nxt;
      if ( !kk )  continue;
      pt = &sm->tria[kk];
      pt->flag2 = 0;
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++)
	if ( pt->tag[i] == M_NOTAG &&
	     flipa2(sm,kk,i,nn1,nn2,&qq1,&qq2,&hd1,&hd2,lbande,angdev) ) {
          pt1 = &sm->tria[pt->adj[i]];
          voy = pt->voy[i];
	  ns += swapar(sm,kk,i,nn1,nn2,qq1,qq2,hd1,hd2);
	  adj = pt->adj[i];
	  if ( adj && !sm->tria[adj].flag2 ) { 
	    if ( ++sm->ipil == sm->nemax ) break;
	    sm->tria[sm->ipil].nxt = adj;
	    sm->tria[adj].flag2    = 1;
	  }
          adj = pt1->adj[voy];
	  if ( adj && !sm->tria[adj].flag2 ) { 
	    if ( ++sm->ipil == sm->nemax ) break;
	    sm->tria[sm->ipil].nxt = adj;
	    sm->tria[adj].flag2    = 1;
	  }
	  break;
	}
    }
    nsw += ns;
  }
  while ( ns && ++it<maxtou );

  return(nsw);
}


int optia2(pSurfMesh sm,double lbande,double angdev) {
  pTriangle   pt;
  float       nn1[3],nn2[3],qq1,qq2,hd1,hd2;
  int         i,k,it,nsw,ns,maxtou;

  /* default */
  E_put("optia2");
  maxtou = 15;
  nsw = it = 0;
  ++sm->mark;
  
  do {
    ns = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++)
	if ( pt->tag[i] == M_NOTAG &&
	     flipa2(sm,k,i,nn1,nn2,&qq1,&qq2,&hd1,&hd2,lbande,angdev) ) {
	  ns += swapar(sm,k,i,nn1,nn2,qq1,qq2,hd1,hd2);
	  break;
	}
    }
    nsw += ns;
  }
  while ( ns && ++it<maxtou );

  E_pop();
  return(nsw);
}


#ifdef __cplusplus
}
#endif
