/*
 *  mesh optimization (edge swap)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* local optimization */
int loptia1(pSurfMesh sm,ubyte fechk) {
  pTriangle   pt,pt1;
  float       nn1[3],nn2[3],qq1,qq2;
  int         i,k,kk,adj,ns,nsw,it,maxtou;
  ubyte       voy;

  /* default */
  nsw = 0;
  it  = 0;
  maxtou = 15;
  do {
    ns = 0;
    k  = sm->ipil+1;
    while ( --k > 0 ) {
      pt = &sm->tria[k];
      kk = pt->nxt;
      if ( !kk )  continue;
      pt = &sm->tria[kk];
      pt->flag2 = 0;
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
	if ( pt->tag[i] > M_NOTAG )  continue;
        adj = pt->adj[i];
        voy = pt->voy[i];
        pt1 = &sm->tria[adj];
        if ( fechk && pt->v[i] > M_NOTAG && pt1->v[voy] > M_NOTAG )
          continue;

	if ( flipa1(sm,kk,i,nn1,nn2,&qq1,&qq2) ) {
	  adj = pt->adj[i];
          pt1 = &sm->tria[adj];
          if ( swapar(sm,kk,i,nn1,nn2,qq1,qq2,0.0,0.0) ) {
            ns++;
            pt1 = &sm->tria[kk];
	    if ( !pt1->flag2 ) { 
	      sm->tria[sm->ipil].nxt = kk;
	      pt1->flag2 = 1;
	    }
            pt1 = &sm->tria[adj];
	    if ( !pt1->flag2 ) { 
	      sm->tria[sm->ipil].nxt = adj;
	      pt1->flag2 = 1;
            }
	    break;
	  }
          else  return(0);
	}
      }
    }
    nsw += ns;
  }
  while ( ns>0 && ++it<maxtou );

  return(nsw);
}


int optia1(pSurfMesh sm,float declic) {
  pTriangle   pt,pt1;
  float       n1[3],n2[3],q1,q2;
  int         i,k,kk,adj,nsw,npp;
	
  /* default */
  E_put("optia1");
  nsw = 0;
  ++sm->mark;

  /* queue bad elements */
  sm->ipil = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( pt->v[0] && pt->qual <= declic ) {
      sm->tria[++sm->ipil].nxt = k;
      pt->flag2 = 1;
    }
  }
  if ( !sm->ipil ) {
    E_pop();
    return(0);
  }

  /* optimization */
  nsw = npp = 0;
  while ( sm->ipil > 0 ) {
    kk = sm->ipil--;
    pt = &sm->tria[kk];
    k  = pt->nxt;
    if ( !k )  continue;
    pt = &sm->tria[k];
    pt->flag2 = 0;
    if ( !pt->v[0] || pt->qual > declic )  continue;
    npp++;

    /* swap edges */
    for (i=0; i<3; i++) {
      if ( pt->tag[i] > M_NOTAG )  continue;
      adj = pt->adj[i];
      pt1 = &sm->tria[adj];
      if ( flipa1(sm,k,i,n1,n2,&q1,&q2) ) {      
	      if ( swapar(sm,k,i,n1,n2,q1,q2,0.,0.) ) {
          nsw++;
          if ( q1 <= declic ) {
            sm->tria[++sm->ipil].nxt = k;
            pt->flag2 = 1;
          }
          if ( q2 <= declic && !pt1->flag2 ) {
            sm->tria[++sm->ipil].nxt = adj;
            pt1->flag2 = 1;
          }
          break;
        }
        else return(0);
      }
    }
  }

  E_pop();
  return(nsw);
}

