#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int optfem(pSurfMesh sm) {
  pTriangle  pt,pt1;
  pPoint     p1,p2;
  pHashtable pht;
  Ball       bb;
  float      n1[3],n2[3],q1,q2,declic;
  int        k,kk,l,i,i1,i2,adj,na,ns,nbs,nsw;
  ubyte      iret;

  /* default */
  E_put("optfem");
  if ( imprim < -4 )  primsg(4026);
  nbs    = nsw = 0;
  declic = 0.5*ALPHAC;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    pt->flag1 = sm->mark;
  }

  ++sm->mark;
  pht = &hash[0];
  do {
    ns = na = 0;
    sm->ipil = 0;

    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;
      else if ( pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++) {
        if ( pt->tag[i] > M_NOTAG )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        p1 = &sm->point[pt->v[i1]];
        p2 = &sm->point[pt->v[i2]];
        if ( p1->tag == M_NOTAG || p2->tag == M_NOTAG)  continue;

        if ( flipa1(sm,k,i,n1,n2,&q1,&q2) ) {
          adj = pt->adj[i];
          iret = swapar(sm,k,i,n1,n2,q1,q2,0.0,0.0);
          ns++;
          if ( !pt->flag2 ) {
            pt->flag2 = 1;
            pt1 = &sm->tria[++sm->ipil];
            pt1->nxt = k;
          }
          pt1 = &sm->tria[adj];
          if ( !pt1->flag2 ) {
            pt1->flag2 = 1;
            pt1 = &sm->tria[++sm->ipil];
            pt1->nxt = adj;
          }
          break;
        }
        else {
          /* split edge */
          if ( !addver(sm,k,i,pht,0.5) )  continue;
          if ( opts.ctrl & ISO )
            iret = split4(sm,k,i);
          else
            iret = split4_a(sm,k,i);
          if ( !iret )  continue;
          na++;
          bb.ilist = boulep(sm,k,i,&bb);
          sm->ipil = 0;
          for (l=1; l<=bb.ilist; l++) {
            kk  = bb.list[l];
            pt1 = &sm->tria[kk];
            if ( !pt1->flag2 ) {
              pt1->flag2 = 1;
              pt1 = &sm->tria[++sm->ipil];
              pt1->nxt = kk;
            }
          }
          break;
        }
      }
      nsw += ns + loptia3(sm,1,declic);
    }
    /*nsw += ns + loptia3(sm,1,declic);*/
    nbs += na;
  }
  while ( ns+na > 0 );

  if ( imprim > 2 && nbs+nsw ) {
    yerr.inderr[0] = nbs;
    yerr.inderr[1] = nsw;
    primsg(4004);
  }

  E_pop();
  return(1);
}
 
 
#ifdef __cplusplus
}
#endif
