/*
 *  vertex smoothing
 *
 *  Written by Pascal J. Frey, LJLL
 *  Copyright (c) 1999-2009.  
 *  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define  SLAMBDA   0.34    /*0.33*/
#define  SMU       0.339   /*0.34*/
#define  EPSLP     1.e-12

extern int boulep2(pSurfMesh sm,int depart,int i,Ball *b);


int noshrk(pSurfMesh sm,unsigned char check) {
  pTriangle   pt,pt1,pt2;
  pPoint      p0,p1,p2;
  Ball        bb;
  double      cx,cy,cz,dd,res,res0;
  float      *tabp,*nv,*nw,nn[3],q,ox,oy,oz;
  int         i,k,kk,kl,l,it,smooth;
  ubyte       i1,i2,nk,nl;

  E_put("noshrk");
  if ( imprim < -4 )    primsg(1050);
  if ( opts.iter < 0 )  opts.iter = 150;

  if ( opts.lambda < 0.0 )  opts.lambda = SLAMBDA;
  if ( opts.mu < 0.0 )      opts.mu     = SMU;
	fprintf(stdout,"  %%%% Coefficients: %f  %f\n",opts.lambda,opts.mu);
	
  /* unmark vertices */
  for (k=1; k<=sm->npmax; k++) {
    p0 = &sm->point[k];
    p0->flag = sm->mark;
  }

  ++sm->mark;
  res0 = 0.0;
	tabp = (float*)malloc(sm->np*3*sizeof(float));
	assert(tabp);
	smooth = sm->type & M_SMOOTH;
  for (it=1; it<=opts.iter; it++) {
    /* save coords */
		for (k=1; k<=sm->np; k++) {
			p0 = &sm->point[k];
			memcpy(&tabp[3*(k-1)],p0->c,3*sizeof(float));
    }

    /* 1st stage: compute coord */
    for (k=1; k<=sm->nemax; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
        i2 = idir[i+2];
        p0 = &sm->point[pt->v[i]];

        if ( p0->flag > sm->mark )  continue;
        nv    = sm->geom[pt->v[i]].vn;
        nv[0] = p0->c[0];
        nv[1] = p0->c[1];
        nv[2] = p0->c[2];

        if ( pt->tag[i2] & M_REQUIRED )  continue;
        else if ( p0->tag & M_REQUIRED ) continue;
        else if ( p0->tag & M_CORNER )   continue;
				else if ( !smooth && p0->tag & M_RIDGE_GEO )  continue;

        bb.ilist = boulep2(sm,k,i,&bb);

        if ( bb.ilist < 1 ) {
          p0->flag = sm->mark+1;
          continue;
        }
        else if ( bb.closed ) {
          p0->flag = sm->mark+1;
          cx = cy = cz = 0.0;
          for (l=1; l<=bb.ilist; l++) {
            kk = bb.list[l];
            nk = bb.nump[l];
            i1 = idir[nk+1];
            pt1 = &sm->tria[kk];
            p1  = &sm->point[pt1->v[i1]];
            cx += p1->c[0];
            cy += p1->c[1];
            cz += p1->c[2];
          }
          dd  = 1.0 / (double)bb.ilist;
          cx *= dd;
          cy *= dd;
          cz *= dd;
        }
        else if ( pt->tag[i2] > M_NOTAG ) {
          p0->flag = sm->mark+1;
          kk = bb.list[1];
          nk = bb.nump[1];
          i1 = idir[nk+1];
          kl = bb.list[bb.ilist];
          nl = bb.nump[bb.ilist];
          i2 = idir[nl+2];
          pt1 = &sm->tria[kk];
          pt2 = &sm->tria[kl];
          p1  = &sm->point[pt1->v[i1]];
          p2  = &sm->point[pt2->v[i2]];
          cx = 0.5 * (p1->c[0]+p2->c[0]);
          cy = 0.5 * (p1->c[1]+p2->c[1]);
          cz = 0.5 * (p1->c[2]+p2->c[2]);
        }
        else
          continue;

        /* Laplacian */
        nv[0] = p0->c[0] + opts.lambda * (cx - p0->c[0]);
        nv[1] = p0->c[1] + opts.lambda * (cy - p0->c[1]);
        nv[2] = p0->c[2] + opts.lambda * (cz - p0->c[2]);
      }
    }

    /* 2nd stage: update coord */
    res = 0.0;
    for (k=1; k<=sm->nemax; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
        i2 = idir[i+2];
        if ( pt->tag[i2] & M_REQUIRED )  continue;

        p0 = &sm->point[pt->v[i]];
        if ( p0->flag < sm->mark+1 )      continue;
        else if ( p0->tag & M_REQUIRED )  continue;
        else if ( p0->tag & M_CORNER )    continue;
				else if ( !smooth && p0->tag > M_RIDGE_GEO )  continue;

        bb.ilist = boulep2(sm,k,i,&bb);

        if ( bb.ilist < 1 ) {
          p0->flag = sm->mark;
          continue;
        }
        else if ( bb.closed ) {
          p0->flag = sm->mark;
          cx = cy  = cz = 0.0;
          for (l=1; l<=bb.ilist; l++) {
            kk = bb.list[l];
            nk = bb.nump[l];
            i1 = idir[nk+1];
            pt1 = &sm->tria[kk];
            nv  = &sm->geom[pt1->v[i1]].vn[0];
            cx += nv[0];
            cy += nv[1];
            cz += nv[2];
          }
          dd  = 1.0 / (double)bb.ilist;
          cx *= dd;
          cy *= dd;
          cz *= dd;
        }
        else if ( pt->tag[i2] > M_NOTAG ) {
          p0->flag = sm->mark;
          kk = bb.list[1];
          nk = bb.nump[1];
          i1 = idir[nk+1];
          kl = bb.list[bb.ilist];
          nl = bb.nump[bb.ilist];
          i2 = idir[nl+2];
          pt1 = &sm->tria[kk];
          pt2 = &sm->tria[kl];
          nv  = &sm->geom[pt1->v[i1]].vn[0];
          nw  = &sm->geom[pt2->v[i2]].vn[0];
          cx = 0.5 * (nv[0]+nw[0]);
          cy = 0.5 * (nv[1]+nw[1]);
          cz = 0.5 * (nv[2]+nw[2]);
        }
        else
          continue;

        ox = p0->c[0];
        oy = p0->c[1];
        oz = p0->c[2];
        nv = sm->geom[pt->v[i]].vn;

				tabp[3*(pt->v[i]-1)+0] = nv[0] - opts.mu * (cx - nv[0]);
        tabp[3*(pt->v[i]-1)+1] = nv[1] - opts.mu * (cy - nv[1]);
        tabp[3*(pt->v[i]-1)+2] = nv[2] - opts.mu * (cz - nv[2]);
        p0->flag = sm->mark;
      }
    }

    /* step 3: validity check */
    if ( opts.check ) {
		  for (k=1; k<=sm->nemax; k++) {
			  pt = &sm->tria[k];
			  if ( !pt->v[0] )  continue;
			  if ( !qualfa(&tabp[3*(pt->v[0]-1)],&tabp[3*(pt->v[1]-1)],&tabp[3*(pt->v[2]-1)],&q,nn) )
				  break;
			  if ( q < 1.e-5 )  break;
		  }
    }
    else
			k = sm->nemax + 1;

		/* step 4: update coords */
		if ( k > sm->nemax ) {
			for (k=1; k<=sm->np; k++) {
				p0 = &sm->point[k];
        dd = (p0->c[0]-tabp[3*(k-1)+0])*(p0->c[0]-tabp[3*(k-1)+0]) \
           + (p0->c[1]-tabp[3*(k-1)+1])*(p0->c[1]-tabp[3*(k-1)+1]) \
           + (p0->c[2]-tabp[3*(k-1)+2])*(p0->c[2]-tabp[3*(k-1)+2]);
        res += dd;				
				memcpy(p0->c,&tabp[3*(k-1)],3*sizeof(float));
			}
		}
		else 
		  break;

    if ( it == 1 )       res0 = res;
    if ( res0 > EPSLP )  res  = res / res0;
    if ( abs(imprim) > 4 ) {
      fprintf(stdout,"    iter %8d  res %.2E\r",it,res); 
      fflush(stdout);
    }
    if ( it > 1 && res < EPSLP )  break;
  }
  fprintf(stdout,"\n");
	free(tabp);

  /* update info */
  info.xmin = info.ymin = info.zmin = (double)FLT_MAX;
  info.xmax = info.ymax = info.zmax = (double)-FLT_MAX/2.;
  for ( k=1; k<=sm->np; k++) {
    p0 = &sm->point[k];
    if ( p0->tag & M_UNUSED )  continue;
    if ( p0->c[0] < info.xmin )  info.xmin = p0->c[0];
    if ( p0->c[0] > info.xmax )  info.xmax = p0->c[0];
    if ( p0->c[1] < info.ymin )  info.ymin = p0->c[1];
    if ( p0->c[1] > info.ymax )  info.ymax = p0->c[1];
    if ( p0->c[2] < info.zmin )  info.zmin = p0->c[2];
    if ( p0->c[2] > info.zmax )  info.zmax = p0->c[2];
  }
  info.delta  = (info.xmax-info.xmin) * (info.xmax-info.xmin);
  info.delta += (info.ymax-info.ymin) * (info.ymax-info.ymin);
  info.delta += (info.zmax-info.zmin) * (info.zmax-info.zmin);
  info.delta  = sqrt(info.delta);

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    p0 = &sm->point[pt->v[0]];
    p1 = &sm->point[pt->v[1]];
    p2 = &sm->point[pt->v[2]];
    qualfa(p0->c,p1->c,p2->c,&pt->qual,pt->n);
  }

  E_pop();
  return(1);
}
