/* 
 *  compute normals and gap at mesh vertices
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1998.  All rights reserved.
*/
#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define COS70DEG    0.3420201433256688
#define COS90DEG    0.0
#define DEG2RAD     180.0 / M_PI


int norpoi(pSurfMesh sm,int npdep,int corr) {
  pPoint      ppt,p1,p2;
  pTriangle   pt,pt1;
  Ball        bb;
  Global      gl;
  double      d,ax,ay,az,bx,by,bz,nx,ny,nz,weight,sum,angdev;
  double      d1,d2,cosmin,cosmax;
  float      *np,gap,npc[3],alpha;
  int         i,k,l,kk,numk,nb,nc,ncor,it,maxtou;
  ubyte       i1,i2;

  /* default */
  E_put("norpoi");
  if ( imprim < -4 )  primsg(1011);

  /* init normals */
  info.nuln = 0;
  ncor   = sum = 0;
  angdev = min(COS90DEG,opts.ridge);
  alpha  = 0.3;
  maxtou = 5;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    for (i=0; i<3; i++)
      if ( pt->v[i] > npdep )  pt->vn[i] = 0;
  }

  /* analyze mesh vertices */
  if ( sm->dim == 2 )  corr = 0;
  sm->mark++;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      if ( pt->vn[i] > 0 )  continue;
      /* realloc memory */
      if ( sm->nv > sm->nvmax-2 && !zaldy3(sm,1) ) {
	    prierr(ERR,yerr.coderr);
	    return(0);
      }
      ++sm->nv;

      /* compute average normal */
      ppt = &sm->point[pt->v[i]];
      /*if ( ppt->tag & M_CORNER )  continue;*/
      sm->geom[sm->nv].gap = 1.0;
      np = sm->geom[sm->nv].vn;
      np[0] = np[1] = np[2] = 0.0;
      if ( sm->dim == 2 )  np[2] = 1.0;

      bb.ilist = boulep(sm,k,i,&bb);
      nb = 0;
      for (l=1; l<=bb.ilist; l++) {
        kk = bb.list[l];
        numk = bb.nump[l]; 
        pt1  = &sm->tria[kk];
        pt1->vn[numk] = sm->nv;
        if ( pt1->qual < EPS )  continue;
		if ( sm->dim == 2 )  continue;

        i1 = idir[numk+1];
        i2 = idir[numk+2];
        p1 = &sm->point[pt1->v[i1]];
        p2 = &sm->point[pt1->v[i2]];

        ax = p1->c[0] - ppt->c[0];
        ay = p1->c[1] - ppt->c[1];
        az = p1->c[2] - ppt->c[2];
        d1 = ax*ax + ay*ay + az*az;

        bx = p2->c[0] - ppt->c[0];
        by = p2->c[1] - ppt->c[1];
        bz = p2->c[2] - ppt->c[2];
        d2 = bx*bx + by*by + bz*bz;

	    nx = ay*bz - az*by;
        ny = az*bx - ax*bz;
        nz = ax*by - ay*bx;
        d  = nx*nx + ny*ny + nz*nz;
        if ( d > 0.0 ) {
	      weight = (ax*bx + ay*by + az*bz) / sqrt(d1*d2);
          weight = acos(weight) / sqrt(d);
          np[0] += weight * pt1->n[0];
          np[1] += weight * pt1->n[1];
          np[2] += weight * pt1->n[2];
          sum   += weight;
          nb++;
        }
      }
      if ( nb == 0 ) {
        memcpy(np,pt->n,3*sizeof(float));
        continue;
      }

      /* normalize vertex normal */
      d = np[0]*np[0] + np[1]*np[1] + np[2]*np[2];
      if ( d == 0.0 )
        info.nuln++;
      else {
        d = 1.0 / sqrt(d);
        np[0] *= d;
        np[1] *= d;
        np[2] *= d;
      }

      /* check normal deviation */
      if ( ppt->tag & M_CORNER )  continue;
      if ( !corr ) {
        /* compute gap */
        gap = np[0]*pt->n[0] + np[1]*pt->n[1] + np[2]*pt->n[2];
        if ( gap < sm->geom[sm->nv].gap )
	      sm->geom[sm->nv].gap = gap;
        continue;
      }

      /* analyze */
      it = nc = 0;
      do {
        cosmin = 1.0;
        cosmax = 0.0;
	    for (l=1; l<=bb.ilist; l++) {
	      kk = bb.list[l];
          pt1 = &sm->tria[kk];
          gl.h[l] = pt1->n[0]*np[0] + pt1->n[1]*np[1] + pt1->n[2]*np[2];
          if ( gl.h[l] < cosmin )  cosmin = gl.h[l];        
          if ( gl.h[l] > cosmax )  cosmax = gl.h[l];
          gl.n[l][0] =  pt1->n[0];
          gl.n[l][1] =  pt1->n[1];
          gl.n[l][2] =  pt1->n[2];
        }
        if ( cosmin > angdev )  break;
        else if ( cosmax < angdev ) {
		  ppt->tag |= M_CORNER;
          break;
        }

        /* correction */
        nc = 1;
        ncor++;
        npc[0] = npc[1] = npc[2] = 0.0f;
	    for (l=1; l<=bb.ilist; l++) {
          weight  = 1.05 - gl.h[l];
          weight *= weight;
          npc[0] += weight * gl.n[l][0];
          npc[1] += weight * gl.n[l][1];
          npc[2] += weight * gl.n[l][2];
        }
        d = npc[0]*npc[0]+npc[1]*npc[1]+npc[2]*npc[2];
        if ( d > 0.0 ) {
          d = 1.0 / sqrt(d);
          npc[0] *= d;
          npc[1] *= d;
          npc[2] *= d;
        }
        np[0] = (1-alpha)*np[0] + alpha*npc[0];
        np[1] = (1-alpha)*np[1] + alpha*npc[1];
        np[2] = (1-alpha)*np[2] + alpha*npc[2];
        d = np[0]*np[0]+np[1]*np[1]+np[2]*np[2];
        if ( d > 0.0 ) {
          d = 1.0 / sqrt(d);
          np[0] *= d;
          np[1] *= d;
          np[2] *= d;
        }
      }
      while ( nc > 0 && ++it < maxtou );
	  if ( nc > 0 )  ppt->tag |= M_CORNER;

      /* compute gap */
      gap = np[0]*pt->n[0] + np[1]*pt->n[1] + np[2]*pt->n[2];
      if ( gap < sm->geom[sm->nv].gap )
	    sm->geom[sm->nv].gap = gap;
    }
  }
  if ( imprim < 0 && ncor > 0 ) {
    yerr.inderr[0] = ncor;
    prierr(WAR,4015);
  }

  E_pop();
  return(1);
}

