/*
 * compute edge length for (anisotropic) metric
 *
 *  Written by Pascal J. Frey
 *  email: Pascal.Frey@inria.fr, 2001
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


double lenseg_a(pPoint a,pPoint b,pMetric ma,pMetric mb) {
  double    dd1,dd2,tail,ux,uy,uz;

  ux = b->c[0] - a->c[0];
  uy = b->c[1] - a->c[1];
  uz = b->c[2] - a->c[2];

  dd1 =      ma->m[0]*ux*ux + ma->m[3]*uy*uy + ma->m[5]*uz*uz \
      + 2.0*(ma->m[1]*ux*uy + ma->m[2]*ux*uz + ma->m[4]*uy*uz);
  if ( dd1 <= 0.0f )  dd1 = 0.0;

  dd2 =      mb->m[0]*ux*ux + mb->m[3]*uy*uy + mb->m[5]*uz*uz \
      + 2.0*(mb->m[1]*ux*uy + mb->m[2]*ux*uz + mb->m[4]*uy*uz);
  if ( dd2 <= 0.0f )  dd2 = 0.0;

  tail = (sqrt(dd1)+sqrt(dd2)+4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
  return(tail);
}


double lenseg(pPoint a,pPoint b) {
  double    dd,rap,tail,ux,uy,uz;

  ux = b->c[0] - a->c[0];
  uy = b->c[1] - a->c[1];
  uz = b->c[2] - a->c[2];
  dd = sqrt(ux*ux + uy*uy + uz*uz);

  rap = (b->size - a->size) / a->size;
  if ( fabs(rap) < EPS )
    tail = dd * (2.-EPS) / (2.*a->size);
  else {
    /*
    lograp = log(b->size/a->size);
    tail   = dd * lograp / (b->size-a->size);
    */
    tail = dd * (1.0/a->size + 1.0/b->size + 8.0 / (a->size+b->size)) / 6.0;
  }  
  return(tail);
}

#ifdef __cplusplus
}
#endif
