/* 
 *  mesh file format reader/manipulator.
 *
 *  Written by Pascal J. Frey, 1998, 1999.
 *  email: Pascal.Frey@inria.fr
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int inmsh2(pSurfMesh sm,char *filein,int memory,int choix) {
  FILE      *inp,*inf;
  pPoint     ppt,p0,p1,p2,p3;
  pTriangle  pt1;
  pEdge      pte;
  double     dd1,dd2;
  float      n1[3],n2[3],q1,q2;
  int        i,i1,i2,j,k,degree,disc,nbfac,nefixe,npfixe;
  int        ret,a,b,v[4],ref,edg[4];
  char      *ptr,data[256],sx[128],sy[128],sz[128];


  /* check for .points */
  E_put("inmsh2");
  strcpy(data,filein);
  strcat(data,".points");
  inp = fopen(data,"r");
  if ( !inp ) {
    fprintf(stderr,"  %%%% FILE %s NOT FOUND. STOP.\n",data);
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* check for .faces */
  strcpy(data,filein);
  strcat(data,".faces");
  inf = fopen(data,"r");
  if ( !inf ) {
    fprintf(stderr,"  %%%% FILE %s NOT FOUND. STOP.\n",data);
    return(0);
  }
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  /* get number of vertices */
  fgets(data,255,inp);
  sscanf(data,"%d",&sm->npfixe);
  npfixe = sm->npfixe;
  fgets(data,255,inf);
  sscanf(data,"%d",&nefixe);
  sm->dim = 3;

  /* first pass get number of faces */
  sm->nefixe = 0;
  sm->nafixe = 0;
  for (k=1; k<=nefixe; k++) {
    fscanf(inf,"%d",&degree);
    switch(degree) {
    case 2: sm->nafixe++;    break;
    case 3: sm->nefixe++;    break;
    case 4: sm->nefixe += 2; break;
    default:
      yerr.coderr = 0000;
      yerr.inderr[0] = degree;
      fclose(inp);
      fclose(inf);
      return(0);
    }
    fgets(data,80,inf);
  }

  /* check if vertices and elements found */
  if ( !sm->npfixe || !sm->nefixe ) {
    yerr.coderr = 0001;
    fclose(inp);
    fclose(inf);
    return(0);
  }

  /* memory allocation for data structures */
  if ( sm->type & M_DETECT )
    sm->nvfixe = 1.50*sm->npfixe;
  else
    sm->nvfixe = 1.05*sm->npfixe;
  if ( zaldy1(sm->nefixe,sm->npfixe,sm->nvfixe,memory,sm,choix) != TRUE ) {
    fclose(inp);
    fclose(inf);
    return(0);
  }

  /* read mesh vertices */
  for(k=1; k<=npfixe; k++) {
    ppt = &sm->point[k];
    /* parse coordinates into strings */
    ret = fscanf(inp,"%s %s %s %d",sx,sy,sz,&ref);
    if ( ret != 4 ) {
      yerr.coderr = 0000;
      yerr.inderr[0] = ret;
      fclose(inp);
      fclose(inf);
      return(0);
    }
    if ( ptr = strpbrk(sx,"dD") )  *ptr = 'E';
    if ( ptr = strpbrk(sy,"dD") )  *ptr = 'E';
    if ( ptr = strpbrk(sz,"dD") )  *ptr = 'E';

    sscanf(sx,"%f",&ppt->c[0]);
    sscanf(sy,"%f",&ppt->c[1]);
    sscanf(sz,"%f",&ppt->c[2]);
    ppt->ref   = ref;
    ppt->tag   = M_UNUSED;
    ppt->color = 0;
    ppt->size  = -1.;
    ppt->tge   = 0;
    ppt->geom  = M_CURVE;
    /* find extrema coordinates */
    if ( ppt->c[0] < info.xmin ) info.xmin = ppt->c[0];
    if ( ppt->c[0] > info.xmax ) info.xmax = ppt->c[0];
    if ( ppt->c[1] < info.ymin ) info.ymin = ppt->c[1];
    if ( ppt->c[1] > info.ymax ) info.ymax = ppt->c[1];
    if ( ppt->c[2] < info.zmin ) info.zmin = ppt->c[2];
    if ( ppt->c[2] > info.zmax ) info.zmax = ppt->c[2];
  }
  fclose(inp);

  /* mesh edges, if any */
  if ( sm->nafixe > 0 ) {
    sm->edge = (pEdge)M_calloc(sm->nafixe+1,sizeof(Edge),"inmsh2");
    if ( sm->edge == NULL ) {
      prierr(WAR,0021);
      fclose(inp);
      fclose(inf);
      return(0);
    }
  }

  /* read mesh faces */
  rewind(inf);
  fgets(data,255,inf);
  sscanf(data,"%d",&nbfac);
  sm->nefixe = 0;
  sm->nafixe = 0;
  sm->npfixe = npfixe;
  disc = 0;
  for (k=1; k<=nbfac; k++) {
    fscanf(inf,"%d",&degree);
    if ( degree == 3 ) {
      pt1 = &sm->tria[++sm->nefixe];
      fscanf(inf,"%d %d %d %d %d %d %d\n",&pt1->v[0],&pt1->v[1],&pt1->v[2],
	     &ref,&pt1->edg[2],&pt1->edg[0],&pt1->edg[1]);
      if ( pt1->v[0] <= 0 || pt1->v[0] > npfixe ||
           pt1->v[1] <= 0 || pt1->v[1] > npfixe ||
           pt1->v[2] <= 0 || pt1->v[2] > npfixe ) {
	yerr.inderr[0] = k;
	prierr(WAR,0020);
	disc++;
	pt1->v[0] = 0;
	continue;
      }
      pt1->ref = ref;
      if ( opts.noreff ) pt1->ref = 0;
    }
    else if ( degree == 4 ) {
      fscanf(inf,"%d %d %d %d %d",&v[0],&v[1],&v[2],&v[3],&ref);
      fscanf(inf,"%d %d %d %d\n",&edg[0],&edg[1],&edg[2],&edg[3]);
      for (j=0; j<4; j++) {
        if ( v[j] <= 0 || v[j] > sm->npfixe ) {
          yerr.inderr[0] = k;
          prierr(WAR,0020);
          disc++;
          break;
        }
      }
      if ( j < 4 )  continue;
      p0 = &sm->point[v[0]];
      p1 = &sm->point[v[1]];
      p2 = &sm->point[v[2]];
      p3 = &sm->point[v[3]];
      qualfa(p0->c,p1->c,p2->c,&q1,n1);
      qualfa(p0->c,p2->c,p3->c,&q2,n2);
      dd1 = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
      
      qualfa(p0->c,p1->c,p3->c,&q1,n1);
      qualfa(p1->c,p2->c,p3->c,&q2,n2);
      dd2 = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
      
      if ( dd1 > dd2 ) {
        pt1 = &sm->tria[++sm->nefixe];
        pt1->v[0] = v[0];
        pt1->v[1] = v[1];
        pt1->v[2] = v[2];
        pt1->ref  = ref;
        pt1->edg[0] = edg[1];
        pt1->edg[2] = edg[0];
        pt1 = &sm->tria[++sm->nefixe];
        pt1->v[0] = v[0];
        pt1->v[1] = v[2];
        pt1->v[2] = v[3];
        pt1->ref  = ref;
        pt1->edg[0] = edg[2];
        pt1->edg[1] = edg[3];
      }
      else {
        pt1 = &sm->tria[++sm->nefixe];
        pt1->v[0] = v[0];
        pt1->v[1] = v[1];
        pt1->v[2] = v[3];
        pt1->ref  = ref;
        if ( opts.noreff ) pt1->ref = 0;
        pt1->edg[1] = edg[3];
        pt1->edg[2] = edg[0];
        pt1 = &sm->tria[++sm->nefixe];
        pt1->v[0] = v[1];
        pt1->v[1] = v[2];
        pt1->v[2] = v[3];
        pt1->ref  = ref;
        if ( opts.noreff ) pt1->ref = 0;
        pt1->edg[0] = edg[2];
        pt1->edg[2] = edg[1];
      }
    }
    else if ( degree == 2 ) {
      pte = &sm->edge[++sm->nafixe];
      fscanf(inf,"%d %d %d %d %d\n",&pte->p1,&pte->p2,&ref,&a,&b);
      pte->ref = ref;
      if ( opts.noreff ) pte->ref = 0;
      /* vertex coloring */
      if ( pte->ref ) {
	ppt = &sm->point[pte->p1];
	if ( !ppt->color )	            ppt->color = pte->ref;
	else if ( ppt->color != pte->ref )  ppt->tag |= M_REQUIRED;
	ppt = &sm->point[pte->p2];
	if ( !ppt->color )                  ppt->color = pte->ref;     
	else if ( ppt->color != pte->ref )  ppt->tag |= M_REQUIRED;
      }
    }
  }
  fclose(inf);

  /* check edge tags, vertex coloring */
  for (k=1; k<=sm->nefixe; k++) {
    pt1 = &sm->tria[k];
    if ( !pt1->v[0] ) continue;
    for (i=0; i<3; i++) {
      ppt = &sm->point[pt1->v[i]];
      ppt->tag &= ~M_UNUSED;
      if ( pt1->edg[i] ) {
	i1 = idir[i+1];
	ppt = &sm->point[pt1->v[i1]];
	if ( !ppt->color )                    ppt->color = pt1->edg[i];
	else if ( ppt->color != pt1->edg[i] ) ppt->tag |= M_REQUIRED;
	i2 = idir[i+2];
	ppt = &sm->point[pt1->v[i2]];
	if ( !ppt->color )                    ppt->color = pt1->edg[i];
	else if ( ppt->color != pt1->edg[i] ) ppt->tag |= M_REQUIRED;
      }
    }
  }
  /* count unused vertices */
  for (k=1; k<=sm->npfixe; k++) {
    ppt = &sm->point[k];
    if ( ppt->tag & M_UNUSED )  info.nulp++;
  }

  if ( disc > 0 && imprim ) {
    yerr.inderr[0] = disc;
    prierr(WAR,0022);
  }
  
  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
