#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


void inival() {
  
  /* initialize data */
  E_put("inival");
  info.dmin  = (double)FLT_MAX; 
  info.dmax  = (double)FLT_MIN;
  info.xmin  = info.ymin = info.zmin = (double)FLT_MAX;
  info.xmax  = info.ymax = info.zmax = (double)-FLT_MAX/2.;
  info.nedg  = info.nrid = info.ndang = 0;
  info.ncoi  = info.nreq = info.nvus  = 0;
  info.cc    = info.flip = 0;
  info.nulp  = info.nulf = info.nuln = 0;
  info.qpire = 0;
  info.manifold = TRUE;

  /* set default values for options */
  opts.hmin   = -2.0;    
  opts.hmax   = -2.0;
  opts.shock  =   1.3;       /* default mesh gradation     */
  opts.eps    =   0.01;      /* geometric approximation    */
	opts.iso    =   0.0;
  opts.declic =   1.0 / BETAC;
  opts.lambda =   -1.0;
  opts.mu     =   -1.0;
  opts.ridge  =   cos(RIDG*M_PI/180.);
  opts.geom   =   cos(GEOM*M_PI/180.);
  opts.walton =   COS45DEG;  /* Walton limitation          */
  opts.bande  =   -2;       /* default = 1 unit           */
  opts.degrad =   QUALCOE;   /* quality degradation        */
  opts.ctrl   =   REL | ISO;
  opts.iter   =   -1;
	opts.check  = 1;
  opts.alpha  = sqrt(opts.eps*(2.0-opts.eps));
  opts.gap    = 1 - opts.eps;
  
  opts.minnp  =   -1;
  opts.alpha  =   sqrt(opts.eps*(2.0-opts.eps));
  opts.gap    =   1.0 - opts.eps;

  E_pop();
}

