/* 
 *  data file format reader/manipulator.
 *
 *  Written by Pascal J. Frey, 1998, 1999.
 *  email: Pascal.Frey@inria.fr
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern ubyte ecp;


int inbbf(pSurfMesh sm,char *filein) {
  FILE   *in;
  pPoint  ppt;
  pMetric pm;
  double  a,b,c,size,m[6],lambda[3],vp[2][2],vp3[3][3];
  float   dum;
  int     i,k,l,dim,nfield,np,typage,ret;
  char   *ptr,data[128];

  E_put("inbbf");
  strcpy(data,filein);
  ptr = (char *)strstr(data,".mesh");
  if ( ptr )  *ptr = '\0';

  if ( ecp ) 
    strcat(data,".met");
  else
    strcat(data,".bb");
  in = fopen(data,"r");
  if ( !in )  return(0);
  else if ( imprim )
    fprintf(stdout,"  %%%% %s OPENED\n",data);

  if ( ecp ) {
    dim    = 2;
    nfield = 3;
    np     = sm->np;
    typage = 2;
    goto nxt;
  }

  fscanf(in,"%d",&dim);
  if ( dim < 2 || dim > 3 || dim != sm->dim ) {
    yerr.inderr[0] = dim;
    prierr(ERR,0000);
    E_pop();
    return(0);
  }

  /* read number of field(s) */
  fscanf(in,"%d",&nfield);
  fscanf(in,"%d",&np);
  if ( np < sm->np ) {
    prierr(ERR,0004);
    E_pop();
    return(0);
  }

  /* read file type */
  fscanf(in,"%d",&typage);
  if ( typage != 2 ) {
    yerr.inderr[0] = typage;
    prierr(ERR,0000);
    E_pop();
    return(0);
  }

  if ( nfield != 1 && nfield != dim*(dim+1)/2 ) {
    prierr(ERR,0004);
    E_pop();
    return(0);
  }

nxt:
  /* scalar field */
  if ( nfield == 1 ) {
    for (k=1; k<=sm->np; k++) {
      ppt = &sm->point[k];
      ret = fscanf(in,"%s",data);
      if ( ret != 1 )  continue;

      if ( ptr = strpbrk(data,"dD") )  *ptr = 'E';
      sscanf(data,"%f",&ppt->size);
      ppt->size = max(ppt->size,EPS);
    }
  }

  /* vector field: convert to iso */
  else if ( dim == nfield ) {
    if ( dim == 2 ) {
      for (k=1; k<=sm->np; k++) {
        ppt = &sm->point[k];
        fscanf(in,"%lf %lf",&a,&b);
        ppt->size = sqrt(a*a+b*b);
        ppt->size = max(ppt->size,EPS);
      }
    }
    else {
      for (k=1; k<=sm->np; k++) {
        ppt = &sm->point[k];
        fscanf(in,"%lf %lf %lf",&a,&b,&c);
        ppt->size = sqrt(a*a+b*b+c*c);
        ppt->size = max(ppt->size,EPS);
      }
    }
  }
  
  /* metric */
  else if ( dim == 2 && nfield == 3 ) {
    if ( !sm->metric && !zaldy3(sm,3) )  return(0);
    for (k=1; k<=sm->np; k++) {
      ppt = &sm->point[k];
      pm  = &sm->metric[k];
      for (i=0; i<6; i++)  pm->m[i] = 0.0;
      for (i=0; i<3; i++) {
        ret = fscanf(in,"%s",data);
        if ( ret != 1 )  continue;
        if ( ptr = strpbrk(data,"dD") )  *ptr = 'E';
        sscanf(data,"%f",&dum);
	m[i] = dum;
      }
      eigen2(m,lambda,vp);
      size      = max(lambda[0],lambda[1]);
      ppt->size = max(1.0 / sqrt(size),EPS);
      if ( opts.hmin > 0.0 )
        ppt->size = max(opts.hmin,ppt->size);
      pm->m[0] = m[0];
      pm->m[1] = m[1];
      pm->m[3] = m[2];
      pm->m[5] = 0.1*min(fabs(m[0]),fabs(m[2]));
      pm->m[2] = pm->m[4] = 0.0;
      pm->k1 = pm->k2 = (float)FLT_MAX;
    }
    if ( opts.ctrl & ISO ) opts.ctrl ^= ISO;
  }

  else if ( dim == 3 && nfield == 6 ) {
    if ( !sm->metric && !zaldy3(sm,3) )  return(0);
    /* structure: a b d    convert to   a b c
                    c e                   d e
                      f                     f */
    for (k=1; k<=sm->np; k++) {
      ppt = &sm->point[k];
      pm  = &sm->metric[k];
      for (i=0; i<6; i++) {
        ret = fscanf(in,"%s",data);
        if ( ret != 1 )  continue;
        if ( ptr = strpbrk(data,"dD") )
	  *ptr = 'E';
        sscanf(data,"%f",&dum);
	m[i] = dum;
      }
      pm->m[0] = m[0];
      pm->m[1] = m[1];
      pm->m[2] = m[3];
      pm->m[3] = m[2];
      pm->m[4] = m[4];
      pm->m[5] = m[5];

      pm->k1 = pm->k2 = (float)FLT_MAX;
      for (l=0; l<6; l++)  m[l] = pm->m[l];
      if ( !eigenv(1,m,lambda,vp3) ) {
        fprintf(stderr,"  ## ERR 9201, inbbf, Not a metric tensor. Discarded\n");
	M_free(sm->metric);
	sm->metric = 0;
	break;
      }
      size      = max(max(lambda[0],lambda[1]),lambda[2]);
      ppt->size = max(1.0 / sqrt(size),EPS);
      if ( opts.hmin > 0.0 )
        ppt->size = max(opts.hmin,ppt->size);
    }
    if ( opts.ctrl & ISO ) opts.ctrl ^= ISO;
  }

  fclose(in);
  E_pop();
  return( min(np,sm->np) );
}

