/* Heap data structure 
 * Copyright INRIA, 2002
*/
#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int  *heap=NULL,hn,hnmax;

/* function pointers */
int compar1(pTriangle pt1,pTriangle pt2) {
  return(pt1->dish < pt2->dish);
}


int compar2(pTriangle pt1,pTriangle pt2) {
  return(pt1->qual < pt2->qual);
}


int (*compar)(pTriangle ,pTriangle );


static void hipup(pTriangle tria,int k) {
  int     i,j;

  i = k / 2;
  j = heap[k];
  while ( (i > 0) && compar(&tria[j],&tria[heap[i]]) ) {
    heap[k] = heap[i];
    tria[heap[i]].nxt = k;
    k  = i;
    i /= 2;
  }
  heap[k]     = j;
  tria[j].nxt = k;
}


static void hipdown(pTriangle tria,int k) {
  int    i,j,n;

  i = heap[k];
  n = hn / 2;
  while ( k <= n ) {
    j = k+k;
    if ( j < hn ) {
      if ( compar(&tria[heap[j+1]],&tria[heap[j]]) )
        j = j+1;
    }
    if ( compar(&tria[i],&tria[heap[j]]) ) 
      break;
    heap[k] = heap[j];
    tria[heap[j]].nxt = k;
    k = j;
  }
  heap[k]   = i;
  tria[i].nxt = k;
}


int hippop(pTriangle tria) {
  int    j;

  if ( hn < 1 )  return(0);
  j = heap[1];
  if ( hn > 1 ) {
    heap[1] = heap[hn];
    tria[heap[hn--]].nxt = 1;
    hipdown(tria,1);
  }
  else
    hn--;
  return(j);
}


void hipput(pTriangle tria,int k) {
  if ( ++hn > hnmax )  exit(1);
  heap[hn]    = k;
  tria[k].nxt = hn;
  hipup(tria,hn);
}


void hiprep(pTriangle tria,int k) {
  hipdown(tria,tria[k].nxt);
  hipup(tria,tria[k].nxt);
}


int hipini(pSurfMesh sm,int cp) {
  pTriangle   pt;
  int         k;

  E_put("hipini");
  if ( !heap ) {
    hnmax = sm->nemax+1;
    heap  = (int*)M_calloc(hnmax,sizeof(int),"hipini");
    if ( !heap ) {
      prierr(ERR,0034);
      return(0);
    }
  }
  hn = 0;

  /* set function */
  compar = cp == 1 ? compar1 : compar2;

  /* store all elts! */
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( pt->v[0] )  hipput(sm->tria,k);   
  }
  
  E_pop();
  return(1);
}


void hipfree() {
  M_free(heap);
  heap = NULL;
}
