#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


void hinit(int npmax) {
  int   k;

  hsize = 2 * npmax;
  hnext = hsize;
  memset(hash,0,nhmax*sizeof(Hashtable));
  for (k=hsize; k<nhmax; k++)
    hash[k].nxt = k+1;
}


int hcode(pSurfMesh sm,int a,int b,int elt,int ind) {
  pHashtable  pht;
  pTriangle   pt,pta,pt1;
  int         c,cc,abmin,adj,sum;
  ubyte       voy;

  /* default */
  sum = a+b;
  if ( sum >= nhmax ) {
    yerr.coderr = 1015;
    return(0);
  }

  pht   = &hash[sum];
  abmin = min(a,b);

  /* edge ab not stored */
  if ( pht->min == 0 ) {
    pht->min = abmin;
    pht->elt = elt;
    pht->ind = ind;
    return(1);
  }
  /* analyze linked list */
  do {
    pt  = &sm->tria[elt];
    pt1 = &sm->tria[pht->elt];
    c   = pt->v[ind];
    cc  = pt1->v[pht->ind];

    if ( pht->min == abmin ) {
      /* check for duplicate face */
			if ( cc == c )  return(0);

      adj = pt1->adj[pht->ind];
      if ( adj == 0 ) {
        pt->adj[ind] = pht->elt;
        pt->voy[ind] = (ubyte)pht->ind;
        pt1->adj[pht->ind] = elt;
        pt1->voy[pht->ind] = (ubyte)ind;
      }
      else {
        /* non manifold edge */
        voy = (ubyte)pt1->voy[pht->ind];
        pta = &sm->tria[adj];
        cc  = pta->v[voy];

        /* check for duplicate face */
				if ( cc == c )  return(0);

        pta->tag[voy] |= M_NOMANIFOLD;
        pt1->adj[pht->ind]  = elt;
        pt1->voy[pht->ind]  = (ubyte)ind;
        pt1->tag[pht->ind] |= M_NOMANIFOLD;
        pt->adj[ind]  = adj;
        pt->voy[ind]  = voy;
        pt->tag[ind] |= M_NOMANIFOLD;
      }
      return(1);
    }
    else if ( !pht->nxt ) {
      /* insert edge ab */
      pht->nxt   = hnext;         /* next available entry */
      pht        = &hash[hnext];  /* store edge ab        */
      if ( pht == 0 ) {
        yerr.lerror = TRUE;
        yerr.coderr = 1010;
				return(0);
      }
      pht->min   = abmin;
      pht->elt   = elt;
      pht->ind   = ind;
      hnext      = pht->nxt;
      pht->nxt   = 0;             /* end of collision     */

      /* check for size overflow */
			if ( !hnext && !zaldy2(0) )  return(0);

      return(1);
    }
    pht = &hash[pht->nxt];
  } while (1);

  return(0);  
}


int hcode_q(pSurfMesh sm,int a,int b,int elt,int ind) {
  pHashtable  pht;
  pQuad       pq,pqa,pq1;
  int         abmin,adj,sum;
  ubyte       voy;

  /* default */
  sum = a+b;
  if ( sum >= nhmax ) {
    yerr.coderr = 1015;
    return(0);
  }
  pht   = &hash[sum];
  abmin = min(a,b);

  /* edge ab not stored */
  if ( !pht->min ) {
    pht->min = abmin;
    pht->elt = elt;
    pht->ind = ind;
    return(1);
  }

  /* analyze linked list */
  pq  = &sm->quad[elt];
  do {
    pq1 = &sm->quad[pht->elt];
    if ( pht->min == abmin ) {
      adj = pq1->adj[pht->ind];
      if ( !adj ) {
        pq->adj[ind] = pht->elt;
        pq->voy[ind] = pht->ind;
        pq1->adj[pht->ind] = elt;
        pq1->voy[pht->ind] = ind;
      }
      else {
        /* non manifold edge */
        voy = (ubyte)pq1->voy[pht->ind];
        pqa = &sm->quad[adj];

        pqa->tag[voy] |= M_NOMANIFOLD;
        pq1->adj[pht->ind]  = elt;
        pq1->voy[pht->ind]  = (ubyte)ind;
        pq1->tag[pht->ind] |= M_NOMANIFOLD;
        pq->adj[ind]  = adj;
        pq->voy[ind]  = voy;
        pq->tag[ind] |= M_NOMANIFOLD;
      }
      return(1);
    }
    else if ( !pht->nxt ) {
      pht->nxt = hnext;
      pht      = &hash[hnext];
      if ( !pht ) {
        yerr.coderr = 1010;
        return(0);
      }
      pht->min   = abmin;
      pht->elt   = elt;
      pht->ind   = ind;
      hnext      = pht->nxt;
      pht->nxt   = 0;

      /* check for size overflow */
      if ( !hnext && !zaldy2(0) )  return(0);

      return(1);
    }
    pht = &hash[pht->nxt];
  } while (1);

  return(0);  
}


pHashtable hedge(int a,int b,int *elt,int *ind) {
  pHashtable  pht;
  int         abmin,sum;

  /* default */
  sum = a+b;
  if ( sum >= nhmax ) {
    yerr.lerror = TRUE;
    yerr.coderr = 1015;
    return(0);
  }

  pht   = &hash[sum];
  abmin = min(a,b);

  /* first occurence of sum */
  if ( !pht->min )  return(0);
  
  while ( pht->nxt && pht->min != abmin )
    pht = &hash[pht->nxt];

  if ( pht->min == abmin ) {
    *ind = pht->ind;
    *elt = pht->elt;
    return(pht);
  }
  else 
    return(0);
}


int hexist(int a,int b) {
  pHashtable  pht;
  int         abmin,sum;

  /* default */
  sum = a+b;
  if ( sum >= nhmax ) {
    yerr.lerror = TRUE;
    yerr.coderr = 1015;
    return(0);
  }

  pht   = &hash[sum];
  abmin = min(a,b);

  /* first occurence of sum */
  if ( !pht->min )  return(0);

  while ( pht->nxt && pht->min != abmin ) {
    pht = &hash[pht->nxt];
  }

  return(pht->min == abmin);
}


int hpop(int a,int b) {
  pHashtable  pht,pht1;
  long        nxt;
  int         abmin,sum;

  /* default */
  sum = a+b;
  if ( sum >= nhmax ) {
    yerr.lerror = TRUE;
    yerr.coderr = 1015;
    return(0);
  }

  pht   = &hash[sum];
  abmin = min(a,b);
  /* first occurence of sum */
  if ( pht->min == abmin ) {
    if ( !pht->nxt ) {
      pht->min = 0;
      return(1);
    }
    pht1      = &hash[pht->nxt];
    pht->min  = pht1->min;
    nxt       = hnext;
    hnext     = pht->nxt;
    pht->nxt  = pht1->nxt;
    pht1->nxt = nxt;
    return(1);
  }
  /* check if next item */
  else if ( !pht->nxt )
    return(0);

  pht1 = pht;
  while ( pht->nxt && pht->min != abmin ) {
    pht1 = pht;
    pht  = &hash[pht->nxt];
  }

  if ( pht->min == abmin ) {
    nxt       = hnext;
    hnext     = pht1->nxt;
    pht1->nxt = pht->nxt;
    pht->nxt  = nxt;
    return(1);
  }

  return(0);
}


int hpush(int a,int b) {
  pHashtable  pht;
  int         abmin = min(a,b),sum;

  /* default */
  sum = a+b;
  if ( sum >= nhmax )  return(0);

  pht   = &hash[sum];
  abmin = min(a,b);

  /* first occurence of sum */
  if ( !pht->min ) {
    pht->min = abmin;
    return(1);
  }

  while ( pht->min != abmin && pht->nxt > 0 )
    pht = &hash[pht->nxt];

  /* check if entry found */
  if ( pht->min == abmin )  return(1);

  /* scan collisions */
  pht->nxt  = hnext;         /* next available entry */
  pht       = &hash[hnext];  /* store edge ab        */
  pht->min  = abmin;
  hnext     = pht->nxt;
  pht->nxt  = 0;             /* end of collision     */

  /* check for size overflow */
  if ( hnext == 0 && !zaldy2(0) )
    return(0);

  return(1);
}
