#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define COS170DEG    -0.984807753012208

int flprdg(pSurfMesh sm) {
  pTriangle  pt;
  pPoint     p0,p1,p2;
  double     dd,ux,uy,uz,vx,vy,vz;
  float      n1[3],n2[3],q1,q2,lbande,angdev;
  int        k,ns,npp,nsw,it,maxtou;
  ubyte      i,i1,i2;

  /* default */
  E_put("flprdg");
  if ( abs(imprim) > 3 )  primsg(2004);

  maxtou = 5;
  sm->mark++;
  lbande = 0.001*info.delta;
  angdev = opts.geom;
  npp = nsw = it = 0;
  ++sm->mark;

  do {
    ns = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark + 1;

      for (i=0; i<3; i++) {
        i1 = idir[i+1];
        i2 = idir[i+2];
        /*if ( pt->tag[i] > M_NOTAG && pt->tag[i2] > M_NOTAG )*/ {
          if ( pt->tag[i1] > M_NOTAG )  continue;
          
          p0 = &sm->point[pt->v[i]];
          p1 = &sm->point[pt->v[i1]];
          p2 = &sm->point[pt->v[i2]];

          ux = p2->c[0] - p1->c[0];
          uy = p2->c[1] - p1->c[1];
          uz = p2->c[2] - p1->c[2];
          dd = sqrt(ux*ux + uy*uy + uz*uz);
          if ( dd <= 0.0 )  continue;
          dd  = 1.0 / dd;
          ux *= dd;
          uy *= dd;
          uz *= dd;

          vx = p0->c[0] - p1->c[0];
          vy = p0->c[1] - p1->c[1];
          vz = p0->c[2] - p1->c[2];
          dd = sqrt(vx*vx + vy*vy + vz*vz);
          if ( dd <= 0.0 )  continue;
          dd  = 1.0 / dd;
          vx *= dd;
          vy *= dd;
          vz *= dd;
          
          dd = ux*vx + uy*vy + uz*vz;
          if ( dd > COS170DEG )  continue;
          npp++;
          if ( flipa3(sm,k,i1,n1,n2,&q1,&q2) ) {
            ns += swapar(sm,k,i1,n1,n2,q1,q2,0.,0.);
          }
        }
      }
    }
    nsw += ns;
  }
  while ( ns > 0 && ++it < maxtou );

  if ( nsw && abs(imprim) > 2 ) {
    yerr.inderr[0] = npp;
    yerr.inderr[1] = nsw;
    primsg(2012);
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
