#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int flipa3(pSurfMesh sm,int k,int i,float *n1,float *n2,float *q1,float *q2) {
  pTriangle   pt,pt1,pta;
  pPoint      ppa,ppb,ppc,ppd;
  double      cosang1,cosang2,di,da;
  double      dd1,dd2,ddn,d1,d2,d3,d4,d5,ux,uy,uz,vx,vy,vz,wx,wy,wz;
  float       qtarget,hd1,hd2;
  int         adj,a,b,c,d;
  ubyte       i1,i2,v1,v2,voy;

  /* default */
  pt  = &sm->tria[k];
  adj = pt->adj[i];
  voy = pt->voy[i];

  /* check tag consistency */
  if ( !adj ) {
    prierr(ERR,1012);
    return(0);
  }
  pt1 = &sm->tria[adj];
  if ( pt1->tag[voy] > M_NOTAG ) {
    prierr(ERR,1012);
    return(0);
  }
  cosang1 = fabs(pt->n[0]*pt1->n[0] + pt->n[1]*pt1->n[1] + pt->n[2]*pt1->n[2]);
  /*if ( cosang1 > COS2DEG )  return(0);*/
  qtarget = opts.degrad * min(pt->qual,pt1->qual);

  i1 = idir[i+1];
  i2 = idir[i+2];
  a  = pt->v[i];
  b  = pt->v[i1];
  d  = pt->v[i2];
  c  = pt1->v[voy];

  /* check alternate edge */
  if ( hexist(a,c) )  return(0);

  ppa = &sm->point[a];
  ppb = &sm->point[b];
  ppc = &sm->point[c];
  ppd = &sm->point[d];

  /* compute edge lengths */
  ux = wx = ppb->c[0] - ppa->c[0];
  uy = wy = ppb->c[1] - ppa->c[1];
  uz = wz = ppb->c[2] - ppa->c[2];
  d1 = ux*ux + uy*uy + uz*uz;
  if ( d1 == 0.0f )  return(0);

  vx = ppc->c[0] - ppa->c[0];
  vy = ppc->c[1] - ppa->c[1];
  vz = ppc->c[2] - ppa->c[2];
  d2 = vx*vx + vy*vy + vz*vz;
  if ( d2 == 0.0f )  return(0);

  /* compute new face normal */
  n1[0] = uy*vz - uz*vy;
  n1[1] = uz*vx - ux*vz;
  n1[2] = ux*vy - uy*vx;
  dd1 = n1[0]*n1[0] + n1[1]*n1[1] + n1[2]*n1[2];
  if ( dd1 == 0.0f )  return(0);
  dd1 = sqrt(dd1);
  ddn = 1.0f / dd1;
  n1[0] *= ddn;
  n1[1] *= ddn;
  n1[2] *= ddn;

  /* gap deviation */
  v2 = idir[voy+2];
  if ( pt1->adj[v2] && pt1->tag[v2] == M_NOTAG ) {
    pta = &sm->tria[pt1->adj[v2]];
    di  = fabs(pt1->n[0]*pta->n[0] + pt1->n[1]*pta->n[1] + pt1->n[2]*pta->n[2]);
    da  = fabs(pta->n[0]*n1[0] + pta->n[1]*n1[1] + pta->n[2]*n1[2]);
    if ( da < min(cosang1,di) )  return(0);
  }

  /* compute edge length */
  ux = ppd->c[0] - ppa->c[0];
  uy = ppd->c[1] - ppa->c[1];
  uz = ppd->c[2] - ppa->c[2];
  d4 = ux*ux + uy*uy + uz*uz;
  if ( d4 == 0.0f )  return(0);

  /* compute new face normal */
  n2[0] = vy*uz - vz*uy;
  n2[1] = vz*ux - vx*uz;
  n2[2] = vx*uy - vy*ux;
  dd2 = n2[0]*n2[0] + n2[1]*n2[1] + n2[2]*n2[2];
  if ( dd2 == 0.0f )  return(0);
  dd2 = sqrt(dd2);
  ddn = 1.0f / dd2;
  n2[0] *= ddn;
  n2[1] *= ddn;
  n2[2] *= ddn;

  /* deviation */
  cosang2 = fabs(n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2]);
  if ( cosang2 < cosang1 )  return(0);

  /* gap deviation */
  v1 = idir[voy+1];
  if ( pt1->adj[v1] && pt1->tag[v1] == M_NOTAG ) {
    pta = &sm->tria[pt1->adj[v1]];
    di  = fabs(pt1->n[0]*pta->n[0] + pt1->n[1]*pta->n[1] + pt1->n[2]*pta->n[2]);
    da  = fabs(pta->n[0]*n2[0] + pta->n[1]*n2[1] + pta->n[2]*n2[2]);
    if ( da < min(cosang1,di) )  return(0);
  }

  /* hausdorff */
  hd2 = fabs(n2[0]*wx + n2[1]*wy + n2[2]*wz) / info.delta;

  /* compute face quality */
  ux = ppc->c[0] - ppb->c[0];
  uy = ppc->c[1] - ppb->c[1];
  uz = ppc->c[2] - ppb->c[2];
  d3 = ux*ux + uy*uy + uz*uz;
  *q1 = dd1 / (d1 + d2 + d3);
  if ( *q1 < qtarget )  return(0);
 
  ux = ppd->c[0] - ppc->c[0];
  uy = ppd->c[1] - ppc->c[1];
  uz = ppd->c[2] - ppc->c[2];
  d5 = ux*ux + uy*uy + uz*uz;
  *q2 = dd2 / (d2 + d4 + d5);
  if ( *q2 < qtarget )  return(0);

  hd1 = fabs(n1[0]*ux + n1[1]*uy + n1[2]*uz) / info.delta;
  return(1);
}


#ifdef __cplusplus
}
#endif
