/* 
 *  attempt to swap edge i of face k
 *  Note : clone of flipa1.c
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int flipa2(pSurfMesh sm,int k,int i,
           float *n1,float *n2,float *q1,float *q2,float *hd1,float *hd2,
           double lbande,double angdev) {
  pTriangle   pt,pt1;
  pPoint      ppa,ppb,ppc,ppd;
  double      ga,gb,gc,gd,ang1,wx,wy,wz;
  double      dd,dd1,dd2,d1,d2,d3,d4,d5,ux,uy,uz,vx,vy,vz;
  float      *na,*nb,*nc,*nd,qtarget;
  int         adj,a,b,c,d;
  ubyte       i1,i2,voy;

  /* default */
  pt  = &sm->tria[k];
  adj = pt->adj[i];
  voy = pt->voy[i];

  /* check tag consistency */
  if ( !adj ) {
    prierr(ERR,1012);
    return(0);
  }
  pt1 = &sm->tria[adj];
  if ( pt1->tag[voy] > M_NOTAG ) {
    prierr(ERR,1012);
    return(0);
  }

  /* check if face angle ok to swap if quality ok */
  if ( pt->qual > 0.0001 && pt1->qual > 0.0001 ) {
    ang1 = pt->n[0]*pt1->n[0] + pt->n[1]*pt1->n[1] + pt->n[2]*pt1->n[2];
    if ( ang1 < COS1DEG )  return(0);
  }

  i1 = idir[i+1];
  i2 = idir[i+2];
  a = pt->v[i];
  b = pt->v[i1];
  d = pt->v[i2];
  c = pt1->v[voy];

  /* check alternate edge */
  if ( hexist(a,c) )  return(0);

  ppa = &sm->point[a];
  ppb = &sm->point[b];
  ppc = &sm->point[c];
  ppd = &sm->point[d];

  /* get vertex normal */
  na = sm->geom[pt->vn[i]].vn;
  nb = sm->geom[pt->vn[i1]].vn;
  nd = sm->geom[pt->vn[i2]].vn;
  nc = sm->geom[pt1->vn[voy]].vn;

  /* compute edge lengths */
  ux = wx = ppb->c[0] - ppa->c[0];
  uy = wy = ppb->c[1] - ppa->c[1];
  uz = wz = ppb->c[2] - ppa->c[2];
  d1 = ux*ux + uy*uy + uz*uz;
  if ( d1 == 0.0f )  return(0);

  vx = ppc->c[0] - ppa->c[0];
  vy = ppc->c[1] - ppa->c[1];
  vz = ppc->c[2] - ppa->c[2];
  d2 = vx*vx + vy*vy + vz*vz;
  if ( d2 == 0.0f )  return(0);

  /* compute new face normal */
  n1[0] = uy*vz - uz*vy;
  n1[1] = uz*vx - ux*vz;
  n1[2] = ux*vy - uy*vx;
  dd1   = n1[0]*n1[0] + n1[1]*n1[1] + n1[2]*n1[2];
  if ( dd1 == 0.0f )  return(0);
  dd1 = sqrt(dd1);
  dd  = 1.0f / dd1;
  n1[0] *= dd;
  n1[1] *= dd;
  n1[2] *= dd;

  /* check smoothness */
  ga = min(angdev,sm->geom[pt->vn[i]].gap) - EPS;
  gb = min(angdev,sm->geom[pt->vn[i1]].gap) - EPS;
  gd = min(angdev,sm->geom[pt->vn[i2]].gap) - EPS;
  gc = min(angdev,sm->geom[pt1->vn[voy]].gap) - EPS;

  if ( n1[0]*na[0]+n1[1]*na[1]+n1[2]*na[2] < ga ||
       n1[0]*nb[0]+n1[1]*nb[1]+n1[2]*nb[2] < gb ||
       n1[0]*nc[0]+n1[1]*nc[1]+n1[2]*nc[2] < gc )
    return(0);

  /* compute edge lengths */
  ux = ppd->c[0] - ppa->c[0];
  uy = ppd->c[1] - ppa->c[1];
  uz = ppd->c[2] - ppa->c[2];
  d4 = ux*ux + uy*uy + uz*uz;
  if ( d4 == 0.0f )  return(0);

  /* compute new face normal */
  n2[0] = vy*uz - vz*uy;
  n2[1] = vz*ux - vx*uz;
  n2[2] = vx*uy - vy*ux;
  dd2   = n2[0]*n2[0] + n2[1]*n2[1] + n2[2]*n2[2];
  if ( dd2 == 0.0f )  return(0);
  dd2 = sqrt(dd2);
  dd  = 1.0f / dd2;
  n2[0] *= dd;
  n2[1] *= dd;
  n2[2] *= dd;

  ang1 = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
  if ( ang1 < COS1DEG )  return(0);

  *hd2 = fabs(n2[0]*wx + n2[1]*wy + n2[2]*wz);
  if ( *hd2+pt1->dish > lbande )  return(0);

  /* check smoothness */
  if ( n2[0]*na[0]+n2[1]*na[1]+n2[2]*na[2] < ga ||
       n2[0]*nc[0]+n2[1]*nc[1]+n2[2]*nc[2] < gc ||
       n2[0]*nd[0]+n2[1]*nd[1]+n2[2]*nd[2] < gd )
    return(0);

  /* check quality improvement */
  ux = ppc->c[0] - ppb->c[0];
  uy = ppc->c[1] - ppb->c[1];
  uz = ppc->c[2] - ppb->c[2];
  d3 = ux*ux + uy*uy + uz*uz;
 
  qtarget = 1.01 * min(pt->qual,pt1->qual);
  *q1 = dd1 / (d1+d2+d3);
  if ( *q1 < qtarget )  return(0);

  ux = ppd->c[0] - ppc->c[0];
  uy = ppd->c[1] - ppc->c[1];
  uz = ppd->c[2] - ppc->c[2];
  d5 = ux*ux + uy*uy + uz*uz;
  *hd1 = fabs(n1[0]*ux + n1[1]*uy + n1[2]*uz);
  if ( *hd1+pt->dish > lbande )  return(0);

  *q2 = dd2 / (d2+d4+d5);
  if ( *q2 < qtarget )  return(0);

  return(1);
}


#ifdef __cplusplus
}
#endif
