/* 
 *  attempt to swap edge i of face k
 *  Goal: improve geometric approximation
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2003.  All rights reserved.
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int flipa1(pSurfMesh sm,int k,int i,float *n1,float *n2,float *q1,float *q2) {
  pTriangle   pt,pt1;
  pPoint      ppa,ppb,ppc,ppd;
  pMetric     pma,pmb,pmc,pmd;
  double      ga,gb,gc,gd,cosang,m[6];
  double      tailac,tailbd,deva,devi;
  double      dd1,dd2,dd3,dd,d1,d2,d3,d4,d5,d6,rap,peri,aire;
  double      abx,aby,abz,acx,acy,acz,adx,ady,adz,cbx,cby,cbz,bdx,bdy,bdz;
  double      cdx,cdy,cdz;
  float      *na,*nb,*nc,*nd,qtarget;
  int         l,adj,voy,a,b,c,d;
  ubyte       i1,i2;

  /* default */
  pt  = &sm->tria[k];
  adj = pt->adj[i];
  voy = pt->voy[i];

  /* check tag consistency */
  if ( !adj ) {
    prierr(ERR,1012);
    return(0);
  }
  pt1 = &sm->tria[adj];
  if ( pt1->tag[voy] > M_NOTAG ) {
    prierr(ERR,1012);
    return(0);
  }

  /* compute target value */
  qtarget = 1.01 * min(pt->qual,pt1->qual);
  cosang  = pt->n[0]*pt1->n[0] + pt->n[1]*pt1->n[1] + pt->n[2]*pt1->n[2];
  if ( cosang < COS1DEG )  return(0);

  i1 = idir[i+1];
  i2 = idir[i+2];
  a  = pt->v[i];
  b  = pt->v[i1];
  d  = pt->v[i2];
  c  = pt1->v[voy];

  /* check alternate edge */
  if ( hexist(a,c) ) return(0);

  ppa = &sm->point[a];
  ppb = &sm->point[b];
  ppc = &sm->point[c];
  ppd = &sm->point[d];

  /* get vertex normal */
  na = sm->geom[pt->vn[i]].vn;
  nb = sm->geom[pt->vn[i1]].vn;
  nd = sm->geom[pt->vn[i2]].vn;
  nc = sm->geom[pt1->vn[voy]].vn;

  /* compute edge lengths */
  abx = ppb->c[0] - ppa->c[0];
  aby = ppb->c[1] - ppa->c[1];
  abz = ppb->c[2] - ppa->c[2];
  d1  = abx*abx + aby*aby + abz*abz;
  if ( d1 == 0.0f )  return(0);
  
  acx = ppc->c[0] - ppa->c[0];
  acy = ppc->c[1] - ppa->c[1];
  acz = ppc->c[2] - ppa->c[2];
  d2  = acx*acx + acy*acy + acz*acz;
  if ( d2 == 0.0 )  return(0);
  
  /* compute new face normal */
  n1[0] = aby*acz - abz*acy;
  n1[1] = abz*acx - abx*acz;
  n1[2] = abx*acy - aby*acx;
  dd1   = n1[0]*n1[0] + n1[1]*n1[1] + n1[2]*n1[2];
  if ( dd1 == 0.0  )  return(0);
  dd1 = sqrt(dd1);
  dd  = 1.0f / dd1;
  n1[0] *= dd;
  n1[1] *= dd;
  n1[2] *= dd;

  /* check smoothness */
  ga = min(opts.gap,sm->geom[pt->vn[i]].gap) - EPS;
  gb = min(opts.gap,sm->geom[pt->vn[i1]].gap) - EPS;
  gd = min(opts.gap,sm->geom[pt->vn[i2]].gap) - EPS;
  gc = min(opts.gap,sm->geom[pt1->vn[voy]].gap) - EPS;
  
  if ( n1[0]*na[0] + n1[1]*na[1] + n1[2]*na[2] < ga ||
       n1[0]*nb[0] + n1[1]*nb[1] + n1[2]*nb[2] < gb ||
       n1[0]*nc[0] + n1[1]*nc[1] + n1[2]*nc[2] < gc )
    return(0);

  /* compute edge length */
  adx = ppd->c[0] - ppa->c[0];
  ady = ppd->c[1] - ppa->c[1];
  adz = ppd->c[2] - ppa->c[2];
  d4  = adx*adx + ady*ady + adz*adz;
  if ( d4 == 0.0f )  return(0);
  
  /* compute new face normal */
  n2[0] = acy*adz - acz*ady;
  n2[1] = acz*adx - acx*adz;
  n2[2] = acx*ady - acy*adx;
  dd2   = n2[0]*n2[0] + n2[1]*n2[1] + n2[2]*n2[2];
  if ( dd2 == 0.0f )  return(0);
  dd2 = sqrt(dd2);
  dd  = 1.0f / dd2;
  n2[0] *= dd;
  n2[1] *= dd;
  n2[2] *= dd;
  
  /* check face angle */
  cosang = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
  if ( cosang < COS1DEG )  return(0);

  /* check smoothness */
  if ( n2[0]*na[0] + n2[1]*na[1] + n2[2]*na[2] < ga ||
       n2[0]*nc[0] + n2[1]*nc[1] + n2[2]*nc[2] < gc ||
       n2[0]*nd[0] + n2[1]*nd[1] + n2[2]*nd[2] < gd )
    return(0);

  /* check deviation */
  bdx = ppd->c[0] - ppb->c[0];
  bdy = ppd->c[1] - ppb->c[1];
  bdz = ppd->c[2] - ppb->c[2];
  d6  = bdx*bdx + bdy*bdy + bdz*bdz;
  if ( sm->dim == 3 ) {
    if ( d6 > 0.0 ) {
      deva =           fabs(acx*na[0] + acy*na[1] + acz*na[2]);
      deva = max(deva, fabs(acx*nc[0] + acy*nc[1] + acz*nc[2])) / sqrt(d2);
      devi =           fabs(bdx*nb[0] + bdy*nb[1] + bdz*nb[2]);
      devi = max(devi, fabs(bdx*nd[0] + bdy*nd[1] + bdz*nd[2])) / sqrt(d6);
      if ( deva > devi )  return(0);
    }
  }

  cbx = ppc->c[0] - ppb->c[0];
  cby = ppc->c[1] - ppb->c[1];
  cbz = ppc->c[2] - ppb->c[2];
  d3  = cbx*cbx + cby*cby + cbz*cbz;
  if ( d3 == 0.0 )  return(0);
  
  cdx = ppd->c[0] - ppc->c[0];
  cdy = ppd->c[1] - ppc->c[1];
  cdz = ppd->c[2] - ppc->c[2];
  d5  = cdx*cdx + cdy*cdy + cdz*cdz;
  if ( d5 == 0.0f )  return(0);

  /* edge lengths */
  if ( opts.ctrl & ISO ) {
    rap = (ppc->size - ppa->size) / ppa->size;
    if ( fabs(rap) < EPS )
      tailac = sqrt(d2) * (2.-EPS) / (2.*ppa->size);
    else {
      tailac = 1.0/ppa->size + 1.0/ppc->size + 8.0 / (ppa->size+ppc->size);
      tailac = sqrt(d2) / 6.0 * tailac;
    }  
    if ( tailac > 1.0 )  tailac = 1.0 / tailac;

    rap = (ppd->size - ppb->size) / ppb->size;
    if ( fabs(rap) < EPS )
      tailbd = sqrt(d6) * (2.-EPS) / (2.*ppb->size);
    else {
      tailbd = 1.0/ppb->size + 1.0/ppd->size + 8.0 / (ppb->size+ppd->size);
      tailbd = sqrt(d6) / 6.0 * tailbd;
    }  
    if ( tailbd > 1.0 )  tailbd = 1.0 / tailbd;
   
    if ( tailac < min(tailbd,ISQRT2) )  return(0);

    /* check face quality */
    *q1 = dd1 / (d1 + d2 + d3);
    if ( *q1 < qtarget )  return(0);
    
    *q2 = dd2 / (d2 + d4 + d5);
    if ( *q2 < qtarget ) return(0);
  }
  else {
    pma = &sm->metric[a];
    pmb = &sm->metric[b];
    pmc = &sm->metric[c];
    pmd = &sm->metric[d];

    dd1 =      pmb->m[0]*bdx*bdx + pmb->m[3]*bdy*bdy + pmb->m[5]*bdz*bdz \
        + 2.0*(pmb->m[1]*bdx*bdy + pmb->m[2]*bdx*bdz + pmb->m[4]*bdy*bdz);
    if ( dd1 <= 0.0f )  dd1 = 0.0f;
    dd2 =      pmd->m[0]*bdx*bdx + pmd->m[3]*bdy*bdy + pmd->m[5]*bdz*bdz \
        + 2.0*(pmd->m[1]*bdx*bdy + pmd->m[2]*bdx*bdz + pmd->m[4]*bdy*bdz);
    if ( dd2 <= 0.0f )  dd2 = 0.0f;
    tailbd = (sqrt(dd1)+sqrt(dd2)+4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
    if ( tailbd > 1.0 )  tailbd = 1.0 / tailbd;

    dd1 =      pma->m[0]*acx*acx + pma->m[3]*acy*acy + pma->m[5]*acz*acz \
        + 2.0*(pma->m[1]*acx*acy + pma->m[2]*acx*acz + pma->m[4]*acy*acz);
    if ( dd1 <= 0.0f )  dd1 = 0.0f;
    dd2 =      pmc->m[0]*acx*acx + pmc->m[3]*acy*acy + pmc->m[5]*acz*acz \
        + 2.0*(pmc->m[1]*acx*acy + pmc->m[2]*acx*acz + pmc->m[4]*acy*acz);
    if ( dd2 <= 0.0f )  dd2 = 0.0f;
    tailac = (sqrt(dd1)+sqrt(dd2)+4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
    if ( tailac > 1.0 )  tailac = 1.0 / tailac;

    if ( tailac < min(tailbd,ISQRT2) )  return(0);

    /* quality */
    for (l=0; l<6; l++)
      m[l] = (pma->m[l]+pmb->m[l]+pmc->m[l]) / 3.0;

    dd1 =      m[0]*abx*abx + m[3]*aby*aby + m[5]*abz*abz \
        + 2.0*(m[1]*abx*aby + m[2]*abx*abz + m[4]*aby*abz);
    dd1 = sqrt(dd1);

    dd2 =      m[0]*cbx*cbx + m[3]*cby*cby + m[5]*cbz*cbz \
        + 2.0*(m[1]*cbx*cby + m[2]*cbx*cbz + m[4]*cby*cbz);
    dd2 = sqrt(dd2);

    dd3 =      m[0]*acx*acx + m[3]*acy*acy + m[5]*acz*acz \
        + 2.0*(m[1]*acx*acy + m[2]*acx*acz + m[4]*acy*acz);
    dd3 = sqrt(dd3);
  
    peri = 0.5 * (dd1 + dd2 + dd3);
    if ( peri < EPSD )  return(0);
    aire = (peri-dd1) * (peri-dd2) * (peri-dd3);
    if ( aire <= 0.0 )  return(0);
    *q1 = sqrt(aire * peri) / peri;
    if ( *q1 < qtarget )  return(0);

    for (l=0; l<6; l++)
      m[l] = (pma->m[l]+pmc->m[l]+pmd->m[l]) / 3.0;

    dd1 =      m[0]*acx*acx + m[3]*acy*acy + m[5]*acz*acz \
        + 2.0*(m[1]*acx*acy + m[2]*acx*acz + m[4]*acy*acz);
    dd1 = sqrt(dd1);

    dd2 =      m[0]*cdx*cdx + m[3]*cdy*cdy + m[5]*cdz*cdz \
        + 2.0*(m[1]*cdx*cdy + m[2]*cdx*cdz + m[4]*cdy*cdz);
    dd2 = sqrt(dd2);

    dd3 =      m[0]*adx*adx + m[3]*ady*ady + m[5]*adz*adz \
        + 2.0*(m[1]*adx*ady + m[2]*adx*adz + m[4]*ady*adz);
    dd3 = sqrt(dd3);
  
    peri = 0.5 * (dd1 + dd2 + dd3);
    if ( peri < EPSD )  return(0);
    aire = (peri-dd1) * (peri-dd2) * (peri-dd3);
    if ( aire <= 0.0 )  return(0);
    *q2 = sqrt(aire * peri) / peri;
    if ( *q2 < qtarget )  return(0);
  }

  return(1);
}

