/*
 *  attempt to swap edge i of face k
 *  Goal: delete large angles
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 2001.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define QMIN  0.005


int flipa0(pSurfMesh sm,int k,int i,float *n1,float *n2,float *q1,float *q2) {
  pTriangle   pt,pt1;
  pPoint      ppa,ppb,ppc,ppd;
  double      dd,cosang1,cosang2,ux,uy,uz,vx,vy,vz;
  float       qtarget;
  int         adj,voy;
  int         i1,i2,a,b,c,d;

  /* default */
  pt  = &sm->tria[k];
  adj = pt->adj[i];
  voy = pt->voy[i];

  /* check tag consistency */
  if ( !adj ) {
    prierr(ERR,1012);
    return(0);
  }
  pt1 = &sm->tria[adj];

  if ( pt1->tag[voy] > M_NOTAG ) {
    prierr(ERR,1012);
    return(0);
  }

  i1 = idir[i+1];
  i2 = idir[i+2];
  a = pt->v[i];
  b = pt->v[i1];
  d = pt->v[i2];
  c = pt1->v[voy];

  /* check alternate edge */
  if ( hexist(a,c) ) return(0);

  ppa = &sm->point[a];
  ppb = &sm->point[b];
  ppc = &sm->point[c];
  ppd = &sm->point[d];

  /* check angle */
  cosang1 = -1.0;
  cosang1 = pt->n[0]*pt1->n[0] + pt->n[1]*pt1->n[1] + pt->n[2]*pt1->n[2];
  if ( sm->dim > 2 && pt->qual > QMIN && cosang1 < COS5DEG )  return(0);

  /* check quality */
  qtarget = 1.01 * min(pt->qual,pt1->qual);
  if ( !qualfa(ppa->c,ppb->c,ppc->c,q1,n1) || *q1 < qtarget )  return(0);
  if ( !qualfa(ppa->c,ppc->c,ppd->c,q2,n2) || *q2 < qtarget )  return(0);

  cosang2 = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
  if ( cosang2 < cosang1 )  return(0);

  /* compute lengths */
  ux = ppb->c[0] - ppa->c[0];
  uy = ppb->c[1] - ppa->c[1];
  uz = ppb->c[2] - ppa->c[2];
  dd = ux*ux + uy*uy + uz*uz;
  if ( dd == 0.0 )  return(0);
  dd = 1.0 / sqrt(dd);
  ux *= dd;
  uy *= dd;
  uz *= dd;

  vx = ppd->c[0] - ppa->c[0];
  vy = ppd->c[1] - ppa->c[1];
  vz = ppd->c[2] - ppa->c[2];
  dd = vx*vx + vy*vy + vz*vz;
  if ( dd == 0.0 )  return(0);
  dd = 1.0 / sqrt(dd);
  vx *= dd;
  vy *= dd;
  vz *= dd;

  cosang1 = ux*vx + uy*vy + uz*vz;
  /* if ( cosang1 < -COS1DEG )  return(1);*/

  /* compute lengths */
  ux = ppb->c[0] - ppc->c[0];
  uy = ppb->c[1] - ppc->c[1];
  uz = ppb->c[2] - ppc->c[2];
  dd = ux*ux + uy*uy + uz*uz;
  if ( dd == 0.0 )  return(0);
  dd = 1.0 / sqrt(dd);
  ux *= dd;
  uy *= dd;
  uz *= dd;

  vx = ppd->c[0] - ppc->c[0];
  vy = ppd->c[1] - ppc->c[1];
  vz = ppd->c[2] - ppc->c[2];
  dd = vx*vx + vy*vy + vz*vz;
  if ( dd == 0.0 )  return(0);
  dd = 1.0 / sqrt(dd);
  vx *= dd;
  vy *= dd;
  vz *= dd;

  cosang2 = ux*vx + uy*vy + uz*vz;
  /* if ( cosang2 < -COS1DEG )  return(1);*/
  dd = acos(cosang1) + acos(cosang2);

  return(dd >= M_PI);
}


#ifdef __cplusplus
}
#endif
