/*
 *  error handler: store procname
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 2001.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
/*#include <ctype.h>*/
#include "string.h"

#define MAXLEV   25
#define ERRLEN   29

#define min(a,b)  (a)<(b) ? (a) : (b)


typedef struct _errstack {
  char  call[30];
} Errstack;

typedef Errstack   * pErrstack;

Errstack   E_stack[MAXLEV+1];
static int E_stacknum = 0;


/* store procname */
void E_put(char *errcall) {
  int    i,len;

  if ( E_stacknum < MAXLEV ) {
    ++E_stacknum;
    len = min(strlen(errcall),ERRLEN);
    for (i=0; i<len; i++)
      E_stack[E_stacknum].call[i] = toupper(errcall[i]);
    E_stack[E_stacknum].call[i] = '\0';
  }
}


/* pop procname */
void E_pop(void) {
  if ( E_stacknum > 0 )
    E_stack[E_stacknum--].call[0] = '\0';
}

char *E_name() {
  if ( E_stacknum > 0 )
    return(E_stack[E_stacknum].call);
  else
    return(0);
}

/* dump error stack */
void E_dump() {
  int   k;

  if ( E_stacknum > 1 ) {
    fprintf(stdout,"\n  -- ERROR STACK\n");
    for (k=E_stacknum; k>0; k--)
      fprintf(stdout,"  [%2d] proc: %s\n",k,E_stack[k].call);
  }
}


#ifdef __cplusplus
}
#endif
