/*
 * surface denoising (cf. Fleishman et al.)
*/
#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define EPSD2  1.0e-25
#define N1     0.1
#define N2     0.1


int denois(pSurfMesh sm) {
  pPoint      p0,p1;
  pTriangle   pt,pt1;
  Ball        bb;
  double      h,t,dd,wc,ws,sigmac2,sigmas2,sum,nrm,res,res0;
  double      ux,uy,uz,ox,oy,oz;
  float      *nv,*coo;
  int         it,k,i,l,kk,base;
  ubyte       i1,nk;

  E_put("denois");
  sigmac2 = -0.5 / (N1*N1);
  sigmas2 = -0.5 / (N2*N2);

  for (k=1; k<=sm->np; k++) {
    p0 = &sm->point[k];
    p0->flag = sm->mark;
  }
  if ( !norpoi(sm,0,0) )  return(0);
  coo = (float*)calloc(3*sm->np+1,sizeof(float));
  assert(coo);

  res0 = 0.0;
  for (it=1; it<=opts.iter; it++) {
    ++sm->mark;

    for (k=1; k<=sm->nemax; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] )  continue;

      for (i=0; i<3; i++) {
        p0 = &sm->point[pt->v[i]];
	    if ( p0->flag > sm->mark )  continue;

        nv   = sm->geom[pt->vn[i]].vn;
  	    base = 3*(pt->v[i]-1) + 1; 
	    coo[base+0] = p0->c[0];
	    coo[base+1] = p0->c[1];
	    coo[base+2] = p0->c[2];

        bb.ilist = boulep(sm,k,i,&bb);
	    if ( bb.closed ) {
	      p0->flag = sm->mark + 1;
	      sum = 0.0;
	      nrm = 0.0;
	      for (l=1; l<=bb.ilist; l++) {
	        kk = bb.list[l];
	        nk = bb.nump[l];
	        i1 = idir[nk+1];
	        pt1 = &sm->tria[kk];
	        p1  = &sm->point[pt1->v[i1]];

	        ux = p0->c[0] - p1->c[0];
	        uy = p0->c[1] - p1->c[1];
	        uz = p0->c[2] - p1->c[2];

	        t  = ux*ux + uy*uy + uz*uz;
	        h  = nv[0]*ux + nv[1]*uy + nv[2]*uz;
	        /*if ( h < 0.01 )  continue;*/
	        wc = exp(t * sigmac2);
	        ws = exp(h*h * sigmas2);
            dd = wc * ws;
	        sum += dd * h;
	        nrm += dd;
	      }
	      if ( nrm < EPSD2 )  continue;
	      dd = sum / nrm;
	      coo[base+0] -= nv[0] * dd;
	      coo[base+1] -= nv[1] * dd;
	      coo[base+2] -= nv[2] * dd;
	    }
	    else {
    	}
      }
    }

    /* update coors */
    res = 0.0;
    for (k=1; k<=sm->np; k++) {
      p0   = &sm->point[k];
      base = 3*(k-1) + 1;

      ox = p0->c[0] - coo[base+0];
      oy = p0->c[1] - coo[base+1];
      oz = p0->c[2] - coo[base+2];
      dd   = ox*ox + oy*oy + oz*oz;
      res += dd;

      p0->c[0] = coo[base+0];
      p0->c[1] = coo[base+1];
      p0->c[2] = coo[base+2];
    }
  
    if ( it == 1 )      res0 = res;
    if ( res0 > EPS )   res  = res / res0;
    if ( abs(imprim) > 4 ) {
      fprintf(stdout,"    iter %8d  res %.2E\r",it,res); 
      fflush(stdout);
    }
  }
  fprintf(stdout,"\n");

  sm->dim = 2;
  //outmsh(sm,"titi");
  sm->dim = 3;

  free(coo);
  E_pop();
  return(1);
}
