/* 
 *  attempt to collapse a mesh vertex (i->j)
 *  (Hausdorff distance)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2001.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int delpo2(pSurfMesh sm,int k,int i,double lbande,double angdev,Ball *bb,Global *gl) {
  pTriangle   pt,pt1,pta;
  pPoint      pi,pj,ppt,p1,p2,p3;
  double      delta,d1,d2,d3,ux,uy,uz,vx,vy,vz,ang1,ang2,hmax2;
  double      dd,dd1,px,py,pz,ax,ay,az,bx,by,bz,cx,cy,cz;
  double      gj,ga,gb,cb1,cb2,cb3,wcb,som,old2new,new2old;
  double      gai,gaj,gij;
  float      *ni,*nj,*na,*nb,qtarget;
  int         ii,is1,is2,l,k3,kk,kk1,nk,nbneg,inum,jnum,adj;
  ubyte       i1,i2,voy;

  /* default */
  if ( opts.hmax > 0.0f )
    hmax2 = opts.hmax * opts.hmax;
  else
    hmax2 = info.delta*info.delta;

  pt   = &sm->tria[k];
  i1   =  idir[i+1];
  i2   =  idir[i+2];
  inum =  pt->v[i];
  jnum =  pt->v[i2];

  /* get ball */
  bb->ilist = boulep(sm,k,i,bb);
  if ( bb->ilist < 0 )  return(0);
  else if ( !bb->closed || bb->ilist < 3 ) {
    yerr.inderr[0] = pt->v[i];
    prierr(ERR,4012);
    sm->point[pt->v[i]].tag |= M_CORNER;
    return(0);
  }

  /* k=3: check if face exists */
  if ( bb->ilist == 3 ) {
    kk  = bb->list[2];
    nk  = bb->nump[2];
    pt1 = &sm->tria[kk];
    k3  = pt1->v[idir[nk+2]];
    for (l=1; l<4; l++) {
      kk  = bb->list[l];
      nk  = bb->nump[l];
      pt1 = &sm->tria[kk];
      adj = pt1->adj[nk];
      if ( !adj )  continue;
      voy = pt1->voy[nk];
      do {
	pta = &sm->tria[adj];
        if ( pta->v[voy] == k3 )  return(0);
	adj = pta->adj[voy];
	voy = pta->voy[voy];
      }
      while ( adj != kk );
    }
  }

  pi  = &sm->point[inum];
  pj  = &sm->point[jnum];
  is1 = pt->vn[i1];
  is2 = pt->vn[i2];
  gj  = min(angdev,sm->geom[is2].gap) - EPS;
  ni  = sm->geom[is1].vn;
  nj  = sm->geom[is2].vn;
  gij = min(opts.walton,ni[0]*nj[0] + ni[1]*nj[1] + ni[2]*nj[2]);

  /* topological checks */
  if ( pt->tag[i1] & M_REQUIRED || pi->tag > pj->tag )
    return(0);
  else if ( pi->tag & M_CORNER || pi->tag & M_REQUIRED )
    return(0);
  else if ( pt->tag[i1] == M_NOTAG && pi->tag > M_NOTAG )
    return(0);
  /*check curve smoothness */
  if ( pt->tag[i1] & M_RIDGE_REF && !delar1(sm,k,i,i2) )
    return(0);

  ux = pj->c[0] - pi->c[0];
  uy = pj->c[1] - pi->c[1];
  uz = pj->c[2] - pi->c[2];
  d1 = ux*ux + uy*uy + uz*uz;
  if ( d1 > hmax2 )  return(0);

  /* compute target qual */
  qtarget  = pt->qual;
  gl->h[1] = 0.0f;
  for (l=2; l<=bb->ilist; l++) {
    kk = bb->list[l];
    nk = bb->nump[l];
    i1 = idir[nk+1];
    pt = &sm->tria[kk];
    if ( l > 3 && hexist(jnum,pt->v[i1]) )  return(0);
    if ( pt->qual < qtarget )  qtarget = pt->qual;
    gl->h[l] = 0.0f;
  }
  qtarget *= opts.degrad;

  /* check deviation */
  for (l=3; l<=bb->ilist; l++) {
    kk = bb->list[l];
    nk = bb->nump[l];
    i1 = idir[nk+1];
    i2 = idir[nk+2];
    pt = &sm->tria[kk];
    p1 = &sm->point[pt->v[i1]];
    p2 = &sm->point[pt->v[i2]];

    ux = p1->c[0] - pj->c[0];
    uy = p1->c[1] - pj->c[1];
    uz = p1->c[2] - pj->c[2];
    d1 = ux*ux + uy*uy + uz*uz;
    if ( d1 == 0.0f || d1 > hmax2 )  return(0);

    vx = p2->c[0] - pj->c[0];
    vy = p2->c[1] - pj->c[1];
    vz = p2->c[2] - pj->c[2];
    d2 = vx*vx + vy*vy + vz*vz;
    if ( d2 == 0.0f || d2 > hmax2 )  return(0);

    gl->n[l][0] = uy*vz - uz*vy;
    gl->n[l][1] = uz*vx - ux*vz;
    gl->n[l][2] = ux*vy - uy*vx;
    dd1 = gl->n[l][0]*gl->n[l][0] + gl->n[l][1]*gl->n[l][1] 
        + gl->n[l][2]*gl->n[l][2];
    if ( dd1 == 0.0f )  return(0);
    dd1 = sqrt(dd1);
    dd  = 1.0f / dd1;
    gl->n[l][0] *= dd;
    gl->n[l][1] *= dd;
    gl->n[l][2] *= dd;

    is1 = pt->vn[i1];
    is2 = pt->vn[i2];
    na = &sm->geom[is1].vn[0];
    nb = &sm->geom[is2].vn[0];
    ga = min(angdev,sm->geom[is1].gap) - EPS;
    gb = min(angdev,sm->geom[is2].gap) - EPS;
    if ( bb->ilist > 3 ) {
      if ( (nj[0]*gl->n[l][0] + nj[1]*gl->n[l][1] + nj[2]*gl->n[l][2] < gj) ||
           (na[0]*gl->n[l][0] + na[1]*gl->n[l][1] + na[2]*gl->n[l][2] < ga) ||
           (nb[0]*gl->n[l][0] + nb[1]*gl->n[l][1] + nb[2]*gl->n[l][2] < gb) )
        return(0);
    }

    /* check vertex normal deviation (Walton) */
    gai = min(opts.walton,ni[0]*na[0] + ni[1]*na[1] + ni[2]*na[2]);
    gaj = nj[0]*na[0] + nj[1]*na[1] + nj[2]*na[2];
    if ( gaj < gai || gaj < gij )  return(0);

    vx = p2->c[0] - p1->c[0];
    vy = p2->c[1] - p1->c[1];
    vz = p2->c[2] - p1->c[2];
    d3 = vx*vx + vy*vy + vz*vz;
    if ( d3 == 0.0f )  return(0);
    gl->q[l] = dd1 / (d1+d2+d3);
    if ( gl->q[l] < qtarget )  return(0);
  }

  /* check Hausdorff */
  new2old = old2new = 0.0;
  for (l=3; l<=bb->ilist; l++) {
    kk = bb->list[l];
    nk = bb->nump[l];
    i1 = idir[nk+1];
    i2 = idir[nk+2];
    pt = &sm->tria[kk];
    p1 = &sm->point[pt->v[i1]];
    p2 = &sm->point[pt->v[i2]];

    /* projection of pj */
    ux = pj->c[0] - p1->c[0];
    uy = pj->c[1] - p1->c[1];
    uz = pj->c[2] - p1->c[2];
    dd = ux*pt->n[0] + uy*pt->n[1] + uz*pt->n[2];
    
    px = pj->c[0] - dd*pt->n[0];
    py = pj->c[1] - dd*pt->n[1];
    pz = pj->c[2] - dd*pt->n[2];

    /* barycentric coords */
    ax = pi->c[0] - px;
    ay = pi->c[1] - py;
    az = pi->c[2] - pz;
    bx = p1->c[0] - px;
    by = p1->c[1] - py;
    bz = p1->c[2] - pz;
    cx = p2->c[0] - px;
    cy = p2->c[1] - py;
    cz = p2->c[2] - pz;
    
    cb1 = pt->n[0] * (by*cz - bz*cy) + pt->n[1] * (bz*cx - bx*cz) 
        + pt->n[2] * (bx*cy - by*cx);
    cb2 = pt->n[0] * (cy*az - cz*ay) + pt->n[1] * (cz*ax - cx*az) 
        + pt->n[2] * (cx*ay - cy*ax);
    cb3 = pt->n[0] * (ay*bz - az*by) + pt->n[1] * (az*bx - ax*bz) 
        + pt->n[2] * (ax*by - ay*bx);

    som = cb1 + cb2 + cb3;
    if ( som == 0.0f )  return(0);
    som = 1.0f / som;
    cb1 *= som;
    cb2 *= som;
    cb3 *= som;

    /* distance to surface */
    delta = dd;
    nbneg = 0;
    ppt = 0;
    pta = 0;
    wcb = 1.0f;
    if ( cb1 < 0.0f ) {
      wcb   = 1.0 / (1.0-cb1);
      delta = dd * wcb;
      nbneg++;
    }
    if ( cb2 < 0.0f ) {
      wcb   = 1.0 / (1.0-cb2);
      delta = dd * wcb;
      nbneg++;
      if ( l < bb->ilist ) {
	ppt = p1;
	pta = &sm->tria[pt->adj[i1]];
	kk1 = l+1;
      }
    }
    if ( cb3 < 0.0 ) {
      wcb   = 1.0 / (1.0-cb3);
      delta = dd * wcb;
      nbneg++;
      if ( l > 3 ) {
	ppt = p2;
	pta = &sm->tria[pt->adj[i2]];
	kk1 = l-1;
      }
    }

    /* check Hausdorff distance */
    gl->h[l] = fabs(delta);
    if ( pt->dish+gl->h[l] > lbande )  return(0);

    /* check distance pi to new face */
    if ( nbneg == 2 )
      old2new = fabs(gl->n[l][0]*(pi->c[0]-p1->c[0]) 
              + gl->n[l][1]*(pi->c[1]-p1->c[1])
              + gl->n[l][2]*(pi->c[2]-p1->c[2]));
    else if ( nbneg == 1 ) {
      if ( pta && ppt ) {
	ax = (ppt->c[0]-pi->c[0]) - wcb*(pj->c[0]-ppt->c[0]);
	ay = (ppt->c[1]-pi->c[1]) - wcb*(pj->c[1]-ppt->c[1]);
	az = (ppt->c[2]-pi->c[2]) - wcb*(pj->c[2]-ppt->c[2]);
	dd  = pta->n[0]*ax + pta->n[1]*ay + pta->n[2]*az;
	gl->h[kk1] = max(gl->h[kk1], fabs(dd));
      }
    }
    else
      new2old = fabs(delta);

    /* check curvature sign */
    for (ii=0; ii<3; ii++) {
      if ( pt->tag[ii] & M_RIDGE_GEO )  continue;
      if ( pt->adj[ii] ) {
	pta = &sm->tria[pt->adj[ii]];
	p3 = &sm->point[pta->v[pt->voy[ii]]];
	vx = p3->c[0] - pi->c[0];
	vy = p3->c[1] - pi->c[1];
	vz = p3->c[2] - pi->c[2];
	dd = vx*vx + vy*vy + vz*vz;
	if ( dd == 0.0 ) continue;
	dd  = 1.0 / sqrt(dd);
        vx *= dd;
        vy *= dd;
        vz *= dd;
	ang1 = vx*pt->n[0] + vy*pt->n[1] + vz*pt->n[2];
	vx = p3->c[0] - pj->c[0];
	vy = p3->c[1] - pj->c[1];
	vz = p3->c[2] - pj->c[2];
	dd = vx*vx + vy*vy + vz*vz;
	if ( dd == 0.0f ) continue;
        dd = 1.0 / sqrt(dd);
	vx *= dd;
        vy *= dd;
        vz *= dd;
	ang2 = vx*gl->n[l][0]+ vy*gl->n[l][1]+ vz*gl->n[l][2];
	if ( ang1*ang2 < 0.0f && fabs(ang1-ang2) > SIN2DEG ) return(0);
      }
    }
  }

  /* last Hausdorff = max(min(d(a,b)) */
  delta = min(old2new,new2old);
  for (l=3; l<=bb->ilist; l++) {
    kk = bb->list[l];
    pt = &sm->tria[kk];
    if ( delta > gl->h[l] )  
      gl->h[l] = delta;
    if ( pt->dish+gl->h[l] > lbande )  return(0);
  }

  return(1);
}


#ifdef __cplusplus
}
#endif
