/* 
 *  attempt to collapse a mesh vertex 
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define LADMI  1.4143


int delpo1(pSurfMesh sm,int k,int i,double tail,Ball *bb,Global *gl) {
  pTriangle   pt,pt1,pta;
  pPoint      ppti,pptj,p1,p2;
  pMetric     pmj,pm1,pm2;
  double      d,d1,d2,d3,ux,uy,uz,vx,vy,vz;
  double      dd,dd1,dd2,dhd,hmax2,tail1,deva;
  double      gg,gj,ga,gb,gai,gaj,gij;
  float      *ni,*nj,*na,*nb,nn[3],qtarget;
  int         l,a,b,is1,is2,k3,inum,jnum,numk,nk,kk,adj,voy;
  ubyte       i1,i2;

  /* default */
  pt   = &sm->tria[k];
  i1   =  idir[i+1];
  i2   =  idir[i+2];
  inum =  pt->v[i];
  jnum =  pt->v[i2];

  /* get ball */
  bb->ilist = boulep(sm,k,i,bb);
  if ( bb->ilist <= 0 )  return(0);
  else if ( !bb->closed || bb->ilist < 3 ) {
    yerr.inderr[0] = pt->v[i];
    prierr(ERR,4012);
    return(0);
  }
  if ( opts.hmax > 0.0 )  
    hmax2 = opts.hmax*opts.hmax;
  else
    hmax2 = info.delta*info.delta;

  /* k=3: check if face exists */
  if ( bb->ilist == 3 ) {
    kk  = bb->list[2];
    nk  = bb->nump[2];
    pt1 = &sm->tria[kk];
    k3  = pt1->v[idir[nk+2]];
    for (l=1; l<4; l++) {
      kk  = bb->list[l];
      nk  = bb->nump[l];
      pt1 = &sm->tria[kk];
      adj = pt1->adj[nk];
      if ( !adj )  continue;
      voy = pt1->voy[nk];
      do {
	    pta = &sm->tria[adj];
        if ( pta->v[voy] == k3 )  return(0);
	    adj = pta->adj[voy];
	    voy = pta->voy[voy];
      }
      while ( adj != kk );
    }
  }

  ppti = &sm->point[inum];
  pptj = &sm->point[jnum];
  pmj  = 0;

  /* topological checks */
  if ( pt->tag[i1] & M_REQUIRED || ppti->tag > pptj->tag )
    return(0);
  else if ( ppti->tag & M_CORNER || ppti->tag & M_REQUIRED )
    return(0);
  else if ( pt->tag[i1] == M_NOTAG && ppti->tag > M_NOTAG )
    return(0);
  /* check curve smoothness */
  else if ( (pt->tag[i1] & M_RIDGE_REF) && !delar1(sm,k,i,i2) )
    return(0);

  /* get quality target */
  qtarget = pt->qual;
  for (l=2; l<=bb->ilist; l++) {
    pt = &sm->tria[bb->list[l]];
    qtarget = min(pt->qual,qtarget);
  }
  qtarget *= opts.degrad;
  /*costh = 2.0*opts.eps*(2.0-opts.eps);*/

  /* analyze ball of vertex */
  pt  = &sm->tria[k];
  is1 = pt->vn[i1];
  is2 = pt->vn[i2];
  ni  = sm->geom[is1].vn;
  nj  = sm->geom[is2].vn;
  gj  = min(sm->geom[is2].gap,opts.gap) - EPS;
  gij = min(opts.walton,ni[0]*nj[0] + ni[1]*nj[1] + ni[2]*nj[2]);

  if ( !(opts.ctrl & ISO) )  pmj = &sm->metric[jnum];

  for (l=3; l<=bb->ilist; l++) {
    kk = bb->list[l];
    pt = &sm->tria[kk];

    /* get vertices */
    numk = bb->nump[l];
    i1 = idir[numk+1];
    i2 = idir[numk+2];

    a  = pt->v[i1];
    b  = pt->v[i2];
    is1 = pt->vn[i1];
    is2 = pt->vn[i2];

    p1 = &sm->point[a];
    p2 = &sm->point[b];

    na = sm->geom[is1].vn;
    nb = sm->geom[is2].vn;
    ga = min(sm->geom[is1].gap,opts.gap) - EPS;
    gb = min(sm->geom[is2].gap,opts.gap) - EPS;

    /* check new edge */
    if ( l > 3 && hexist(jnum,a) )  return(0);

    /* compute edge lengths */
    ux = p1->c[0] - pptj->c[0];
    uy = p1->c[1] - pptj->c[1];
    uz = p1->c[2] - pptj->c[2];
    d1 = ux*ux + uy*uy + uz*uz;
    if ( d1 == 0.0f || d1 > hmax2 )  return(0);

    vx = p2->c[0] - pptj->c[0];
    vy = p2->c[1] - pptj->c[1];
    vz = p2->c[2] - pptj->c[2];
    d2 = vx*vx + vy*vy + vz*vz;
    if ( d2 > hmax2 )  return(0);

    /* compute face normal */
    gl->n[l][0] = uy*vz - uz*vy;
    gl->n[l][1] = uz*vx - ux*vz;
    gl->n[l][2] = ux*vy - uy*vx;
    dd = gl->n[l][0]*gl->n[l][0] + gl->n[l][1]*gl->n[l][1] \
       + gl->n[l][2]*gl->n[l][2];
    if ( dd == 0.0 )  return(0);
    dd  = sqrt(dd);
    dd1 = 1.0f / dd;
    gl->n[l][0] *= dd1;
    gl->n[l][1] *= dd1;
    gl->n[l][2] *= dd1;
    gl->h[l]     = 0.0;

    /* check normal flipping */
    gg = pt->n[0]*gl->n[l][0]+pt->n[1]*gl->n[l][1]+pt->n[2]*gl->n[l][2];
    if ( gg < COS45DEG )  return(0);

    /* check normal planarity */
    if ( sm->dim == 3 ) {
      if ( bb->ilist > 3 ) {
        if ( gl->n[l][0]*nj[0] + gl->n[l][1]*nj[1] + gl->n[l][2]*nj[2] < gj ||
             gl->n[l][0]*na[0] + gl->n[l][1]*na[1] + gl->n[l][2]*na[2] < ga ||
             gl->n[l][0]*nb[0] + gl->n[l][1]*nb[1] + gl->n[l][2]*nb[2] < gb )
          return(0);
      }
      /* check vertex normal deviation (Walton) */
      gai = min(opts.walton,ni[0]*na[0] + ni[1]*na[1] + ni[2]*na[2]);
      gaj = nj[0]*na[0] + nj[1]*na[1] + nj[2]*na[2];
      if ( gaj < gai || gaj < gij )  return(0);
    }

    /* check edge lengths */
    if ( l > 3 ) {
      if ( opts.ctrl & ISO ) {
        tail1 = sqrt(d1);
        tail1 = max(tail1/p1->size,tail1/pptj->size);
      }
      else {
        pm1 = &sm->metric[a];
        dd1 = pm1->m[0]*ux*ux + pm1->m[3]*uy*uy + pm1->m[5]*uz*uz \
            + 2.0*(pm1->m[1]*ux*uy + pm1->m[2]*ux*uz + pm1->m[4]*uy*uz);
        if ( dd1 <= 0.0 )  dd1 = 0.0;
        dd2 = pmj->m[0]*ux*ux + pmj->m[3]*uy*uy + pmj->m[5]*uz*uz \
            + 2.0*(pmj->m[1]*ux*uy + pmj->m[2]*ux*uz + pmj->m[4]*uy*uz);
        if ( dd2 <= 0.0 )  dd2 = 0.0;
        tail1 = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
      }
      if ( tail1 < 1.01*tail || tail1 > LADMI )  return(0);
	  //if ( tail > LADMI )  return(0);
    }

    /* check tangent plane deviation */
    if ( sm->dim == 3 ) {
	  if ( d1 <= 0.0 )  return(0);
	  d  = 1.0 / sqrt(d1);
	  ux *= d;
	  uy *= d;
	  uz *= d;
      deva = fabs(ux*nj[0] + uy*nj[1] + uz*nj[2]);
      deva = 1.0 - max(fabs(ux*na[0] + uy*na[1] + uz*na[2]), deva);
      if ( deva < opts.alpha )  return(0);
    }

    /* check quality degradation */
    if ( opts.ctrl & ISO ) {
      ux = p2->c[0] - p1->c[0];
      uy = p2->c[1] - p1->c[1];
      uz = p2->c[2] - p1->c[2];
      d3 = ux*ux + uy*uy + uz*uz;
      if ( d3 == 0.0 )  return(0);
      gl->q[l] = (float)(dd / (d1 + d2 + d3));
    }
    else {
      pm1 = &sm->metric[a];       
      pm2 = &sm->metric[b];
      if ( !qualfa_a(p1->c,p2->c,pptj->c,pm1,pm2,pmj,&gl->q[l],nn) )
        return(0);
    }
    if ( gl->q[l] < qtarget )  return(0);

    /* check angle with neighbor */
    if ( sm->dim == 3 ) {     
      adj = pt->adj[numk];
      if ( adj && !(pt->tag[numk] & M_RIDGE_GEO) ) {
        pta = &sm->tria[adj];
        dhd = pta->n[0]*gl->n[l][0] + pta->n[1]*gl->n[l][1] + pta->n[2]*gl->n[l][2];
        if ( dhd < opts.ridge )  return(0);
      }
    }
  }

  if ( sm->dim == 2 )  return(1);

  /* check angle with 2 neighbors */
  kk   = bb->list[1];
  numk = bb->nump[1];
  pt  = &sm->tria[kk];
  adj = pt->adj[numk];
  if ( adj && !(pt->tag[numk] & M_RIDGE_GEO) ) {
    pta = &sm->tria[adj];
    dhd = pta->n[0]*gl->n[bb->ilist][0] + pta->n[1]*gl->n[bb->ilist][1] \
        + pta->n[2]*gl->n[bb->ilist][2];
    if ( dhd < opts.ridge ) return(0);
  }

  kk   = bb->list[2];
  numk = bb->nump[2];
  pt  = &sm->tria[kk];
  adj = pt->adj[numk];
  if ( adj && !(pt->tag[numk] & M_RIDGE_GEO) ) {
    pta = &sm->tria[adj];
    dhd = pta->n[0]*gl->n[3][0] + pta->n[1]*gl->n[3][1] \
        + pta->n[2]*gl->n[3][2];
    if ( dhd < opts.ridge )
      return(0);
  }

  return(1);
}  

