#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define EPS8   1.0e-08

extern int *heap;


/* collapse edge i of k */
int delpo0(pSurfMesh sm,int k,int i) {
  pTriangle   pt,pt1,pta;
  pPoint      p0,p1,p2,p3,pp0,pp1;
  Ball        bb,bb1;
  double      gg;
  float       qtarget,qq,q1[LONMAX+1],nn[3];
  int         l,kk,nk,k1,k2,k3,adj;
  ubyte       i1,i2,ii1,ii2,voy,pre;

  /* default */
  pt = &sm->tria[k];
  i1 = idir[i+1];
  i2 = idir[i+2];
  k1 = pt->v[i1];
  k2 = pt->v[i2];
  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[k1];
  p2 = &sm->point[k2];

  if ( p2->tag & M_CORNER || p2->tag & M_REQUIRED || p2->tag > p1->tag || 
      (pt->tag[i2] == M_NOTAG & p1->tag > M_NOTAG) )
    return(0);
  else if ( pt->tag[i] & M_RIDGE_REF && !delar1(sm,k,i2,i1) )  return(0);

  /* internal vertex */
  bb.ilist = boulep(sm,k,i2,&bb);
  if ( bb.ilist < 2 || !bb.closed )  return(0);
  else if ( bb.ilist < 3 ) {
    yerr.inderr[0] = k2;
    prierr(WAR,4012);
    exit(1);
  }

  /* get quality target */
  qtarget = pt->qual;
  for (l=2; l<=bb.ilist; l++) {
    pt1 = &sm->tria[bb.list[l]];
    if ( pt1->qual < qtarget )
      qtarget = pt1->qual;
  }
  qtarget *= opts.degrad;
  if ( qtarget < info.qworst )  qtarget = info.qworst;

  /* check existing face */
  if ( bb.ilist == 3 ) {
    for (l=1; l<4; l++) {
      kk  = bb.list[l];
      nk  = bb.nump[l];
      i1  = idir[nk+1];
      i2  = idir[nk+2];
      pt1 = &sm->tria[kk];
      pta = &sm->tria[pt1->adj[i1]];
      k3  = pta->v[pt1->voy[i1]];
      adj = pt1->adj[nk];
      voy = pt1->voy[nk];
      while ( adj && adj != kk ) {
        pta = &sm->tria[adj];
        if ( pta->v[voy] == k3 )  return(0);
        adj = pta->adj[voy];
        voy = pta->voy[voy];
      }
    }
    p3 = &sm->point[k3];
    if ( !qualfa(p0->c,p1->c,p3->c,&qq,nn) )  return(0);
    else if ( qq < qtarget )  return(0);

    for (l=1; l<4; l++) {
      kk  = bb.list[l];
      nk  = bb.nump[l];
      pt1 = &sm->tria[kk];
      adj = pt1->adj[nk];
      voy = pt1->voy[nk];
      pta = &sm->tria[adj];
      if ( pt1->tag[nk] & M_NOMANIFOLD )
        do {
          pta = &sm->tria[adj];
          if ( pta->adj[voy] == kk ) {
            pta->adj[voy] = pt1->adj[nk];
            pta->voy[voy] = pt1->voy[nk];
            break;
          }
          adj = pta->adj[voy];
          voy = pta->voy[voy];
        }
        while ( adj != kk );
      else {
        pta->tag[voy] |= M_RIDGE_GEO;
        pta->adj[voy] = pta->voy[voy] = 0;
      }
      pt1->v[0] = 0;
    }
    p2->tag = M_UNUSED;
    pt->flag1 = sm->mark;
    return(1);
  }

  /* check topo */
  p3  = &sm->point[pt->v[i]];
  if ( p3->tag == M_NOTAG ) {
    bb1.ilist = boulep(sm,k,i,&bb1);
    if ( bb1.ilist == 3 )  return(0);
  }
  adj = pt->adj[i];
  if ( adj ) {
    pta = &sm->tria[adj];
    p3  = &sm->point[pta->v[pt->voy[i]]];
    if ( p3->tag == M_NOTAG ) {
      bb1.ilist = boulep(sm,k,i,&bb1);
      if ( bb1.ilist == 3 )  return(0);
    }
  }

  for (l=3; l<=bb.ilist; l++) {
    kk  = bb.list[l];
    nk  = bb.nump[l];
    pt1 = &sm->tria[kk];
    ii1 = idir[nk+1];
    ii2 = idir[nk+2];
    if ( l > 3 && hexist(k1,pt1->v[ii1]) )  return(0);
    pp0 = &sm->point[pt1->v[ii1]];
    pp1 = &sm->point[pt1->v[ii2]];
    if ( !qualfa(pp0->c,pp1->c,p1->c,&q1[l],nn) )  return(0);
    else if ( q1[l] < qtarget )  return(0);
    
    /* check normal flipping (28.08.03) */
    gg = pt1->n[0]*nn[0] + pt1->n[1]*nn[1] + pt1->n[2]*nn[2];
    if ( gg < COS45DEG )  return(0);

    /* check angle with neighbor */
    adj = pt1->adj[nk];
    if ( adj && !(pt1->tag[nk] & M_RIDGE_GEO) ) {
      pta = &sm->tria[adj];
      gg  = pta->n[0]*nn[0] + pta->n[1]*nn[1] + pta->n[2]*nn[2];
      if ( gg < COS45DEG )  return(0);
    }
  }

  /* update structure */
  pt1 = 0;
  kk  = k;
  ii1 = i1;
  k3  = 0;

  for (l=3; l<=bb.ilist; l++) {
    kk  = bb.list[l];
    nk  = bb.nump[l];
    pt1 = &sm->tria[kk];
    ii1 = idir[nk+1];
    ii2 = idir[nk+2];
    k3  = pt1->v[ii2];
    if ( !hpop(k2,pt1->v[ii1]) ) {
      prierr(ERR,1015);
      exit(1);
    }
    pt1->v[nk] = k1;
    pt1->qual  = q1[l];
    pt1->flag1 = sm->mark;

    if ( heap )  hiprep(sm->tria,kk);

    if ( l > 3 && !hpush(k1,pt1->v[ii1]) ) {
      prierr(ERR,1015);
      exit(1);
    }
  }
  /* remove edge */
  if ( k3 && !hpop(k2,k3) ) {
    prierr(ERR,1015);
    exit(1);
  }
  if ( !hpop(k1,k2) ) {
    prierr(ERR,1015);
    exit(1);
  }
  /* remove vertex */
  pt->v[0] = 0;
  p2->tag  = M_UNUSED;

  /* update adjacent */
  kk  = bb.list[1];
  nk  = bb.nump[1];
  pt  = &sm->tria[kk];
  adj = pt->adj[nk];
  pre = idir[bb.nump[bb.ilist]+1];
  pt1 = &sm->tria[bb.list[bb.ilist]];

  pt1->adj[pre]  = adj;
  pt1->voy[pre]  = pt->voy[nk];
  pt1->tag[pre] |= pt->tag[nk];
  pt1->edg[pre]  = max(pt->edg[nk],pt1->edg[pre]);
  pt1->flag1 = sm->mark;

  if ( adj ) {
    pta = &sm->tria[adj];
    voy = pt->voy[nk];
    if ( pta->adj[voy] != kk ) {
      do {
        adj = pta->adj[voy];
        voy = pta->voy[voy];
        pta = &sm->tria[adj];
      }
      while ( pta->adj[voy] != kk );
    }
    pta->adj[voy]  = bb.list[bb.ilist];
    pta->voy[voy]  = pre;
    pta->tag[voy] |= pt1->tag[pre];
    pta->edg[voy]  = max(pta->edg[voy],pt1->edg[pre]);
    pta->flag1 = sm->mark;
  }

  kk  = bb.list[2];
  nk  = bb.nump[2];
  pt  = &sm->tria[kk];
  pt->v[0] = 0;
  adj = pt->adj[nk];
  pre = idir[bb.nump[3]+2];
  pt1 = &sm->tria[bb.list[3]]; 

  pt1->adj[pre]  = adj;
  pt1->voy[pre]  = pt->voy[nk];
  pt1->tag[pre] |= pt->tag[nk];
  pt1->edg[pre]  = max(pt->edg[nk],pt1->edg[pre]);

  if ( adj ) {
    pta = &sm->tria[adj];
    voy = pt->voy[nk];
    if ( pta->adj[voy] != kk ) {
      do {
        adj = pta->adj[voy];
        voy = pta->voy[voy];
        pta = &sm->tria[adj];
      }
      while ( pta->adj[voy] != kk );
    }
    pta->adj[voy]  = bb.list[3];
    pta->voy[voy]  = pre;
    pta->tag[voy] |= pt1->tag[pre];
    pta->edg[voy]  = max(pta->edg[voy],pt1->edg[pre]);
    pta->flag1 = sm->mark;
  }

  return(1);
}
