/* 
 *  attempt to collapse a mesh ridge (i -> j)
 *  (Hausdorff distance)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int deled2(pSurfMesh sm,int k,int i,int j,double lbande,double angdev,Global *gl) {
  pTriangle   pt,pta;
  pPoint      ppti,pptj,ppt,p1,p2;
  Ball        bb;
  double      delta,d1,d2,d3,ux,uy,uz,vx,vy,vz,wx,wy,wz;
  double      dd,dd1,px,py,pz,ax,ay,az,bx,by,bz,cx,cy,cz;
  double      gj,ga,gb,ang1,ang2,old2new,new2old;
  double      cb1,cb2,cb3,wcb,som,sign,epsok,hmax2;
  float      *nj,*na,*nb,qtarget;
  int         nbl,nbldeb,flag;
  int         is1,is2,a,b,l,kk,nk,inum,jnum,numk,adj,nbneg;
  ubyte       i1,i2,voy;

  /* default */
  epsok = 1. -2.*opts.eps;
  if ( opts.hmax > 0.0 )
    hmax2 = opts.hmax*opts.hmax;
  else
    hmax2 = info.delta*info.delta;

  pt   = &sm->tria[k];
  inum =  pt->v[i];
  jnum =  pt->v[j];
  ppti = &sm->point[inum];
  pptj = &sm->point[jnum];

  /* check if collapse possible */
  if ( ppti->tag == M_UNUSED )
    return(0);
  else if ( ppti->tag & M_REQUIRED || ppti->tag & M_CORNER )
    return(0);
  else if ( ppti->tag > pptj->tag )
    return(0);

  bb.ilist = boulep(sm,k,i,&bb);
  if ( bb.ilist < 2 || bb.closed )  return(0);
  flag = (j == idir[i+1]);
  nbl  = 0;
  is2  = pt->vn[j];
  nj   = sm->geom[is2].vn;
  gj   = min(sm->geom[is2].gap,angdev) - EPS;

  do {
    nbldeb  = nbl;
    new2old = old2new = 0.0f;

    /* get target value */
    pt = &sm->tria[bb.list[1]];
    qtarget = pt->qual;
    for (l=2; l<=bb.ilist; l++) {
      kk = bb.list[l];
      pt = &sm->tria[kk];
      if ( pt->qual < qtarget )  qtarget = pt->qual;
      gl->h[l] = 0.0f;
    }
    qtarget *= opts.degrad;

    for (l=2; l<=bb.ilist; l++) {
      numk = bb.list[l];
      nk = bb.nump[l];
      pt = &sm->tria[numk];
      i1 = idir[nk+1];
      i2 = idir[nk+2];
      a  = pt->v[i1];
      b  = pt->v[i2];
      p1 = &sm->point[a];
      p2 = &sm->point[b];
      
      if ( hexist(jnum,flag ? b : a) )  return(0);

      /* get vertex normals */
      is1 = pt->vn[i1];
      is2 = pt->vn[i2];
      na =  sm->geom[is1].vn;
      nb =  sm->geom[is2].vn;
      ga = min(sm->geom[is1].gap,angdev) - EPS;
      gb = min(sm->geom[is2].gap,angdev) - EPS;

      ux = pptj->c[0] - p1->c[0];
      uy = pptj->c[1] - p1->c[1];
      uz = pptj->c[2] - p1->c[2];
      d1 = ux*ux + uy*uy + uz*uz;
      if ( d1 == 0.0f || d1 > hmax2 )  return(0);
      
      vx = pptj->c[0] - p2->c[0];
      vy = pptj->c[1] - p2->c[1];
      vz = pptj->c[2] - p2->c[2];
      d2 = vx*vx + vy*vy + vz*vz;
      if ( d2 == 0.0f )  return(0);
      ++nbl;
      gl->h[nbl] = 0.0f;

      /* check if curve preserved */
      if ( l == bb.ilist ) {
	if ( flag ) {
	  dd = 1.0f / sqrt(d2);
	  ax = vx * dd;
	  ay = vy * dd;
	  az = vz * dd;
	  bx = ppti->c[0] - p2->c[0];
	  by = ppti->c[1] - p2->c[1];
	  bz = ppti->c[2] - p2->c[2];
	}
	else {
	  dd = 1.0 / sqrt(d1);
	  ax = ux * dd;
	  ay = uy * dd;
	  az = uz * dd;
	  bx = ppti->c[0] - p1->c[0];
	  by = ppti->c[1] - p1->c[1];
	  bz = ppti->c[2] - p1->c[2];
	}
	dd = bx*ax + by*ay + bz*az;
	bx = bx - dd*ax;
	by = by - dd*ay;
	bz = bz - dd*az;
	delta = bx*bx + by*by + bz*bz;
        if ( delta > 0.0f )  delta = sqrt(delta);
	delta = max(pt->dish,delta);
	if ( delta > lbande )  return(0);
	gl->h[nbl] += delta;
      }

      /* compute face normal */
      gl->n[nbl][0] = uy*vz - uz*vy;
      gl->n[nbl][1] = uz*vx - ux*vz;
      gl->n[nbl][2] = ux*vy - uy*vx;
      dd = gl->n[nbl][0]*gl->n[nbl][0] + gl->n[nbl][1]*gl->n[nbl][1] 
         + gl->n[nbl][2]*gl->n[nbl][2];
      if ( dd == 0.0f ) return(0);
      dd  = sqrt(dd);
      dd1 = 1.0 / dd;
      gl->n[nbl][0] *= dd1;
      gl->n[nbl][1] *= dd1;
      gl->n[nbl][2] *= dd1;

      /* check normal flipping */
      if ( pt->n[0]*gl->n[nbl][0] + pt->n[1]*gl->n[nbl][1] + 
           pt->n[2]*gl->n[nbl][2] < COS20DEG )
	return(0);

      /* check quality degradation */
      wx = p2->c[0] - p1->c[0];
      wy = p2->c[1] - p1->c[1];
      wz = p2->c[2] - p1->c[2];
      d3 = wx*wx + wy*wy + wz*wz;
      if ( d3 == 0.0f )  return(0);
      gl->q[nbl] = dd / (d1+d2+d3);
      if ( d1 < lbande*lbande )    continue;
      if ( gl->q[nbl] < qtarget )  return(0);

      /* check surface smoothness */
      if ( gl->n[nbl][0]*nj[0] + gl->n[nbl][1]*nj[1] + gl->n[nbl][2]*nj[2] < gj ||
	   gl->n[nbl][0]*na[0] + gl->n[nbl][1]*na[1] + gl->n[nbl][2]*na[2] < ga ||
	   gl->n[nbl][0]*nb[0] + gl->n[nbl][1]*nb[1] + gl->n[nbl][2]*nb[2] < gb )
	return(0);

      /* check distance to surface */
      dd = pt->n[0]*ux + pt->n[1]*uy + pt->n[2]*uz;
      delta = fabs(ux*nj[0] + uy*nj[1] + uz*nj[2]);

      /* projection of pptj onto face */
      px = pptj->c[0] - dd*pt->n[0];
      py = pptj->c[1] - dd*pt->n[1];
      pz = pptj->c[2] - dd*pt->n[2];

      /* barycentric coordinates */
      ax = ppti->c[0] - px;
      ay = ppti->c[1] - py;
      az = ppti->c[2] - pz;
      bx = p1->c[0] - px;
      by = p1->c[1] - py;
      bz = p1->c[2] - pz;
      cx = p2->c[0] - px;
      cy = p2->c[1] - py;
      cz = p2->c[2] - pz;

      cb1 = pt->n[0] * (by*cz - bz*cy) + pt->n[1] * (bz*cx - bx*cz) 
          + pt->n[2] * (bx*cy - by*cx);
      cb2 = pt->n[0] * (cy*az - cz*ay) + pt->n[1] * (cz*ax - cx*az) 
          + pt->n[2] * (cx*ay - cy*ax);
      cb3 = pt->n[0] * (ay*bz - az*by) + pt->n[1] * (az*bx - ax*bz) 
          + pt->n[2] * (ax*by - ay*bx);
      
      som = cb1 + cb2 + cb3;
      if ( som == 0.0f )  return(0);
      som = 1.0f / som;
      cb1 *= som;
      cb2 *= som;
      cb3 *= som;

      /* compute distance to surface */
      nbneg = 0;
      delta = dd;
      ppt = 0;
      wcb = 1.0f;
      kk  = 0;
      pta = 0;
      if ( cb1 < 0.0f ) {
	wcb   = 1.0 / (1.0-cb1);
	delta = dd * wcb;
	nbneg++;
      }
      if ( cb2 < 0.0f ) {
	wcb   = 1.0 / (1.0-cb2);
	delta = dd * wcb;
	nbneg++;
        if ( l < bb.ilist ) {
	  ppt = p1;
	  pta = &sm->tria[pt->adj[i1]];
	  kk  = l+1;
	} 
      }
      if ( cb3 < 0.0f ) {
	wcb   = 1.0 / (1.0-cb3);
	delta = dd * wcb;
	nbneg++;
        if ( l > 2 ) {
	  ppt = p2;
	  pta= &sm->tria[pt->adj[i2]];
	  kk = l-1;
	}
      }

      /* check Hausdorff distance */
      gl->h[nbl] += fabs(delta);
      if ( pt->dish+gl->h[nbl] > lbande ) return(0);

      /* check distance ppti to new face */
      if ( nbneg == 2 )
	old2new = fabs(gl->n[nbl][0]*(ppti->c[0]-p1->c[0]) 
	        + gl->n[nbl][1]*(ppti->c[1]-p1->c[1])
	        + gl->n[nbl][2]*(ppti->c[2]-p1->c[2]));
      else if ( nbneg == 1 ) {
	if ( pta && kk ) {
	  ax = (ppt->c[0]-ppti->c[0]) - wcb*(pptj->c[0]-ppt->c[0]);
	  ay = (ppt->c[1]-ppti->c[1]) - wcb*(pptj->c[1]-ppt->c[1]);
	  az = (ppt->c[2]-ppti->c[2]) - wcb*(pptj->c[2]-ppt->c[2]);
	  dd = pta->n[0]*ax + pta->n[1]*ay + pta->n[2]*az;
	  
          gl->h[nbldeb+kk-1] = max(gl->h[nbldeb+kk-1], fabs(dd));
	}
      }
      else
	new2old = fabs(delta);

      /* check curvature sign */
      if ( !(pt->tag[bb.nump[l]] & M_RIDGE_GEO) ) {
	adj  = pt->adj[bb.nump[l]];
	voy  = pt->voy[bb.nump[l]];
	pta  = &sm->tria[adj];

	/* check smoothness */
	ang1 = pt->n[0]*pta->n[0] + pt->n[1]*pta->n[1] + pt->n[2]*pta->n[2];
	ang2 = gl->n[nbl][0]*pta->n[0] + gl->n[nbl][1]*pta->n[1] 
             + gl->n[nbl][2]*pta->n[2];
	if ( ang2 < max(angdev,min(epsok,ang1)) - EPS )
	  return(0);

	/* compute angle and curvature */
	if ( fabs(ang1) < COS1DEG ) {
	  sign = wx * (pt->n[1]*pta->n[2] - pt->n[2]*pta->n[1]) 
	       + wy * (pt->n[2]*pta->n[0] - pt->n[0]*pta->n[2]) 
	       + wz * (pt->n[0]*pta->n[1] - pt->n[1]*pta->n[0]);
	  delta = wx * (gl->n[nbl][1]*pta->n[2] - gl->n[nbl][2]*pta->n[1]) 
	        + wy * (gl->n[nbl][2]*pta->n[0] - gl->n[nbl][0]*pta->n[2]) 
	        + wz * (gl->n[nbl][0]*pta->n[1] - gl->n[nbl][1]*pta->n[0]);
	  if ( sgn(sign) != sgn(delta) )  return(0);
	}
      }
    }

    /* last Hausdorff = max(min(d(a,b)) */
    delta = min(old2new,new2old);
    for (l=2; l<=bb.ilist; l++) {
      kk = bb.list[l];
      pt = &sm->tria[kk];
      if ( delta > gl->h[nbldeb+l-1] )  
        gl->h[nbldeb+l-1] = delta;
      if ( pt->dish+gl->h[nbldeb+l-1] > lbande )  return(0);
    }

    /* get new manifold */
    pt   = &sm->tria[bb.list[1]];
    if ( flag ) {
      adj = pt->adj[idir[bb.nump[1]+2] ];
      voy = pt->voy[idir[bb.nump[1]+2] ];
    }
    else {
      adj = pt->adj[ idir[bb.nump[1]+1] ];
      voy = pt->voy[ idir[bb.nump[1]+1] ];
    }

    if ( adj ) {
      pt = &sm->tria[ adj ];
      if ( pt->v[idir[voy+1]] == inum ) {
	bb.ilist = boulep(sm,adj,idir[voy+1],&bb);
        flag  = 1;
	jnum  = pt->v[idir[voy+2]];
	pptj  = &sm->point[jnum];
	if ( pptj->tag > M_NOTAG )
	  nj = (&sm->geom[pt->vn[idir[voy+2]]])->vn;
      }
      else {
	bb.ilist = boulep(sm,adj,idir[voy+2],&bb);
	flag  = 0;
	jnum  = pt->v[idir[voy+1]];
	pptj  = &sm->point[jnum];
	if ( pptj->tag > M_NOTAG )
	  nj = (&sm->geom[pt->vn[idir[voy+1]]])->vn;
      }
      if ( nbl+bb.ilist > LONMAX )  return(0);
    }
  } while (adj && (adj != k) );

  return(1);
}  


#ifdef __cplusplus
}
#endif










