#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define LADMI    1.4143
#define LADMI2   1.2


int deled1(pSurfMesh sm,int k,int i,int j,double tail,Global *gl) {
  pTriangle   pt,pta;
  pPoint      ppti,pptj,p1,p2;
  pMetric     pmj,pm1,pm2;
  Ball        bb;
  double      dd,dd1,dd2,d1,d2,d3,ux,uy,uz,vx,vy,vz;
  double      gj,ga,gb,dhd,hmax2,tail1;
  float      *nj,*na,*nb,nn[3],qtarget;
  int         l,a,b,inum,jnum,adj,voy;
  int         i1,i2,is1,is2,numk,kk,flag,nbl;

  /* default */
  pt   = &sm->tria[k];
  inum =  pt->v[i];
  jnum =  pt->v[j];
  ppti = &sm->point[inum];
  pptj = &sm->point[jnum];

  /* check if collapse possible */
  if ( ppti->tag == M_UNUSED )
    return(0);
  else if ( ppti->tag & M_REQUIRED || ppti->tag & M_CORNER )
    return(0);
  else if ( ppti->tag > pptj->tag )
    return(0);
  if ( opts.hmax > 0.0 )
    hmax2 = opts.hmax*opts.hmax;
  else
    hmax2 = info.delta*info.delta;

  /* get ball of vertex i */  
  bb.ilist = boulep(sm,k,i,&bb);
  if ( bb.ilist < 2 )  return(0);
  else if ( bb.closed ) {
    yerr.inderr[0] = pt->v[i];
    prierr(ERR,4012);
    return(0);
  }

  /* analyze ball(s) of vertex i */
  flag = (j == idir[i+1]);
  nbl  = 0;

  /* normal at point j */
  is2 = pt->vn[j];
  nj =  sm->geom[is2].vn;
  gj =  min(sm->geom[is2].gap,opts.gap) - EPS;
  pmj = 0;
  if ( !(opts.ctrl & ISO) )  pmj = &sm->metric[jnum];

  do {
    /* get target value */
    qtarget = 2.0;
    for (l=1; l<=bb.ilist; l++) {
      pt = &sm->tria[bb.list[l]];
      if ( pt->qual < qtarget )
 	    qtarget = pt->qual;
    }
    qtarget *= opts.degrad;

    for (l=2; l<=bb.ilist; l++) {
      kk   = bb.list[l];
      numk = bb.nump[l];
      pt = &sm->tria[kk];
      i1 = idir[numk+1];
      i2 = idir[numk+2];
      a  = pt->v[i1];
      b  = pt->v[i2];
      p1 = &sm->point[a];
      p2 = &sm->point[b];

      /* check new edge */
      if ( hexist(jnum,flag ? b : a) )  return(0);

      if ( ++nbl >= LONMAX )  return(0);
      is1 = pt->vn[i1];
      is2 = pt->vn[i2];
      na = sm->geom[is1].vn;
      nb = sm->geom[is2].vn;
      ga = min(sm->geom[is1].gap,opts.gap) - EPS;
      gb = min(sm->geom[is2].gap,opts.gap) - EPS;

      /* compute edge lengths */
      ux = p1->c[0] - pptj->c[0];
      uy = p1->c[1] - pptj->c[1];
      uz = p1->c[2] - pptj->c[2];
      d1 = ux*ux + uy*uy + uz*uz;
      if ( d1 == 0.0f || d1 > hmax2 )  return(0);
      
      vx = p2->c[0] - pptj->c[0];
      vy = p2->c[1] - pptj->c[1];
      vz = p2->c[2] - pptj->c[2];
      d2 = vx*vx + vy*vy + vz*vz;
      if ( d2 == 0.0 )  return(0);

      /* compute normalized (unit) length */
      if ( !flag ) {
        if ( opts.ctrl & ISO ) {
          tail1 = sqrt(d1);
          tail1 = max(tail1/p1->size,tail1/pptj->size);
        }
        else {
          pm1 = &sm->metric[a];
          dd1 = pm1->m[0]*ux*ux + pm1->m[3]*uy*uy + pm1->m[5]*uz*uz \
              + 2.0*(pm1->m[1]*ux*uy + pm1->m[2]*ux*uz + pm1->m[4]*uy*uz);
          if ( dd1 <= 0.0 )  dd1 = 0.0f;
          dd2 = pmj->m[0]*ux*ux + pmj->m[3]*uy*uy + pmj->m[5]*uz*uz \
              + 2.0*(pmj->m[1]*ux*uy + pmj->m[2]*ux*uz + pmj->m[4]*uy*uz);
          if ( dd2 <= 0.0 )  dd2 = 0.0f;
          tail1 = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
        }
      }
      else {
        if ( opts.ctrl & ISO ) {
          tail1 = sqrt(d2);
          tail1 = max(tail1/p2->size,tail1/pptj->size);
        }
        else {
          pm2 = &sm->metric[b];
          dd1 = pm2->m[0]*vx*vx + pm2->m[3]*vy*vy + pm2->m[5]*vz*vz \
              + 2.0*(pm2->m[1]*vx*vy + pm2->m[2]*vx*vz + pm2->m[4]*vy*vz);
          if ( dd1 <= 0.0 )  dd1 = 0.0f;
          dd2 = pmj->m[0]*vx*vx + pmj->m[3]*vy*vy + pmj->m[5]*vz*vz \
              + 2.0*(pmj->m[1]*vx*vy + pmj->m[2]*vx*vz + pmj->m[4]*vy*vz);
          if ( dd2 <= 0.0 )  dd2 = 0.0f;
          tail1 = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
        }
      }
      if ( tail1 < 1.01*tail || tail1 > LADMI )  return(0);

     /* compute face normal */
      gl->n[nbl][0] = uy*vz - uz*vy;
      gl->n[nbl][1] = uz*vx - ux*vz;
      gl->n[nbl][2] = ux*vy - uy*vx;
      gl->h[nbl] = 0.0f;
      dd = gl->n[nbl][0]*gl->n[nbl][0] + gl->n[nbl][1]*gl->n[nbl][1] + \
           gl->n[nbl][2]*gl->n[nbl][2];
      if ( dd > 0.0 ) {
	    dd  = sqrt(dd);
        dd1 = 1.0f / dd;
	    gl->n[nbl][0] *= dd1;
	    gl->n[nbl][1] *= dd1;
	    gl->n[nbl][2] *= dd1;
      }
      else
	    return(0);

      /* check normal deviation */
      if ( gl->n[nbl][0]*nj[0] + gl->n[nbl][1]*nj[1] + gl->n[nbl][2]*nj[2] < gj ||
	   gl->n[nbl][0]*na[0] + gl->n[nbl][1]*na[1] + gl->n[nbl][2]*na[2] < ga ||
	   gl->n[nbl][0]*nb[0] + gl->n[nbl][1]*nb[1] + gl->n[nbl][2]*nb[2] < gb )
  	    return(0);

      /* bound quality degradation */
      if ( opts.ctrl & ISO ) {
        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];
        d3 = ux*ux + uy*uy + uz*uz;
        if ( d3 == 0.0 )  return(0);
        gl->q[nbl] = (float)(dd / (d1 + d2 + d3));
      }
      else {
        pm1 = &sm->metric[a];       
        pm2 = &sm->metric[b];
        if ( !qualfa_a(p1->c,p2->c,pptj->c,pm1,pm2,pmj,&gl->q[nbl],nn) )
          return(0);
      }
      if ( gl->q[nbl] < qtarget )  return(0);

      /* check angle with neighbor */
      adj = pt->adj[numk];
      if ( adj && !(pt->tag[numk] & M_RIDGE_GEO) ) {
	    pta = &sm->tria[adj];
	    dhd = pta->n[0]*gl->n[nbl][0] + pta->n[1]*gl->n[nbl][1] + pta->n[2]*gl->n[nbl][2];
	    if ( dhd < opts.ridge )  return(0);
      }
    }

    /* get new manifold */
    kk   = bb.list[1];
    numk = bb.nump[1];
    i1   = idir[numk+1];
    i2   = idir[numk+2];

    pt   = &sm->tria[kk];
    if ( flag ) {
      adj = pt->adj[i2];
      voy = pt->voy[i2];
    }
    else {
      adj = pt->adj[i1];
      voy = pt->voy[i1];
    }

    if ( adj ) {
      pt = &sm->tria[adj];
      i1 = idir[voy+1];
      i2 = idir[voy+2];
      if ( pt->v[i1] == inum ) {
	    bb.ilist = boulep(sm,adj,i1,&bb);
	    if ( bb.ilist < 2 )  return(0);
        flag  = 1;
	    jnum  = pt->v[i2];
	    pptj  = &sm->point[jnum];
	    if ( pptj->tag > M_NOTAG )
	      nj = (&sm->geom[pt->vn[i2]])->vn;
      }
      else {
	    bb.ilist = boulep(sm,adj,i2,&bb);
	    if ( bb.ilist < 2 )  return(0);
	    flag  = 0;
	    jnum  = pt->v[i1];
	    pptj  = &sm->point[jnum];
	    if ( pptj->tag > M_NOTAG )
	      nj = (&sm->geom[pt->vn[i1]])->vn;
      }
    }

  } while (adj && (adj != k) );

  return(1);
}  
