/* 
 *  attempt to collapse non-manifold ridge (i -> j)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 2001.  All rights reserved.
*/
#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int deled0(pSurfMesh sm,int k,int i,int j,Global *gl) {
  pTriangle   pt;
  pPoint      ppti,pptj,p1,p2;
  Ball        bb;
  double      dd,ux,uy,uz;
  float       qtarget;
  int         l,a,b,inum,jnum,voy;
  int         ii,i1,i2,numk,kk,kl,flag,nbl;

  /* default */
  pt   = &sm->tria[k];
  inum =  pt->v[i];
  jnum =  pt->v[j];
  ppti = &sm->point[inum];
  pptj = &sm->point[jnum];

  /* check if collapse possible */
  if ( ppti->tag & M_REQUIRED || ppti->tag & M_CORNER ||
       ppti->tag > pptj->tag )
    return(0);

  /* check length */
  ux = ppti->c[0] - pptj->c[0];
  uy = ppti->c[1] - pptj->c[1];
  uz = ppti->c[2] - pptj->c[2];
  dd = ux*ux + uy*uy + uz*uz;
  if ( dd > opts.bande*opts.bande )  return(0);

  nbl = 0;
  kk  = k;
  ii  = i;
  do {
    /* get ball of vertex ii */
    bb.ilist = boulep(sm,kk,ii,&bb);
    if ( bb.ilist < 2 )  return(0);

    /* get target value */
    qtarget = 2.0;
    for (l=1; l<=bb.ilist; l++) {
      pt = &sm->tria[bb.list[l]];
      if ( pt->qual < qtarget )
	    qtarget = pt->qual;
    }
    qtarget *= opts.degrad;

    pt = &sm->tria[kk];
    i1 = idir[ii+1];
    flag = jnum == pt->v[i1];

    /* analyze ball */
    for (l=2; l<=bb.ilist; l++) {
      kl   = bb.list[l];
      numk = bb.nump[l];
      pt = &sm->tria[kl];
      if ( flag ) {
        i1 = idir[numk+1];
        i2 = idir[numk+2];
      }
      else {
        i1 = idir[numk+2];
        i2 = idir[numk+1];
      }
      a = pt->v[i1];
      b = pt->v[i2];

      /* check new edge */
      if ( hexist(jnum,b) )   return(0);
      if ( ++nbl >= LONMAX )  return(0);

      p1 = &sm->point[a];
      p2 = &sm->point[b];
      if ( !qualfa(p1->c,p2->c,pptj->c,&gl->q[nbl],gl->n[nbl]) )  return(0);
      else if ( gl->q[nbl] < qtarget )  return(0);

      dd = gl->n[nbl][0]*pt->n[0] + gl->n[nbl][1]*pt->n[1] \
         + gl->n[nbl][2]*pt->n[2];
      if ( dd < 0.0 )  return(0);
      gl->h[nbl] = 0.0;
    }
/*
    if ( bb.ilist == 2 && pt->tag[i1] & M_NOMANIFOLD ) {
      printf("CAS PARTICULIER:  %d\n",pt->v[numk]);
      return(0);
    }
*/

    /* get new manifold */
    pt = &sm->tria[kk];
    i1 = idir[ii+1];
    i2 = idir[ii+2];
    if ( flag ) {
      kk  = pt->adj[i2];
      voy = pt->voy[i2];
    }
    else {
      kk  = pt->adj[i1];
      voy = pt->voy[i1];
    }
    if ( !kk || kk == k )  break;
    pt = &sm->tria[kk];
    i1 = idir[voy+1];
    ii = pt->v[i1] == inum ? i1 : idir[voy+2];
  }
  while ( kk != k );

  return(1);
}  

