/* 
 *  attempt to collapse a mesh ridge (i -> j)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/
#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int delar1(pSurfMesh sm,int k,int i,int j) {
  pTriangle   pt,pt1;
  pPoint      pptj,p1,p2;
  double      dd,d1,d2,ux,uy,uz,vx,vy,vz;
  int         a,b,c,inum,jnum;
  int         adj,voy,k1,flag;

  /* default */
  pt   = &sm->tria[k];
  inum =  pt->v[i];
  jnum =  pt->v[j];
  pptj = &sm->point[jnum];
  flag = (j == idir[i+1]);
  ux = uy = uz = 0.0;
  vx = vy = vz = 0.0;

  /* get ball vertex j */
  if ( !(pptj->tag & M_CORNER) ) {
    pt1 = pt;
    adj = pt1->adj[i];
    voy = i;
    while ( (adj != k) && (pt1->tag[voy] == M_NOTAG) ) {
      voy =  pt1->voy[voy];
      pt1 = &sm->tria[adj];
      voy = flag ? idir[voy+1] : idir[voy+2];
      adj = pt1->adj[voy];
    }

    voy = flag ? idir[voy+2] : idir[voy+1];
    a  = pt1->v[voy];
    if ( a != inum ) {
      p1 = &sm->point[a];
      ux = p1->c[0] - pptj->c[0];
      uy = p1->c[1] - pptj->c[1];
      uz = p1->c[2] - pptj->c[2];
      d1 = ux*ux + uy*uy + uz*uz;
      if ( d1 == 0.0 )  return(0);
      d1 = 1.0 / sqrt(d1);
      ux *= d1;
      uy *= d1;
      uz *= d1;
    }
  }

  /* get ball vertex i */
  pt1 = pt;
  adj = pt1->adj[j];
  voy = j;
  k1  = adj;
  while ( (adj != k) && (pt1->tag[ voy ] == M_NOTAG) ) {
    voy =  pt1->voy[voy];
    pt1 = &sm->tria[adj];
    voy = flag ? idir[voy+2] : idir[voy+1];
    k1  = adj;
    adj = pt1->adj[voy];
  }

  voy = flag ? idir[voy+1] : idir[voy+2];
  b  = pt1->v[voy];
  p1 = &sm->point[b];
  if ( p1->tag & M_CORNER )
    return(1);

  vx = p1->c[0] - pptj->c[0];
  vy = p1->c[1] - pptj->c[1];
  vz = p1->c[2] - pptj->c[2];
  d2  = vx*vx + vy*vy + vz*vz;
  if ( d2 == 0.0 )  return(0);
  d2 = 1.0 / sqrt(d2);
  vx *= d2;
  vy *= d2;
  vz *= d2;

  if ( !(pptj->tag & M_CORNER) && (ux*vx + uy*vy + uz*vz > -opts.ridge) )
    return(0);

  /* get ball vertex b */
  pt1 = &sm->tria[k1];
  voy = flag ? idir[voy+1] : idir[voy+2];
  adj = pt1->adj[voy];

  while ( (adj != k1) && (pt1->tag[ voy ] == M_NOTAG) ) {
    voy =  pt1->voy[voy];
    pt1 = &sm->tria[adj];
    voy = flag ? idir[voy+2] : idir[voy+1];
    adj = pt1->adj[voy];
  }

  voy = flag ? idir[voy+1]: idir[voy+2];
  c   = pt1->v[voy];
  p2  = &sm->point[c];

  ux = p2->c[0] - p1->c[0];
  uy = p2->c[1] - p1->c[1];
  uz = p2->c[2] - p1->c[2];
  d1 = ux*ux + uy*uy + uz*uz;
  if ( d1 == 0.0 )  return(0);
  d1  = 1.0 / sqrt(d1);
  ux *= d1;
  uy *= d1;
  uz *= d1;
  dd = ux*vx + uy*vy + uz*vz;

  return(dd > opts.ridge);
}

