/*
 *  check mesh data base consistency
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


static int dumpit(pSurfMesh sm,int k,int level) {
  pTriangle   pt;

  pt = &sm->tria[k];
  fprintf(stderr,"\n------- ERROR LEVEL %d -------\n\n",level);
  fprintf(stderr,"TRIANGLE   :      %8d\n",k);
  fprintf(stderr,"VERTICES   :      %8d %8d %8d\n",pt->v[0],pt->v[1],pt->v[2]);
  fprintf(stderr,"EDGE TAGS  :      %8d %8d %8d\n",pt->tag[0],pt->tag[1],pt->tag[2]);
  fprintf(stderr,"EDGES REFS :      %8d %8d %8d\n",pt->edg[0],pt->edg[1],pt->edg[2]);
  fprintf(stderr,"ADJACENT   :      %8d %8d %8d\n",pt->adj[0],pt->adj[1],pt->adj[2]);
  fprintf(stderr,"NORM. VERT.:      %8d %8d %8d\n",pt->vn[0],pt->vn[1],pt->vn[2]);
  fprintf(stderr,"NORMAL     :      %.6E %.6E %.6E\n",pt->n[0],pt->n[1],pt->n[2]);

  fprintf(stderr,"\n ## DIAG:  "); fflush(stdout);
  switch(level) {
    case 1: 
      fprintf(stderr,"missing normal at vertex\n"); break;
    case 2:
      fprintf(stderr,"unused vertex\n"); break;
    case 3:
      fprintf(stderr,"missing edge in hash table\n"); break;
    case 4:
      fprintf(stderr,"uncorrect edge tag (null adj.)\n"); break;
    case 5:
      fprintf(stderr,"uncorrect edge tag (ref 1 != ref2)\n"); break;
    case 6:
      fprintf(stderr,"uncorrect edge tag (ref 1 == ref2)\n"); break;
    case 7:
      fprintf(stderr,"uncorrect adjacent triangle\n"); break;
    case 8:
      fprintf(stderr,"uncorrect adjacent link\n"); break;
    case 9:
      fprintf(stderr,"uncorrect neighbor link\n"); break;
    case 10:
      fprintf(stderr,"null normal found\n"); break;
    case 11:
      fprintf(stderr,"adjacent is triangle itself\n");  break;
    default:
      fprintf(stderr,"\n");
  }
  fprintf(stderr,"------- EXIT. -------\n",level);

#ifdef DEBUG 
  outmsh(sm,"dump.mesh");
#endif
  exit(2);
}

int debug(pSurfMesh sm,int level) {
  pTriangle  pt,pt1;
  double     dd;
  float      nn[3];
  float      qq;
  int        k,i,a,b,i1,i2,adj,pre,voy,it;

  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    for (i=0; i<3; i++) {
      if ( (&sm->point[pt->v[i]])->tag & M_UNUSED ) dumpit(sm,k,2);
      if ( pt->v[i] > sm->npmax )  dumpit(sm,k,2);
      i1 = idir[i+1];
      i2 = idir[i+2];
      if ( !hexist(pt->v[i2],pt->v[i1]) ) {
        printf("tria %d: %d %d %d\n",k,pt->v[0],pt->v[1],pt->v[2]);
        printf("edge %d %d\n",pt->v[i2],pt->v[i1]);
        dumpit(sm,k,3);
      }
      adj = pt->adj[i];
      voy = pt->voy[i];
      if ( !adj ) {
	if ( !(pt->tag[i] & M_RIDGE_GEO) ) dumpit(sm,k,4);
      }
      else {
        if ( adj == k )  dumpit(sm,k,11);
	pt1 = &sm->tria[adj];
	if ( pt->tag[i] == M_NOTAG )
	  if ( pt->ref != pt1->ref ) dumpit(sm,k,5);
	if ( pt->tag[i] & M_RIDGE_REF )
	  if ( pt1->ref == pt->ref && pt->edg[i] == 0 ) dumpit(sm,k,6);

	/* check no manifold */
        a   = pt->v[i1];
	b   = pt->v[i2];
	if ( pt->tag[i] & M_NOMANIFOLD ) {
	  pre = i;
	  pt1 = pt;
	  it  = 0;
	  do {
	    voy = pt1->voy[pre];
	    adj = pt1->adj[pre];
	    pt1 = &sm->tria[adj];
	    pre = voy;
	    i1  = idir[voy+1];
	    i2  = idir[voy+2];
	    if ( (pt1->v[i1] != a && pt1->v[i2] != a) ||
		 (pt1->v[i1] != b && pt1->v[i2] != b) ) dumpit(sm,k,7);
	    ++it;
	  }
	  while ( adj != k && it < 100 );
	  if ( adj != k )  dumpit(sm,k,8);
	}
	else if ( pt1->adj[voy] != k || pt1->voy[voy] != i )
          dumpit(sm,k,9);
      }
    }
    if ( level < 1 )  continue;
    
    for (i=0; i<3; i++)
      if ( pt->vn[i] <= 0 || pt->vn[i] > sm->nv )   dumpit(sm,k,1);
    qualfa(&sm->point[pt->v[0]].c[0],&sm->point[pt->v[1]].c[0],
           &sm->point[pt->v[2]].c[0],&qq,nn);
    dd = pt->n[0]*pt->n[0] + pt->n[1]*pt->n[1] + pt->n[2]*pt->n[2];
    if ( dd < 1.e-10) {
      dd = nn[0]*nn[0] + nn[1]*nn[1] + nn[2]*nn[2];
      if ( dd < 1.e-10 )  dumpit(sm,k,10);
    }
  }

  return(1);
}


int debug_q(pSurfMesh sm) {
  pQuad    pq,pq1;
  int      k,adj;
  ubyte    i,i1,i2,voy;

  for (k=1; k<=sm->nq; k++) {
    pq = &sm->quad[k];
    if ( !pq->v[0] )  continue;
    
    for (i=0; i<4; i++) {
      i1 = idirq[i+1];
      i2 = idirq[i+2];
      if ( !hexist(pq->v[i1],pq->v[i2]) ) {
        puts("Error 1");
        printf("quad %d: %d %d %d %d\n",k,pq->v[0],pq->v[1],pq->v[2],pq->v[3]);
        printf("edge %d %d\n",pq->v[i2],pq->v[i1]);
        exit(1);
      }
      adj = pq->adj[i];
      voy = pq->voy[i];
      if ( !adj ) {
	if ( !(pq->tag[i] & M_RIDGE_GEO) ) {
          puts("Error 2");
          printf("quad %d: %d %d %d %d\n",k,pq->v[0],pq->v[1],pq->v[2],pq->v[3]);
	  printf("adj expected\n");
	  exit(2);
        }
      }
      else {
        if ( adj == k ) {
          puts("Error 3");
          printf("quad %d: %d %d %d %d\n",k,pq->v[0],pq->v[1],pq->v[2],pq->v[3]);
	  printf("pointer to itself\n");
	  exit(3);
	}
	pq1 = &sm->quad[adj];
      }
    }
  }
  
}



#ifdef __cplusplus
}
#endif
