/*
 *  bound sizes
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int cutmet(pSurfMesh sm) {
  pPoint      ppt;
  float       hmin,hmax;
  int         k;

  /* default */
  E_put("cutmet");
  if ( imprim < -4 )  primsg(1017);
  sm->mark++;

  /* minimal size given */
  if ( opts.hmin > 0.0 ) {
    hmin = FLT_MAX / 2.0;
    hmax = -1.0;
    for (k=1; k<=sm->np; k++) {
      ppt = &sm->point[k];
      if ( ppt->tag & M_UNUSED ) continue;
      ppt->color = sm->mark;
      ppt->size  = max(ppt->size,opts.hmin);
      ppt->size  = min(ppt->size,opts.hmax);
      /* local size bounds */
      hmin = min(hmin,ppt->size);
      hmax = max(hmax,ppt->size);
    }
  }
  else {
    opts.hmin = FLT_MAX/2.;
    for (k=1; k<=sm->np; k++) {
      ppt = &sm->point[k];
      if ( ppt->tag & M_UNUSED ) continue;
      ppt->color = sm->mark;
      if ( !sm->nmfixe )
        ppt->size = max(ppt->size,opts.bande);
      opts.hmin = min(ppt->size,opts.hmin);
      opts.hmax = max(ppt->size,opts.hmax);
    }
    hmin = opts.hmin;
    hmax = opts.hmax;
  }
  if ( imprim < -4 ) {
    yerr.cooerr[0] = hmin;
    yerr.cooerr[1] = hmax;
    primsg(1021);
  }

  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
