/* 
 *  find point on surface (Walton's)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2003.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define COS70DEG    .3420201433256688


int coorpo(pSurfMesh sm,int k,int i,float *c,float t,float *nn) {
  pTriangle     pt;
  pPoint        p1,p2;
  double        q1[3],q2[3];
  double        ux,uy,uz,a,a0,a1,a2,d,dd,rho,sigma,d18;
  double        w[3],w0[3],w1[3],w2[3],aa0[3],aa1[3],aa2[3],pp[3],h[3];
  double        d1,d2,t1,t2,t12,tt1;
  double        b0,b1,b2,b3;
  float        *n1,*n2,*tg1,*tg2,tt[3];
  int           pa,pb,i1,i2;

  /* default */
  pt = &sm->tria[k];
  i1 = idir[i+1];
  i2 = idir[i+2];
  pa = pt->v[i1];
  pb = pt->v[i2];
  p1 = &sm->point[pa];
  p2 = &sm->point[pb];

  /* get unit vector */
  ux = p2->c[0] - p1->c[0];
  uy = p2->c[1] - p1->c[1];
  uz = p2->c[2] - p1->c[2];
  d  = ux*ux + uy*uy + uz*uz;
  if ( fabs(d) < EPSD )  return(0);
  d   = sqrt(d);
  d18 = d / 18.0f;
  dd  = 1.0 / d;
  ux *= dd;
  uy *= dd;
  uz *= dd;

  /* get vertex normals */
  if ( !pt->vn[i1] || !pt->vn[i2] )  return(0);
  n1  = sm->geom[pt->vn[i1]].vn;
  n2  = sm->geom[pt->vn[i2]].vn;
  tg1 = tg2 = 0;

  /* check valid model */
  if ( fabs(ux*n1[0] + uy*n1[1] + uz*n1[2]) > COS20DEG ) {
    if ( imprim < -5 ) {
      yerr.cooerr[0] = ux*n1[0] + uy*n1[1] + uz*n1[2];
      yerr.inderr[0] = pa;
      yerr.inderr[1] = pb;
      prierr(WAR,4014);
    }
    return(0);
  }
  if ( fabs(ux*n2[0] + uy*n2[1] + uz*n2[2]) > COS20DEG ) {
    if ( imprim < -5 ) {
      yerr.cooerr[0] = ux*n2[0] + uy*n2[1] + uz*n2[2];
      yerr.inderr[0] = pa;
      yerr.inderr[1] = pb;
      prierr(WAR,4010);
    }
    return(0);
  }

  a     = n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2];
  a0    = n1[0]*ux + n1[1]*uy + n1[2]*uz;
  a1    = n2[0]*ux + n2[1]*uy + n2[2]*uz;
  a2    = (4. - a*a);
  rho   = 6.0 * (2.0*a0 + a*a1) / a2;
  sigma = 6.0 * (2.0*a1 + a*a0) / a2;

  /* parameters */
  t1  = 1.0 - t;
  t2  = t * t;
  t12 = t1 * t1;
  tt1 = 2.0 * t * t1;
  b0  = t12 * t1;
  b1  = 3.0 * t12 * t;
  b2  = 3.0 * t1 * t2;
  b3  = t2 * t;

  /* compute control points (pp. 115) */
  tt[0] = ux;
  tt[1] = uy;
  tt[2] = uz;

  if ( p1->tag & M_CORNER && p2->tag & M_CORNER ) {
    c[0] = t1 * p1->c[0] + t * p2->c[0];
    c[1] = t1 * p1->c[1] + t * p2->c[1];
    c[2] = t1 * p1->c[2] + t * p2->c[2];
    if ( pt->tag[i] == M_NOTAG ) {
      nn[0] = 0.5 * (n1[0] + n2[0]);
      nn[1] = 0.5 * (n1[1] + n2[1]);
      nn[2] = 0.5 * (n1[2] + n2[2]);
      dd = sqrt(nn[0]*nn[0] + nn[1]*nn[1] + nn[2]*nn[2]);
      if ( dd > 0.0 ) {
        dd = 1.0 / dd;
        nn[0] *= dd;
        nn[1] *= dd;
        nn[2] *= dd;
      }
    }
    else {
      nn[0] = ux;
      nn[1] = uy;
      nn[2] = uz;
    }
    return(1);
  }

  else if ( pt->tag[i] == M_NOTAG ) {
    q1[0] = p1->c[0] + d18 * (6.*ux - 2.*rho*n1[0] + sigma*n2[0]);
    q1[1] = p1->c[1] + d18 * (6.*uy - 2.*rho*n1[1] + sigma*n2[1]);
    q1[2] = p1->c[2] + d18 * (6.*uz - 2.*rho*n1[2] + sigma*n2[2]);

    q2[0] = p2->c[0] - d18 * (6.*ux + rho*n1[0] - 2.*sigma*n2[0]);
    q2[1] = p2->c[1] - d18 * (6.*uy + rho*n1[1] - 2.*sigma*n2[1]);
    q2[2] = p2->c[2] - d18 * (6.*uz + rho*n1[2] - 2.*sigma*n2[2]);
  }
/*
  else if ( p1->tag & M_CORNER && p2->tag & M_CORNER ) {
    c[0] = t1 * p1->c[0] + t * p2->c[0];
    c[1] = t1 * p1->c[1] + t * p2->c[1];
    c[2] = t1 * p1->c[2] + t * p2->c[2];

    nn[0] = ux;
    nn[1] = uy;
    nn[2] = uz;
    return(1);
  }  
*/
  else if ( p1->tag & M_CORNER ) {
    if ( !p2->tge )  return(0);
    tg2 = sm->tgte[p2->tge].t;
    dd  = ux*tg2[0] + uy*tg2[1] + uz*tg2[2];
    if ( dd < 0.0f ) {
      tg2[0] = -tg2[0];
      tg2[1] = -tg2[1];
      tg2[2] = -tg2[2];
    }
    q2[0] = p2->c[0] - d/3. * tg2[0];
    q2[1] = p2->c[1] - d/3. * tg2[1];
    q2[2] = p2->c[2] - d/3. * tg2[2];

    q1[0] = p1->c[0] + 0.5 * (q2[0] - p1->c[0]);
    q1[1] = p1->c[1] + 0.5 * (q2[1] - p1->c[1]);
    q1[2] = p1->c[2] + 0.5 * (q2[2] - p1->c[2]);
/*
    q1[0] = p1->c[0] + d/3. * ux;
    q1[1] = p1->c[1] + d/3. * uy;
    q1[2] = p1->c[2] + d/3. * uz;
*/
  }
  
  else if ( p2->tag & M_CORNER ) {
    if ( !p1->tge )  return(0);
    tg1 = sm->tgte[p1->tge].t;
    dd = ux*tg1[0] + uy*tg1[1] + uz*tg1[2];
    if ( dd < 0.0f ) {
      tg1[0] = -tg1[0];
      tg1[1] = -tg1[1];
      tg1[2] = -tg1[2];
    }
    q1[0] = p1->c[0] + d/3. * tg1[0];
    q1[1] = p1->c[1] + d/3. * tg1[1];
    q1[2] = p1->c[2] + d/3. * tg1[2];
    
    q2[0] = p2->c[0] - 0.5 * (p2->c[0] - q1[0]);
    q2[1] = p2->c[1] - 0.5 * (p2->c[1] - q1[1]);
    q2[2] = p2->c[2] - 0.5 * (p2->c[2] - q1[2]);
/*
    q2[0] = p2->c[0] - d/3. * ux;
    q2[1] = p2->c[1] - d/3. * uy;
    q2[2] = p2->c[2] - d/3. * uz;
*/
  }

  else {
    if ( !p1->tge )  return(0);
    tg1 = sm->tgte[p1->tge].t;
    dd = ux*tg1[0] + uy*tg1[1] + uz*tg1[2];
    if ( dd < 0.0f ) {
      tg1[0] = -tg1[0];
      tg1[1] = -tg1[1];
      tg1[2] = -tg1[2];
    }
    q1[0] = p1->c[0] + d/3. * tg1[0];
    q1[1] = p1->c[1] + d/3. * tg1[1];
    q1[2] = p1->c[2] + d/3. * tg1[2];

    if ( !p2->tge )  return(0);
    tg2 = sm->tgte[p2->tge].t;
    dd = ux*tg2[0] + uy*tg2[1] + uz*tg2[2];
    if ( dd < 0.0f ) {
      tg2[0] = -tg2[0];
      tg2[1] = -tg2[1];
      tg2[2] = -tg2[2];
    }
    q2[0] = p2->c[0] - d/3. * tg2[0];
    q2[1] = p2->c[1] - d/3. * tg2[1];
    q2[2] = p2->c[2] - d/3. * tg2[2];
  }

  /* new point location */
  c[0] = b0*p1->c[0] + b1*q1[0] + b2*q2[0] + b3*p2->c[0];
  c[1] = b0*p1->c[1] + b1*q1[1] + b2*q2[1] + b3*p2->c[1];
  c[2] = b0*p1->c[2] + b1*q1[2] + b2*q2[2] + b3*p2->c[2];

  /* tangent vectors */
  w0[0] = q1[0] - p1->c[0];
  w0[1] = q1[1] - p1->c[1];
  w0[2] = q1[2] - p1->c[2];
  
  w2[0] = p2->c[0] - q2[0];
  w2[1] = p2->c[1] - q2[1];
  w2[2] = p2->c[2] - q2[2];

  w[0] = w0[0] + w2[0];
  w[1] = w0[1] + w2[1];
  w[2] = w0[2] + w2[2];
  dd = w[0]*ux + w[1]*uy + w[2]*uz;
  if ( dd >= d ) {
    if ( imprim < -5 ) {
      yerr.cooerr[0] = dd;
      yerr.inderr[0] = pa;
      yerr.inderr[1] = pb;
      prierr(WAR,4010);
    }
    return(0);
  }

  w1[0] = q2[0] - q1[0];
  w1[1] = q2[1] - q1[1];
  w1[2] = q2[2] - q1[2];

  pp[0] = t12*w0[0] + tt1*w1[0] + t2*w2[0];
  pp[1] = t12*w0[1] + tt1*w1[1] + t2*w2[1];
  pp[2] = t12*w0[2] + tt1*w1[2] + t2*w2[2];

  /* normalize vectors */
  d = w0[0]*w0[0] + w0[1]*w0[1] + w0[2]*w0[2];
  if ( egal(d,0.0) )  return(0);
  d = 1.0f / sqrt(d);
  w0[0] *= d;
  w0[1] *= d;
  w0[2] *= d;
  
  d = w2[0]*w2[0] + w2[1]*w2[1] + w2[2]*w2[2];
  if ( egal(d,0.0) )  return(0);
  d = 1.0f / sqrt(d);
  w2[0] *= d;
  w2[1] *= d;
  w2[2] *= d;

  /* check angle w. tangent */
  d1 = w0[0]*ux + w0[1]*uy + w0[2]*uz;
  if ( d1 <= COS70DEG ) {
    if ( imprim < -5 ) {
      yerr.cooerr[0] = d1;
      yerr.inderr[0] = pa;
      yerr.inderr[1] = pb;
      prierr(WAR,4010);
    }
    return(0);
  }

  /* check angle w. tangent */
  d2 = w2[0]*ux + w2[1]*uy + w2[2]*uz;
  if ( d2 <= COS70DEG ) {
    if ( imprim < -5 ) {
      yerr.cooerr[0] = d2;
      yerr.inderr[0] = pa;
      yerr.inderr[1] = pb;
      prierr(WAR,4010);
    }
    return(0);
  }

  /* new vertex tangent */
  if ( pt->tag[i] > M_NOTAG ) {
    dd = sqrt(pp[0]*pp[0] + pp[1]*pp[1] + pp[2]*pp[2]);
    if ( dd > 0.0 ) {
      dd = 1.0 / dd;
      nn[0] = pp[0] * dd;
      nn[1] = pp[1] * dd;
      nn[2] = pp[2] * dd;
    }
    return(1);
  }

  /* compute vertex normal */
  aa0[0] = n1[1]*w0[2] - n1[2]*w0[1];
  aa0[1] = n1[2]*w0[0] - n1[0]*w0[2];
  aa0[2] = n1[0]*w0[1] - n1[1]*w0[0];
  aa2[0] = n2[1]*w2[2] - n2[2]*w2[1];
  aa2[1] = n2[2]*w2[0] - n2[0]*w2[2];
  aa2[2] = n2[0]*w2[1] - n2[1]*w2[0];
  aa1[0] = aa0[0] + aa2[0];
  aa1[1] = aa0[1] + aa2[1];
  aa1[2] = aa0[2] + aa2[2];

  d = aa1[0]*aa1[0] + aa1[1]*aa1[1] + aa1[2]*aa1[2];
  if ( d > 0.0f ) {
    d = 1.0f / sqrt(d);
    aa1[0] *= d;
    aa1[1] *= d;
    aa1[2] *= d;
  }

  h[0] = t12*aa0[0] + tt1*aa1[0] + t2*aa2[0];
  h[1] = t12*aa0[1] + tt1*aa1[1] + t2*aa2[1];
  h[2] = t12*aa0[2] + tt1*aa1[2] + t2*aa2[2];

  /* vertex normal */
  nn[0] = pp[1]*h[2] - pp[2]*h[1];
  nn[1] = pp[2]*h[0] - pp[0]*h[2];
  nn[2] = pp[0]*h[1] - pp[1]*h[0];
  d = nn[0]*nn[0] + nn[1]*nn[1] + nn[2]*nn[2];
  if ( d > 0.0f ) {
    d = 1.0f / sqrt(d);
    nn[0] *= d;
    nn[1] *= d;
    nn[2] *= d;
  }

  return(1);
}


#ifdef __cplusplus
}
#endif

