/*
 *  Hausdorff decimation
 *  remove degree 3 vertices
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int colver(pSurfMesh sm,int npfin,double lbande,double angdev) {
  pTriangle   pt,pt1;
  pPoint      ppt;
  Global      gl;
  Ball        bb;
  int         i,i2,k,kk,l,nk,nd,nde,npp,it,maxtou;

  /* default */
  if ( sm->np <= npfin )  return(0);
  E_put("colver");
  if ( imprim < -4 )  primsg(2004);
  ++sm->mark;

  maxtou = 6;
  nde = it = 0;
  do {
    nd = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0]  || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;
      npp++;

      for (i=0; i<3; i++) {
        ppt = &sm->point[pt->v[i]];
        if ( ppt->tag > M_NOTAG )  continue;

        bb.ilist = boulep(sm,k,i,&bb);
        if ( !bb.closed )  continue;

        if ( bb.ilist == 3 ) {
          if ( colpo3(sm,k,i,&bb,lbande,angdev) ) {
            nd++;
            break;
          }
        }
        else if ( bb.ilist == 4 ) {
          for (l=1; l<=bb.ilist; l++) {
            kk = bb.list[l];
            nk = bb.nump[l];
            i2 = idir[nk+2];
            pt1 = &sm->tria[kk];
            ppt = &sm->point[pt1->v[i2]];
            if ( pt1->tag[nk] > M_NOTAG || ppt->tag > M_NOTAG )  continue;
            else if ( delpo2(sm,kk,i2,lbande,angdev,&bb,&gl) ) {
              if ( colpoi(sm,&bb,&gl) ) {
                nd++;
                break;
              }
              else  return(0);
            }
          }
          if ( l > bb.ilist )  continue;
          break;
        }
      }
      if ( sm->np-nde-nd <= npfin ) {
        E_pop();
        return(nde+nd);
      }
    }
    nde += nd;
  }
  while ( nd && ++it<maxtou );

  E_pop();
  return(nde);
}


#ifdef __cplusplus
}
#endif
