/* 
 *  collapse a mesh vertex 
 *  (tests performed in delpoi)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern int *heap;


int colpoi(pSurfMesh sm,Ball *bb,Global *gl) {
  pTriangle   pt,pta,ptn,pti;
  pPoint      ppt,pptj,p1,p2;
  int         inum,jnum,jvn,k,kk,numk,a,b,adj;
  ubyte       i1,i2,pre,voy;

  /* defaut */
  kk   = bb->list[1];
  numk = bb->nump[1];
  pt   = &sm->tria[kk];
  i1   =  idir[numk+1];
  i2   =  idir[numk+2];
  inum =  pt->v[numk];
  jnum =  pt->v[i2];
  jvn  =  pt->vn[i2];
  ppt  = &sm->point[inum];
  pptj = &sm->point[jnum];

  /* disable vertex */
  pt->v[0] = 0;
  ppt->tag = M_UNUSED;
  ppt->color  = sm->mark;
  pptj->color = sm->mark;

  /* remesh ball of vertex */
  b = 0;
  for (k=3; k<=bb->ilist; k++) {
    kk   = bb->list[k];
    numk = bb->nump[k];
    pt = &sm->tria[kk];
    i1 = idir[numk+1];
    i2 = idir[numk+2];
    a  = pt->v[i1];
    b  = pt->v[i2];
    p1 = &sm->point[a];
    p2 = &sm->point[b];
    p1->color = sm->mark;
    p2->color = sm->mark;

    if ( !hpop(inum,a) ) {
      prierr(ERR,1015);
      return(0);
    }
    pt->v[numk]  = jnum;
    pt->vn[numk] = jvn;
    if ( k > 3 && !hpush(jnum,a) ) {
      prierr(ERR,1015);
      return(0);
    }

    /* update face info. */
    pt->n[0]  = gl->n[k][0];
    pt->n[1]  = gl->n[k][1];
    pt->n[2]  = gl->n[k][2];
    pt->qual  = gl->q[k];
    pt->dish += gl->h[k];
    pt->flag1 = sm->mark;

    if ( heap )  hiprep(sm->tria,kk);

    /* store for edge swaps */
    if ( !pt->flag2 && ++sm->ipil < sm->npmax ) {
      pti = &sm->tria[sm->ipil];
      pti->nxt  = kk;
      pt->flag2 = 1;
    }
  }
  if ( b && !hpop(inum,b) ) {
    prierr(ERR,1015);
    return(0);
  }
  if ( !hpop(inum,jnum) ) {
    prierr(ERR,1015);
    return(0);
  }

  /* update adjacent faces */
  kk   = bb->list[1];
  numk = bb->nump[1];

  pt   = &sm->tria[kk];
  adj  =  pt->adj[numk];
  pre  = idir[bb->nump[bb->ilist]+1];
  ptn  = &sm->tria[bb->list[bb->ilist]];

  ptn->adj[pre]  = adj;
  ptn->voy[pre]  = pt->voy[numk];
  ptn->tag[pre] |= pt->tag[numk];
  ptn->edg[pre]  = max(pt->edg[numk],ptn->edg[pre]);
  ptn->flag1 = sm->mark;

  if ( adj ) {
    pta = &sm->tria[adj];
    voy = pt->voy[numk];
    if ( pta->adj[voy] != kk ) {
      if ( pta->tag[voy] & M_NOMANIFOLD ) {
	do {
	  adj = pta->adj[voy];
	  voy = pta->voy[voy];
	  pta = &sm->tria[adj];
	}
	while ( pta->adj[voy] != kk );
      }
      else {
	yerr.inderr[0] = kk;
	yerr.inderr[1] = bb->list[bb->ilist];
	prierr(ERR,1014);
	return(0);
      }
    }
    pta->adj[voy]  = bb->list[bb->ilist];
    pta->voy[voy]  = pre;
    pta->tag[voy] |= ptn->tag[pre];
    pta->edg[voy]  = max(pta->edg[voy],ptn->edg[pre]);
    pta->flag1     = sm->mark;
  }

  /* disable vertex and triangle */
  kk   = bb->list[2];
  numk = bb->nump[2];

  pt   = &sm->tria[kk];
  pt->v[0] = 0;
  adj = pt->adj[numk];
  pre = idir[bb->nump[3]+2];
  ptn = &sm->tria[bb->list[3]];

  ptn->adj[pre]  = adj;
  ptn->voy[pre]  = pt->voy[numk];
  ptn->tag[pre] |= pt->tag[numk];
  ptn->edg[pre]  = max(pt->edg[numk],ptn->edg[pre]);
  ptn->flag1 = sm->mark;

  if ( adj ) {
    pta = &sm->tria[adj];
    voy = pt->voy[numk];

    if ( pta->adj[voy] != kk ) {
      if ( pta->tag[voy] & M_NOMANIFOLD ) {
	do {
	  adj = pta->adj[voy];
	  voy = pta->voy[voy];
	  pta = &sm->tria[adj];
	}
	while ( pta->adj[voy] != kk );
      }
      else {
	yerr.inderr[0] = kk;
	yerr.inderr[1] = bb->list[3];
	prierr(ERR,1014);
	return(0);
      }
    }
    pta->adj[voy]  = bb->list[3];
    pta->voy[voy]  = pre;
    pta->tag[voy] |= ptn->tag[pre];
    pta->edg[voy]  = max(pta->edg[voy],ptn->edg[pre]);
    pta->flag1 = sm->mark;
  }

  return(1);
}


#ifdef __cplusplus
}
#endif
