/*
 *  Hausdorff decimation
 *  remove degree 3 vertices
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved. 
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern int *heap;

int colpo3(pSurfMesh sm,int k,int i,Ball *bb,double lbande,double angdev) {
  pTriangle    pt,pt2,pt3;
  pPoint       p0,p1,p2,p3;
  double       hd,dd,ux,uy,uz;
  float        q1,qtarget,n1[3];
  int          ip,kk,k3,kn3,adj;
  ubyte        i1,i2,nk;

  /* default */
  pt = &sm->tria[k];
  ip = pt->v[i];
  i1 = idir[i+1];
  i2 = idir[i+2];

  p0 = &sm->point[ip];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  qtarget = pt->qual;

  kk  = bb->list[2];
  nk  = bb->nump[2];
  pt2 = &sm->tria[kk];
  k3  = pt2->v[idir[nk+2]];
  kn3 = pt2->vn[idir[nk+2]];
  p3  = &sm->point[k3];
  if ( pt2->qual < qtarget )  qtarget = pt2->qual;

  kk  = bb->list[3];
  pt3 = &sm->tria[kk];
  if ( pt3->qual < qtarget )  qtarget = pt3->qual;
  qtarget *= opts.degrad;

  if ( !qualfa(p1->c,p2->c,p3->c,&q1,n1) )  return(0);
  if ( q1 < qtarget )  return(0);
  
  /* hausdorff */
  ux = p1->c[0] - p0->c[0];
  uy = p1->c[1] - p0->c[1];
  uz = p1->c[2] - p0->c[2];
  dd = fabs(ux*n1[0] + uy*n1[1] + uz*n1[2]);
  if ( pt->dish + dd > lbande )  return(0);
  hd = dd;

  /* update structure */
  p0->tag = M_UNUSED;
  p1->color = sm->mark;
  p2->color = sm->mark;
  p3->color = sm->mark;

  if ( !hpop(pt->v[i1],ip) || !hpop(pt->v[i2],ip) || !hpop(k3,ip) ) {
    yerr.inderr[0] = ip;
    yerr.inderr[1] = k;
    prierr(ERR,1013);
    return(0);
  }
  
  pt->v[i]  = k3;
  pt->vn[i] = kn3;

  /* update adjacent */
  kk  = bb->list[2];
  nk  = bb->nump[2];

  pt->adj[i1] = pt2->adj[nk];
  pt->voy[i1] = pt2->voy[nk];
  pt->tag[i1] = pt2->tag[nk];
  pt->edg[i1] = pt2->edg[nk];
  if ( pt2->adj[nk] ) {
    do {
      adj = pt2->adj[nk];
      nk  = pt2->voy[nk];
      pt2 = &sm->tria[adj];
    }
    while ( pt2->adj[nk] != kk );
    pt2->adj[nk] = k;
    pt2->voy[nk] = i1;
  }

  kk  = bb->list[3];
  nk  = bb->nump[3];

  pt->adj[i2] = pt3->adj[nk];
  pt->voy[i2] = pt3->voy[nk];
  pt->tag[i2] = pt3->tag[nk];
  pt->edg[i2] = pt3->edg[nk];
  if ( pt3->adj[nk] ) {
    do {
      adj = pt3->adj[nk];
      nk  = pt3->voy[nk];
      pt3 = &sm->tria[adj];
    }
    while ( pt3->adj[nk] != kk );
    pt3->adj[nk] = k;
    pt3->voy[nk] = i2;
  }
 
  kk  = bb->list[2];
  pt2 = &sm->tria[kk];
  pt2->v[0] = 0;
  kk  = bb->list[3];
  pt3 = &sm->tria[kk];
  pt3->v[0] = 0;

  if ( heap )  hiprep(sm->tria,k);
  
  pt->qual = q1;
  pt->n[0] = n1[0];
  pt->n[1] = n1[1];
  pt->n[2] = n1[2];
  pt->flag1 = sm->mark;
  pt->dish += hd;

  return(1);
}  

