/* 
 *  collapse a mesh edge ( geometric ridge)
 *  (check performed in deled)
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999.  All rights reserved.
*/

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern int *heap;

int coledg(pSurfMesh sm,int k,int i,int j,Global *gl) {
  pTriangle   pt,pta,ptn;
  pPoint      ppti,pptj,p1,p2;
  Ball        bb;
  int         ii,il,l,inum,jnum,jvn,a,b,c,adj,pre,voy,flag;
  int         i1,i2,kk,kl,nbl;

  /* default */
  pt   = &sm->tria[k];
  inum =  pt->v[i];
  jnum =  pt->v[j];
  ppti = &sm->point[inum];
  pptj = &sm->point[jnum];

  /* update ball(s) of vertex */
  nbl = 0;
  kk  = k;
  ii  = i;
  do {
    /* get ball vertex i */
    bb.ilist = boulep(sm,kk,ii,&bb);
    if ( bb.ilist < 2 )  return(0);
    pt = &sm->tria[kk];
    i1 = idir[ii+1];
    i2 = idir[ii+2];
    if ( jnum == pt->v[i1] ) {
      flag = 1;
      jvn  = pt->vn[i1];
    }
    else { 
      flag = 0;
      jvn  = pt->vn[i2];
    }
    pt->v[0] = 0;
    c = 0;
    /* re-write ball of vertex */
    for (l=2; l<=bb.ilist; l++) {
      kl = bb.list[l];
      pt = &sm->tria[kl];
      il = bb.nump[l];
      if ( flag ) {
	i1 = idir[il+1];
	i2 = idir[il+2];
      }
      else {
	i1 = idir[il+2];
	i2 = idir[il+1];
      }
      a  = pt->v[i1];
      b  = pt->v[i2];
      c  = b;
      p1 = &sm->point[a];
      p2 = &sm->point[b];

      p1->color = sm->mark;
      p2->color = sm->mark;

      /* update edge table */
      if ( !hpop(inum,a) ) {
        E_put("coledg");
	    prierr(ERR,1015);
	    exit(1);
      }
      hpush(jnum,b);

      /* set vertex and its normal */
      pt->v[il]  = jnum;
      pt->vn[il] = jvn;

      ++nbl;
      pt->n[0] = gl->n[nbl][0];
      pt->n[1] = gl->n[nbl][1];
      pt->n[2] = gl->n[nbl][2];
      pt->qual = gl->q[nbl];
      pt->dish += gl->h[nbl];
      if ( heap )  hiprep(sm->tria,kl);
      pt->flag1 = sm->mark;
    }

    /* update adjacent faces */
    pt  = &sm->tria[kk];
    ptn = &sm->tria[bb.list[2]];
    i1  = idir[ii+1];
    i2  = idir[ii+2];
    adj = pt->adj[ii];
    voy = pt->voy[ii];
    if ( flag )
      pre = idir[bb.nump[2]+2];
    else
      pre = idir[bb.nump[2]+1];

    ptn->adj[pre]  = adj;
    ptn->voy[pre]  = voy;
    ptn->tag[pre] |= pt->tag[ii];
    ptn->edg[pre]  = max(pt->edg[ii],ptn->edg[pre]);

    if ( adj ) {
      pta = &sm->tria[adj];
      if ( pta->adj[voy] != kk ) {
	if ( pta->tag[voy] & M_NOMANIFOLD ) {
	  /* update non manifold edge */
	  do {
	    adj = pta->adj[voy];
	    voy = pta->voy[voy];
	    pta = &sm->tria[adj];
	  }
	  while ( pta->adj[voy] != bb.list[1] );
	}
	else {
	  yerr.inderr[0] = kk;
	  yerr.inderr[1] = bb.list[bb.ilist];
	  prierr(ERR,1014);
	  return(0);
	}
      }
      pta->adj[voy]  = bb.list[2];
      pta->voy[voy]  = pre;
      pta->tag[voy] |= ptn->tag[pre];
      pta->edg[voy]  = max(pta->edg[voy],ptn->edg[pre]);
      pta->flag1 = sm->mark;
    }

    /* get new manifold */
    if ( flag ) {
      kk  = pt->adj[i2];
      voy = pt->voy[i2];
    }
    else {
      kk  = pt->adj[i1];
      voy = pt->voy[i1];
    }
    if ( !kk || kk == k )  break;
    pt = &sm->tria[kk];
    i1 = idir[voy+1];
    ii = pt->v[i1] == inum ? i1 : idir[voy+2];
  }
  while ( kk != k );

  /* pop edge i,j from hash table */
  if ( !hpop(inum,jnum) || !hpop(inum,c) ) {
    E_put("coledg");
    prierr(ERR,1015);
    exit(1);
  }
  ppti->tag = M_UNUSED;
  pptj->color = sm->mark;

 return(1);
}

