/*
 *  geometric mesh optimization: collapse 
 *
 *  Written by Pascal J. Frey, Inria-Rocquencourt
 *  Copyright (c) Inria, 1999-2002.  All rights reserved. 
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int colar2(pSurfMesh sm,double lbande,double angdev) {
  pTriangle  pt;
  pPoint     p1,p2;
  Ball       bb;
  Global     gl;
  double     dd,ux,uy,uz;
  float      bande2;
  int        i,i1,i2,k,it,maxtou;
  int        nde,nd,ns;

  /* default */
  E_put("colar2");
  bande2 = opts.bande * opts.bande;
  maxtou = 6;
  nde = it = 0;
  ++sm->mark;

  do {
    nd = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++) {
	if ( pt->tag[i] & M_REQUIRED )  continue;
	i1 = idir[i+1];
	i2 = idir[i+2];
	p1 = &sm->point[pt->v[i1]];
	p2 = &sm->point[pt->v[i2]];
	sm->ipil = 0;

        /* check length */
        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];
        dd = ux*ux + uy*uy + uz*uz;
        if ( dd > bande2 && pt->tag[i] > M_NOTAG )
          if ( !delar1(sm,k,i1,i2) )  continue;

	/* collapse along ridge */
	if ( pt->tag[i] & M_RIDGE_GEO ) {
	  if ( deled2(sm,k,i1,i2,lbande,angdev,&gl) ) {
	    nd += coledg(sm,k,i1,i2,&gl);
	    break;
	  }
	  else if ( deled2(sm,k,i2,i1,lbande,angdev,&gl) ) {
	    nd += coledg(sm,k,i2,i1,&gl);
	    break;
	  }
	}
	else if ( p2->tag & M_CORNER || p2->tag & M_REQUIRED || 
		  p2->tag & M_RIDGE_GEO )
	  continue;
	else if ( delpo2(sm,k,i2,lbande,angdev,&bb,&gl) ) {
	  nd += colpoi(sm,&bb,&gl);
	  break;
	}
	if ( yerr.lerror )  return(nde+nd);
      }
      /* local optimization */
      ns = loptia2(sm,lbande,angdev);
    }
    nde += nd;
  }
  while ( nd && ++it<maxtou );

  E_pop();
  return(nde);
}


/* clone of colar2 using heap */
int colar22(pSurfMesh sm,int npfin,double lbande,double angdev) {
  pTriangle  pt;
  pPoint     p2;
  Ball       bb;
  Global     gl;
  int        i,i1,i2,k;
  int        nde,ns;

  /* default */
  E_put("colar22");
  nde = ns =  0;
  ++sm->mark;

  while ( sm->np-nde > npfin ) {
    k = hippop(sm->tria);
    if ( !k )  break;
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    else if ( pt->dish > lbande )  continue;

    for (i=0; i<3; i++) {
      if ( pt->tag[i] & M_REQUIRED )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      p2 = &sm->point[pt->v[i2]];
      sm->ipil = 0;

      if ( pt->tag[i] > M_NOTAG && !delar1(sm,k,i1,i2) )  continue;
      
      /* collapse along ridge */
      if ( pt->tag[i] & M_RIDGE_GEO ) {
        if ( deled2(sm,k,i1,i2,lbande,angdev,&gl) ) {
          nde += coledg(sm,k,i1,i2,&gl);
          break;
        }
        else if ( deled2(sm,k,i2,i1,lbande,angdev,&gl) ) {
          nde += coledg(sm,k,i2,i1,&gl);
          break;
        }
      }
      else if ( p2->tag & M_CORNER || p2->tag & M_REQUIRED || 
        p2->tag & M_RIDGE_GEO )
        continue;
      else if ( delpo2(sm,k,i2,lbande,angdev,&bb,&gl) ) {
        nde += colpoi(sm,&bb,&gl);
        break;
      }
      if ( yerr.lerror )  return(nde);
    }

    /* local optimization */
    ns += loptia2(sm,lbande,angdev);
    if ( yerr.lerror )  return(nde);
  }

  E_pop();
  return(nde);
}


#ifdef __cplusplus
}
#endif
