#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

#define LADMI    0.7071
#define LADMI2   0.6


int colar1(pSurfMesh sm,int npstart) {
  pTriangle  pt;
  pPoint     p1,p2;
  pMetric    ma,mb;
  Ball       bb;
  Global     gl;
  double     ux,uy,uz,dd,dd1,dd2,rap,tail;
  float      bande2;
  int        i,i1,i2,k,it,maxtou,nbp,nde,nd,ns,nsw;

  /* default */
  E_put("colar1");
  maxtou = 6;
  bande2 = opts.bande*opts.bande;
  nde = nsw = nbp = 0;
  it  = 0;
  ++sm->mark;

  do {
    nd = ns = 0;
    for (k=1; k<=sm->ne; k++) {
      pt = &sm->tria[k];
      if ( !pt->v[0] || pt->flag1 > sm->mark )  continue;
      pt->flag1 = sm->mark+1;

      for (i=0; i<3; i++) {
        if ( pt->tag[i] & M_REQUIRED )  continue;
        i1 = idir[i+1];
        i2 = idir[i+2];
        if ( pt->v[i1] > npstart && pt->v[i2] > npstart )  continue;
        p1 = &sm->point[pt->v[i1]];
        p2 = &sm->point[pt->v[i2]];
        sm->ipil = 0;

        /* compute edge length */
        ux = p2->c[0] - p1->c[0];
        uy = p2->c[1] - p1->c[1];
        uz = p2->c[2] - p1->c[2];
        dd = ux*ux + uy*uy + uz*uz;

        if ( opts.ctrl & ISO ) {
          dd1  = sqrt(dd);
          rap = (p2->size - p1->size) / p1->size;
          if ( fabs(rap) < EPS )
            tail = dd1 * (2.0-EPS) / (2.0*p1->size);
          else {
            /*
            tail  = 1.0/p1->size + 1.0/p1->size + 8.0/(p1->size+p2->size);
            tail *= dd1 / 6.0;
            */
            tail = max(dd1/p1->size,dd1/p2->size);
          }
        }
        else {
          ma = &sm->metric[pt->v[i1]];
          mb = &sm->metric[pt->v[i2]];
          dd1 =      ma->m[0]*ux*ux + ma->m[3]*uy*uy + ma->m[5]*uz*uz \
              + 2.0*(ma->m[1]*ux*uy + ma->m[2]*ux*uz + ma->m[4]*uy*uz);
          if ( dd1 <= 0.0 )  dd1 = 0.0;

          dd2 =      mb->m[0]*ux*ux + mb->m[3]*uy*uy + mb->m[5]*uz*uz \
              + 2.0*(mb->m[1]*ux*uy + mb->m[2]*ux*uz + mb->m[4]*uy*uz);
          if ( dd2 <= 0.0 )  dd2 = 0.0;
          tail = (sqrt(dd1)+sqrt(dd2) + 4.0*sqrt(0.5*(dd1+dd2))) / 6.0;
        }
        if ( tail > 0.2 /*LADMI*/ )  continue;
        nbp++;

        /* edge vector */
				if ( dd > bande2 && pt->tag[i] > M_NOTAG )
          if ( !delar1(sm,k,i1,i2) )  continue;

        /* collapse along ridge */
        if ( pt->tag[i] & M_RIDGE_GEO ) {
          if ( deled1(sm,k,i1,i2,tail,&gl) ) {
            nd += coledg(sm,k,i1,i2,&gl);
            break;
          }
          else if ( deled1(sm,k,i2,i1,tail,&gl) ) {
            nd += coledg(sm,k,i2,i1,&gl);
            break;
          }
        }
        else {
          if ( p2->tag & M_CORNER || p2->tag & M_REQUIRED || p2->tag & M_RIDGE_GEO )
            continue;
          else if ( delpo1(sm,k,i2,tail,&bb,&gl) ) {
            nd += colpoi(sm,&bb,&gl);
            break;
          }
        }
      }

      /* local optimization */
      ns += loptia1(sm,0);
      if ( yerr.lerror )  return(nde+nd);
    }
    nde += nd;
    nsw += ns;
  }
  while ( nd && ++it<maxtou );

  if ( imprim < -4 ) {
    yerr.inderr[0] = nbp;
    yerr.inderr[1] = nde;
    yerr.inderr[2] = nsw;
    primsg(4009);
  }

  E_pop();
  return(nde);
}
