#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* check tangents w/ ridge */
int chktge(pSurfMesh sm) {
  pTriangle    pt;
  pPoint       p1,p2,p3;
  double       dd,ux,uy,uz,vx,vy,vz;
  float       *tg;
  int          k,nm;
  ubyte        i,i1,i2;

  E_put("chktge");
  nm = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    
    for (i=0; i<3; i++) {
      if ( pt->tag[i] == M_NOTAG )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      p1 = &sm->point[pt->v[i1]];
      p2 = &sm->point[pt->v[i2]];
      p3 = &sm->point[pt->v[i]];

      if ( pt->tag[i] == M_NOTAG )  continue;
      else if ( p1->tag & M_CORNER && p2->tag & M_CORNER )  continue;

      /* edge support */
      ux = p2->c[0] - p1->c[0];
      uy = p2->c[1] - p1->c[1];
      uz = p2->c[2] - p1->c[2];
      dd = sqrt(ux*ux + uy*uy + uz*uz);
      if ( dd == 0.0f )  continue;
      ux /= dd;
      uy /= dd;
      uz /= dd;

      /* tangent at endpoints */
      if ( !(p1->tag & M_CORNER) &&
            (p1->tag & M_RIDGE_GEO || p1->tag & M_RIDGE_REF) ) {
        if ( !p1->tge )  return(0);
        tg = sm->tgte[p1->tge].t;
        dd = ux*tg[0] + uy*tg[1] + uz*tg[2];
        if ( dd < 0.0f ) {
          tg[0] = -tg[0];
          tg[1] = -tg[1];
          tg[2] = -tg[2];
        }
    
        dd  = (uy*tg[2] - uz*tg[1]) * pt->n[0];
        dd += (uz*tg[0] - ux*tg[2]) * pt->n[1];
        dd += (ux*tg[1] - uy*tg[0]) * pt->n[2];
        if ( dd > 0.0f ) {
          vx = p3->c[0] - p1->c[0];
          vy = p3->c[1] - p1->c[1];
          vz = p3->c[2] - p1->c[2];
          dd = sqrt(vx*vx + vy*vy + vz*vz);
          if ( dd == 0.0f )  continue;
          vx /= dd;
          vy /= dd;
          vz /= dd;
          if ( tg[0]*ux + tg[1]*uy + tg[2]*uz < vx*ux + vy*uy + vz*uz ) {
            tg[0] = ux;
            tg[1] = uy;
            tg[2] = uz;
            nm++;
          }
        }
      }

      if ( !(p2->tag & M_CORNER) &&
            (p2->tag & M_RIDGE_GEO || p2->tag & M_RIDGE_REF) ) {
        if ( !p2->tge )  return(0);
        tg = sm->tgte[p2->tge].t;
        dd = -ux*tg[0] - uy*tg[1] - uz*tg[2];
        if ( dd < 0.0f ) {
          tg[0] = -tg[0];
          tg[1] = -tg[1];
          tg[2] = -tg[2];
        }

        dd  = (uy*tg[2] - uz*tg[1]) * pt->n[0];
        dd += (uz*tg[0] - ux*tg[2]) * pt->n[1];
        dd += (ux*tg[1] - uy*tg[0]) * pt->n[2];
        if ( dd > 0.0f ) {
          vx = p3->c[0] - p2->c[0];
          vy = p3->c[1] - p2->c[1];
          vz = p3->c[2] - p2->c[2];
          dd = sqrt(vx*vx + vy*vy + vz*vz);
          if ( dd == 0.0f )  continue;
          vx /= dd;
          vy /= dd;
          vz /= dd;
          if ( tg[0]*ux + tg[1]*uy + tg[2]*uz > vx*ux + vy*uy + vz*uz ) {
            tg[0] = -ux;
            tg[1] = -uy;
            tg[2] = -uz;
            nm++;
          }
        }
      }
    }
  }
  
  E_pop();
  return(1);
}


#ifdef __cplusplus
}
#endif
