#ifdef __cplusplus
extern "C" {
#endif

#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


/* split edge i: check angle deviation */
int chkspl1_a(pSurfMesh sm,int k,int i,int *vtx,int *inp,double angdev) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      p0,p1,p2,p3;
  pMetric     m0,m1,m2,m3;
  double      fold,gap;
  float      *na,*nb,*nc,*nm,ga,gb,gc,n1[3],n2[3],qtarget,q1,q2;
  int         kk,ii,is0,is1,is2;
  ubyte       i1,i2;

  pt = &sm->tria[k];
  i1 = idir[i+1];
  i2 = idir[i+2];
  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  p3 = &sm->point[vtx[i]];
  qtarget = 0.01 * opts.degrad * pt->qual;
  fold    = max(opts.ridge,COS45DEG);

  m0 = &sm->metric[pt->v[i]];
  m1 = &sm->metric[pt->v[i1]];
  m2 = &sm->metric[pt->v[i2]];
  m3 = &sm->metric[vtx[i]];

  is0 = pt->vn[i];
  is1 = pt->vn[i1];
  is2 = pt->vn[i2];
  na = sm->geom[is0].vn;
  nb = sm->geom[is1].vn;
  nc = sm->geom[is2].vn;
  nm = sm->geom[inp[i]].vn;
  ga = sm->geom[is0].gap;
  gb = sm->geom[is1].gap;
  gc = sm->geom[is2].gap;

  /* check quality */
  if ( !qualfa_a(p0->c,p1->c,p3->c,m0,m1,m3,&q1,n1) || q1 < qtarget ||
       !qualfa_a(p0->c,p3->c,p2->c,m0,m3,m2,&q2,n2) || q2 < qtarget ) {
    pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i] = -vtx[i];
    return(0);
  }

  /* check gap deviation */
  gap = min(ga,gb);
  gap = min(gap,gc);
  gap = min(gap,angdev) - EPS;

  if ( n1[0]*na[0] + n1[1]*na[1] + n1[2]*na[2] < gap ||
       n1[0]*nb[0] + n1[1]*nb[1] + n1[2]*nb[2] < gap ||
       n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2] < fold ) {
    pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i] = -vtx[i];
    return(0);
  }
  else if ( n2[0]*na[0] + n2[1]*na[1] + n2[2]*na[2] < gap ||
            n2[0]*nc[0] + n2[1]*nc[1] + n2[2]*nc[2] < gap ) {
    pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i] = -vtx[i];
    return(0);
  }
  else if ( pt->tag[i] == M_NOTAG )
    if ( n1[0]*nm[0] + n1[1]*nm[1] + n1[2]*nm[2] < gap ||
         n2[0]*nm[0] + n2[1]*nm[1] + n2[2]*nm[2] < gap ) {
      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[i] = -vtx[i];
      return(0);
    }

  return(1);
}


/* split 2 edges : check angle deviation */
int chkspl2_a(pSurfMesh sm,int k,int i,int *vtx,int *inp,double angdev) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      p0,p1,p2,p3,p4;
  pMetric     m0,m1,m2,m3,m4;
  double      fold,gap;
  float      *na,*nb,*nc,*nm1,*nm2,ga,gb,gc;
  float       n1[3],n2[3],n3[3],qtarget,q1,q2,q3;
  int         kk,ii,is0,is1,is2;
  ubyte       i1,i2;

  pt = &sm->tria[k];
  i1 = idir[i+1];
  i2 = idir[i+2];
  p0 = &sm->point[pt->v[i]];
  p1 = &sm->point[pt->v[i1]];
  p2 = &sm->point[pt->v[i2]];
  p3 = &sm->point[vtx[i1]];
  p4 = &sm->point[vtx[i2]];
  qtarget = 0.01 * opts.degrad * pt->qual;
  fold    = max(opts.ridge,COS45DEG);

  m0 = &sm->metric[pt->v[i]];
  m1 = &sm->metric[pt->v[i1]];
  m2 = &sm->metric[pt->v[i2]];
  m3 = &sm->metric[vtx[i1]];
  m4 = &sm->metric[vtx[i2]];

  is0 = pt->vn[i];
  is1 = pt->vn[i1];
  is2 = pt->vn[i2];
  na = sm->geom[is0].vn;
  nb = sm->geom[is1].vn;
  nc = sm->geom[is2].vn;
  ga = sm->geom[is0].gap;
  gb = sm->geom[is1].gap;
  gc = sm->geom[is2].gap;

  nm1 = sm->geom[inp[i1]].vn;
  nm2 = sm->geom[inp[i2]].vn;

  /* check quality */
  if ( !qualfa_a(p0->c,p4->c,p3->c,m0,m4,m3,&q1,n1) || q1 < qtarget ||
       !qualfa_a(p4->c,p1->c,p3->c,m4,m1,m3,&q2,n2) || q2 < qtarget ) {
    pht = hedge(pt->v[i],pt->v[i1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i1] = -vtx[i1];
    vtx[i2] = -vtx[i2];
    return(0);
  }
  else if ( !qualfa_a(p3->c,p1->c,p2->c,m3,m1,m2,&q3,n3) || q3 < qtarget ) {
    pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i1] = -vtx[i1];
    return(0);
  }

  /* check gap deviation */
  gap = min(ga,gb);
  gap = min(gap,gc);
  gap = min(gap,angdev) - EPS;

  if ( n1[0]*na[0] + n1[1]*na[1] + n1[2]*na[2] < gap ||
       n2[0]*nb[0] + n2[1]*nb[1] + n2[2]*nb[2] < gap||
       n1[0]*n2[0] + n1[1]*n2[1] + n1[2]*n2[2] < fold ) {
    pht = hedge(pt->v[i],pt->v[i1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i1] = -vtx[i1];
    vtx[i2] = -vtx[i2];
    return(0);
  }
  else if ( n3[0]*nc[0] + n3[1]*nc[1] + n3[2]*nc[2] < gap ||
            n3[0]*nb[0] + n3[1]*nb[1] + n3[2]*nb[2] < gap ||
            n2[0]*n3[0] + n2[1]*n3[1] + n2[2]*n3[2] < fold ) {
    pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[i1] = -vtx[i1];
    return(0);
  }
  
  if ( pt->tag[i2] == M_NOTAG ) {
    if ( n1[0]*nm2[0] + n1[1]*nm2[1] + n1[2]*nm2[2] < gap ||
         n2[0]*nm2[0] + n2[1]*nm2[1] + n2[2]*nm2[2] < gap ) {
      pht = hedge(pt->v[i],pt->v[i1],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[i2] = -vtx[i2];
      return(0);
    }
  }
  if ( pt->tag[i1] == M_NOTAG ) {
    if ( n1[0]*nm1[0] + n1[1]*nm1[1] + n1[2]*nm1[2] < gap ||
         n2[0]*nm1[0] + n2[1]*nm1[1] + n2[2]*nm1[2] < gap ||
         n3[0]*nm1[0] + n3[1]*nm1[1] + n3[2]*nm1[2] < gap ) {
      pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[i1] = -vtx[i1];
      return(0);
    }
  }

  return(1);
}


/* split triangle k into 3 */
int chkspl3_a(pSurfMesh sm,int k,int *vtx,int *inp,double angdev) {
  pHashtable  pht;
  pTriangle   pt;
  pPoint      p0,p1,p2,p3,p4,p5;
  pMetric     m0,m1,m2,m3,m4,m5;
  double      fold,gap;
  float      *na,*nb,*nc,*nm1,*nm2,*nm3,ga,gb,gc;
  float       n1[3],n2[3],n3[3],n4[3],qtarget,q1,q2,q3,q4;
  int         kk,ii,is0,is1,is2;

  pt = &sm->tria[k];
  p0 = &sm->point[pt->v[0]];
  p1 = &sm->point[pt->v[1]];
  p2 = &sm->point[pt->v[2]];
  p3 = &sm->point[vtx[0]];
  p4 = &sm->point[vtx[1]];
  p5 = &sm->point[vtx[2]];
  qtarget = 0.01 * opts.degrad * pt->qual;
  fold    = max(opts.ridge,COS45DEG);

  m0 = &sm->metric[pt->v[0]];
  m1 = &sm->metric[pt->v[1]];
  m2 = &sm->metric[pt->v[2]];
  m3 = &sm->metric[vtx[0]];
  m4 = &sm->metric[vtx[1]];
  m5 = &sm->metric[vtx[2]];

  is0 = pt->vn[0];
  is1 = pt->vn[1];
  is2 = pt->vn[2];
  na = sm->geom[is0].vn;
  nb = sm->geom[is1].vn;
  nc = sm->geom[is2].vn;
  ga = sm->geom[is0].gap;
  gb = sm->geom[is1].gap;
  gc = sm->geom[is2].gap;

  nm1 = sm->geom[inp[0]].vn;
  nm2 = sm->geom[inp[1]].vn;
  nm3 = sm->geom[inp[2]].vn;

  gap = min(ga,gb);
  gap = min(gap,gc);
  gap = min(gap,angdev) - EPS;

  if ( !qualfa_a(p0->c,p5->c,p4->c,m0,m5,m4,&q1,n1) || q1 < qtarget ||
        n1[0]*na[0] + n1[1]*na[1] + n1[2]*na[2] < gap ) {
    pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[2] = -vtx[2];
    vtx[1] = -vtx[1];
    return(0);
  }
  else if ( !qualfa_a(p5->c,p1->c,p3->c,m5,m1,m3,&q2,n2) || q2 < qtarget ||
             n2[0]*nb[0] + n2[1]*nb[1] + n2[2]*nb[2] < gap ) {
    pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[2] = -vtx[2];
    vtx[0] = -vtx[0];
    return(0);
  }
  else if ( !qualfa_a(p4->c,p3->c,p2->c,m4,m3,m2,&q3,n3) || q3 < qtarget ||
             n3[0]*nc[0] + n3[1]*nc[1] + n3[2]*nc[2] < gap ) {
    pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[1] = -vtx[1];
    vtx[0] = -vtx[0];
    return(0);
  }
  else if ( !qualfa_a(p3->c,p4->c,p5->c,m3,m4,m5,&q4,n4) || q4 < qtarget ) {
    pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[0] = -vtx[0];
    vtx[1] = -vtx[1];
    vtx[2] = -vtx[2];
    return(0);
  }

  /* check gap deviation */
  if ( n1[0]*na[0] + n1[1]*na[1] + n1[2]*na[2] < gap ||
       n1[0]*n4[0] + n1[1]*n4[1] + n1[2]*n4[2] < fold ) {
    pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[2] = -vtx[2];
    vtx[1] = -vtx[1];
    return(0);
  }
  if ( n2[0]*nb[0] + n2[1]*nb[1] + n2[2]*nb[2] < gap ||
       n2[0]*n4[0] + n2[1]*n4[1] + n2[2]*n4[2] < fold ) {
    pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[2] = -vtx[2];
    vtx[0] = -vtx[0];
    return(0);
  }
  if ( n3[0]*nc[0] + n3[1]*nc[1] + n3[2]*nc[2] < gap ||
       n3[0]*n4[0] + n3[1]*n4[1] + n3[2]*n4[2] < fold ) {
    pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
    pht->elt = pht->ind = 0;
    vtx[1] = -vtx[1];
    vtx[0] = -vtx[0];
    return(0);
  }

  if ( pt->tag[2] == M_NOTAG ) {
    if ( n1[0]*nm3[0] + n1[1]*nm3[1] + n1[2]*nm3[2] < gap ||
         n2[0]*nm3[0] + n2[1]*nm3[1] + n2[2]*nm3[2] < gap ||
         n4[0]*nm3[0] + n4[1]*nm3[1] + n4[2]*nm3[2] < gap ) {
      pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[2] = -vtx[2];
      return(0);
    }
  }
  if ( pt->tag[1] == M_NOTAG ) {
    if ( n1[0]*nm2[0] + n1[1]*nm2[1] + n1[2]*nm2[2] < gap || 
         n3[0]*nm2[0] + n3[1]*nm2[1] + n3[2]*nm2[2] < gap ||
         n4[0]*nm2[0] + n4[1]*nm2[1] + n4[2]*nm2[2] < gap ) {
      pht = hedge(pt->v[0],pt->v[2],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[1] = -vtx[1];
      return(0);
    }
  }
  if ( pt->tag[0] == M_NOTAG ) {
    if ( n2[0]*nm1[0] + n2[1]*nm1[1] + n2[2]*nm1[2] < gap ||
         n3[0]*nm1[0] + n3[1]*nm1[1] + n3[2]*nm1[2] < gap ||
         n4[0]*nm1[0] + n4[1]*nm1[1] + n4[2]*nm1[2] < gap ) {
      pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
      pht->elt = pht->ind = 0;
      vtx[0] = -vtx[0];
      return(0);
    }
  }

  return(1);
}


#ifdef __cplusplus
}
#endif
