#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"

extern int *ntab;

int cassar_q(pSurfMesh sm) {
  pHashtable   pht;
  pTriangle    pt,pta;
  pQuad        pq;
  pGeomSupp    go;
  float       *n1,*n2,n[3],dd;
  int          adj,k,kk,ii,iv0,iv1,iv2,iv3,iv4,iv5,iv6,iv7,iv8;
  int          in3,in4,in5,in6,in7,in8;
  ubyte        i,i1,i2,jj1,jj2,voy;

  E_put("cassar_q");
  sm->quad = (pQuad)M_calloc(sm->nq+1,sizeof(Quad),"analar_q");
  assert(sm->quad);

  sm->nq = 0;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;

    adj = abs(pt->adj[pt->flag2]);
    if ( pt->flag2 < 10 && adj > k ) {
      voy = pt->voy[pt->flag2];
      pta = &sm->tria[adj];
      i   = pt->flag2;
      i1  = idir[i+1];
      i2  = idir[i+2];
      jj1 = idir[voy+1];
      jj2 = idir[voy+2];

      iv0 = pt->v[i];
      iv1 = pt->v[i1];
      iv2 = pt->v[i2];
      iv6 = pta->v[voy];

      pht = hedge(pt->v[i],pt->v[i1],&kk,&ii);
      iv3 = pht->ind;
      if ( pt->tag[i2] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in3 = sm->nv;
	n1 = sm->geom[pt->vn[i]].vn;
	n2 = sm->geom[pt->vn[i1]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in3 = pht->elt;

      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      iv4 = pht->ind;
      in4 = pht->elt;

      pht = hedge(pt->v[i],pt->v[i2],&kk,&ii);
      iv5 = pht->ind;
      if ( pt->tag[i1] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in5 = sm->nv;
	n1 = sm->geom[pt->vn[i]].vn;
	n2 = sm->geom[pt->vn[i2]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in5 = pht->elt;
 
      pht = hedge(pta->v[jj2],pta->v[voy],&kk,&ii);
      iv7 = pht->ind;
      if ( pta->tag[jj1] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in7 = sm->nv;
	n1 = sm->geom[pta->vn[jj2]].vn;
	n2 = sm->geom[pta->vn[voy]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in7 = pht->elt;

      pht = hedge(pta->v[jj1],pta->v[voy],&kk,&ii);
      iv8 = pht->ind;
      if ( pta->tag[jj2] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in8 = sm->nv;
	n1 = sm->geom[pta->vn[jj1]].vn;
	n2 = sm->geom[pta->vn[voy]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in8 = pht->elt;

      /* construction */
      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv0;
      pq->v[1] = iv3;
      pq->v[2] = iv4;
      pq->v[3] = iv5;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[0] = pt->tag[i2];
      pq->tag[3] = pt->tag[i1];
      pq->edg[0] = pt->edg[i2];
      pq->edg[3] = pt->edg[i1];
      if ( !qualfa_q(&sm->point[iv0].c[0],&sm->point[iv3].c[0],
                     &sm->point[iv4].c[0],&sm->point[iv5].c[0],&pq->qual,pq->n) ) {
	yerr.inderr[0] = sm->nq;
	prierr(WAR,4009);
      }

      pq->vn[0] = pt->vn[pt->flag2];
      pq->vn[1] = in3;
      pq->vn[2] = in4;
      pq->vn[3] = in5;

      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv3;
      pq->v[1] = iv1;
      pq->v[2] = iv7;
      pq->v[3] = iv4;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[0] = pt->tag[i2];
      pq->tag[1] = pta->tag[jj1];
      pq->edg[0] = pt->edg[i2];
      pq->edg[1] = pta->edg[jj1];
      if ( !qualfa_q(&sm->point[iv3].c[0],&sm->point[iv1].c[0],
                     &sm->point[iv7].c[0],&sm->point[iv4].c[0],&pq->qual,pq->n) ) {
	yerr.inderr[0] = sm->nq;
	prierr(WAR,4009);
      }

      pq->vn[0] = in3;
      pq->vn[1] = pt->vn[i1];
      pq->vn[2] = in7;
      pq->vn[3] = in4;
      
      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv5;
      pq->v[1] = iv4;
      pq->v[2] = iv8;
      pq->v[3] = iv2;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[2] = pta->tag[jj2];
      pq->tag[3] = pt->tag[i1];
      pq->edg[2] = pta->edg[jj2];
      pq->edg[3] = pta->edg[i1];
      if ( !qualfa_q(&sm->point[iv5].c[0],&sm->point[iv4].c[0],
                     &sm->point[iv8].c[0],&sm->point[iv2].c[0],&pq->qual,pq->n) ) {
        yerr.inderr[0] = sm->nq;
	prierr(WAR,4009);
      }

      pq->vn[0] = in5;
      pq->vn[1] = in4;
      pq->vn[2] = in8;
      pq->vn[3] = pt->vn[i2];

      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv4;
      pq->v[1] = iv7;
      pq->v[2] = iv6;
      pq->v[3] = iv8;
      pq->ref  = pta->ref;
      pq->tag[1] = pta->tag[jj1];
      pq->tag[2] = pta->tag[jj2];
      pq->edg[1] = pta->edg[jj1];
      pq->edg[2] = pta->edg[jj2];
      if ( !qualfa_q(&sm->point[iv4].c[0],&sm->point[iv7].c[0],
                     &sm->point[iv6].c[0],&sm->point[iv8].c[0],&pq->qual,pq->n) ) {
	yerr.inderr[0] = sm->nq;
	prierr(WAR,4009);
      }

      pq->vn[0] = in4;
      pq->vn[1] = in7;
      pq->vn[2] = pta->vn[voy];
      pq->vn[3] = in8;
    }
    
    else if ( pt->flag2 > 3 ) {
      iv0 = pt->v[0];
      iv1 = pt->v[1];
      iv2 = pt->v[2];

      pht = hedge(pt->v[0],pt->v[1],&kk,&ii);
      iv3 = pht->ind;
      if ( pt->tag[2] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in3 = sm->nv;
	n1 = sm->geom[pt->vn[0]].vn;
	n2 = sm->geom[pt->vn[1]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in3 = pht->elt;

      pht = hedge(pt->v[1],pt->v[2],&kk,&ii);
      iv4 = pht->ind;
      if ( pt->tag[0] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in4 = sm->nv;
	n1 = sm->geom[pt->vn[1]].vn;
	n2 = sm->geom[pt->vn[2]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in4 = pht->elt;

      pht = hedge(pt->v[2],pt->v[0],&kk,&ii);
      iv5 = pht->ind;
      if ( pt->tag[2] > M_NOTAG ) {
        go  = &sm->geom[++sm->nv];
        in5 = sm->nv;
	n1 = sm->geom[pt->vn[2]].vn;
	n2 = sm->geom[pt->vn[0]].vn;
	n[0] = 0.5 * (n1[0] + n2[0]);
	n[1] = 0.5 * (n1[1] + n2[1]);
	n[2] = 0.5 * (n1[2] + n2[2]);
	dd = 1.0 / sqrt(n[0]*n[0] + n[1]*n[1] + n[2]*n[2]);
        go->vn[0] = n[0] * dd;
        go->vn[1] = n[1] * dd;
        go->vn[2] = n[2] * dd;
        go->gap   = 1.0f;
      }
      else  in5 = pht->elt;

      iv6 = pt->nxt;
      in6 = ntab[pt->nxt];

      /* construction */
      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv0;
      pq->v[1] = iv3;
      pq->v[2] = iv6;
      pq->v[3] = iv5;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[0] = pt->tag[2];
      pq->tag[3] = pt->tag[1];
      pq->edg[0] = pt->edg[2];
      pq->edg[3] = pt->edg[1];
      if ( !qualfa_q(&sm->point[iv0].c[0],&sm->point[iv3].c[0],
                     &sm->point[iv6].c[0],&sm->point[iv5].c[0],&pq->qual,pq->n) ) {
	yerr.inderr[0] = sm->nq;
        prierr(WAR,4009);
      }
      pq->vn[0] = pt->vn[0];
      pq->vn[1] = in3;
      pq->vn[2] = in6;
      pq->vn[3] = in5;

      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv3;
      pq->v[1] = iv1;
      pq->v[2] = iv4;
      pq->v[3] = iv6;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[0] = pt->tag[2];
      pq->tag[1] = pt->tag[0];
      pq->edg[0] = pt->edg[2];
      pq->edg[1] = pt->edg[0];
      if ( !qualfa_q(&sm->point[iv3].c[0],&sm->point[iv1].c[0],
                     &sm->point[iv4].c[0],&sm->point[iv6].c[0],&pq->qual,pq->n) ) {
	yerr.inderr[0] = sm->nq;
        prierr(WAR,4009);
      }
      pq->vn[0] = in3;
      pq->vn[1] = pt->vn[1];
      pq->vn[2] = in4;
      pq->vn[3] = in6;

      pq = &sm->quad[++sm->nq];
      pq->v[0] = iv5;
      pq->v[1] = iv6;
      pq->v[2] = iv4;
      pq->v[3] = iv2;
      pq->ref  = pt->ref;
      pq->cc   = pt->cc;
      pq->tag[2] = pt->tag[0];
      pq->tag[3] = pt->tag[1];
      pq->edg[2] = pt->edg[0];
      pq->edg[3] = pt->edg[1];
      if ( !qualfa_q(&sm->point[iv5].c[0],&sm->point[iv6].c[0],
                     &sm->point[iv4].c[0],&sm->point[iv2].c[0],&pq->qual,pq->n) ) {
      	yerr.inderr[0] = sm->nq;
        prierr(WAR,4009);
      }
      pq->vn[0] = in5;
      pq->vn[1] = in6;
      pq->vn[2] = in4;
      pq->vn[3] = pt->vn[2];
    }
  }

  M_free(ntab);
  E_pop();
  return(sm->nq);
}

