#include "yams.h"
#include "defines.h"
#include "sproto.h"
#include "extern.h"


int cassar_a(pSurfMesh sm) {
  pHashtable    pht;
  pTriangle     pt;
  int           i,k,i1,i2,ii,ret,nedep,kk,nbs,inp[3],vtx[3];

  E_put("cassar");
  nedep = sm->ne;
  for (k=1; k<=sm->ne; k++) {
    pt = &sm->tria[k];
    if ( !pt->v[0] )  continue;
    nbs = 0;
    /* analyze edges */
    for (i=0; i<3; i++) {
      vtx[i] = inp[i] = 0;
      if ( pt->tag[i] & M_REQUIRED )  continue;
      i1 = idir[i+1];
      i2 = idir[i+2];
      pht = hedge(pt->v[i1],pt->v[i2],&kk,&ii);
      if ( !pht )  continue;
      vtx[i] = pht->ind;
      inp[i] = pht->elt;
      if ( vtx[i] ) nbs++;
    }
    if ( !nbs )  continue;
    ret = 1;
    switch(nbs) {
    case 1:
      if ( vtx[0] )
	    ret = split1_a(sm,k,0,vtx,inp);
      else if ( vtx[1] )
	    ret = split1_a(sm,k,1,vtx,inp);
      else
	    ret = split1_a(sm,k,2,vtx,inp);
      break;
    case 2:
      if ( !vtx[0] )
	    ret = split2_a(sm,k,0,vtx,inp);
      else if ( !vtx[1] )
	    ret = split2_a(sm,k,1,vtx,inp);
      else
	    ret = split2_a(sm,k,2,vtx,inp);
      break;
    case 3:
      ret = split3_a(sm,k,vtx,inp);
      break;
    }

	  if ( ret == -1 )  break; 
	  else if ( ret < -1 )  return(0);    
    else if ( sm->ne > sm->nemax-5 ) {
      yerr.coderr = 4001;
      break;
    }
  }

  if ( !updtop(sm) )  return(0);

  E_pop();
  return(sm->ne-nedep);
}
